/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui;

import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.ControllerMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.ui.ActionOperationBatcher;
import ch.cyberduck.ui.Controller;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;

public abstract class AbstractController
implements Controller {
    private static Logger log = Logger.getLogger(AbstractController.class);
    private BackgroundActionRegistry actions = new BackgroundActionRegistry();
    private static ScheduledExecutorService timerPool;

    public void invoke(MainAction runnable) {
        this.invoke(runnable, true);
    }

    public BackgroundActionRegistry getActions() {
        return this.actions;
    }

    public void background(final BackgroundAction runnable) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("background:" + runnable));
        }
        runnable.init();
        this.actions.add(runnable);
        Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = runnable.lock();
                synchronized (object) {
                    ActionOperationBatcher autorelease;
                    block11: {
                        autorelease = AbstractController.this.getBatcher();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Acquired lock for background runnable:" + runnable));
                        }
                        try {
                            if (!runnable.prepare()) break block11;
                            runnable.run();
                        }
                        catch (Throwable e) {
                            try {
                                log.error((Object)("Excpetion running background task:" + e.getMessage()), e);
                            }
                            catch (Throwable throwable) {
                                runnable.finish();
                                AbstractController.this.invoke((MainAction)new ControllerMainAction(AbstractController.this){

                                    public void run() {
                                        runnable.cleanup();
                                    }
                                });
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Releasing lock for background runnable:" + runnable));
                                }
                                autorelease.operate();
                                throw throwable;
                            }
                            runnable.finish();
                            AbstractController.this.invoke((MainAction)new /* invalid duplicate definition of identical inner class */);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Releasing lock for background runnable:" + runnable));
                            }
                            autorelease.operate();
                        }
                    }
                    runnable.finish();
                    AbstractController.this.invoke((MainAction)new /* invalid duplicate definition of identical inner class */);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Releasing lock for background runnable:" + runnable));
                    }
                    autorelease.operate();
                }
            }
        };
        ThreadPool.instance().execute(command);
        if (log.isInfoEnabled()) {
            log.info((Object)("Scheduled background runnable for execution:" + runnable));
        }
    }

    public static ScheduledExecutorService getTimerPool() {
        if (null == timerPool) {
            timerPool = Executors.newScheduledThreadPool(1);
        }
        return timerPool;
    }

    protected ActionOperationBatcher getBatcher() {
        return this.getBatcher(1);
    }

    protected ActionOperationBatcher getBatcher(int size) {
        return new ActionOperationBatcher(){

            public void operate() {
            }
        };
    }
}

