/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui;

import ch.cyberduck.core.Path;
import ch.cyberduck.ui.BrowserComparator;
import ch.cyberduck.ui.FilenameComparator;
import java.text.Collator;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class ExtensionComparator
extends BrowserComparator {
    private Collator impl = Collator.getInstance(Locale.getDefault());

    public ExtensionComparator(boolean ascending) {
        super(ascending, new FilenameComparator(ascending));
    }

    protected int compareFirst(Path p1, Path p2) {
        if (p1.attributes().isDirectory() && p2.attributes().isDirectory()) {
            return 0;
        }
        if (p1.attributes().isFile() && p2.attributes().isFile()) {
            if (StringUtils.isBlank((String)p1.getExtension()) && StringUtils.isBlank((String)p2.getExtension())) {
                return 0;
            }
            if (StringUtils.isBlank((String)p1.getExtension())) {
                return -1;
            }
            if (StringUtils.isBlank((String)p2.getExtension())) {
                return 1;
            }
            if (this.ascending) {
                return this.impl.compare(p1.getExtension(), p2.getExtension());
            }
            return -this.impl.compare(p1.getExtension(), p2.getExtension());
        }
        if (p1.attributes().isFile()) {
            return this.ascending ? 1 : -1;
        }
        return this.ascending ? -1 : 1;
    }

    public String getIdentifier() {
        return "icon";
    }
}

