/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.ui.Pasteboard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathPasteboard
extends Collection<Path>
implements Pasteboard<Path> {
    private static Logger log = Logger.getLogger(PathPasteboard.class);
    private static Map<Session, PathPasteboard> instances = new HashMap<Session, PathPasteboard>(){

        @Override
        public boolean isEmpty() {
            for (PathPasteboard pasteboard : this.values()) {
                if (pasteboard.isEmpty()) continue;
                return false;
            }
            return true;
        }
    };
    private boolean cut;
    private Session session;

    public void setCut(boolean cut) {
        this.cut = cut;
    }

    public void setCopy(boolean copy) {
        this.cut = !copy;
    }

    public boolean isCut() {
        return this.cut;
    }

    public boolean isCopy() {
        return !this.cut;
    }

    public static PathPasteboard getPasteboard(Session session) {
        if (!instances.containsKey(session)) {
            instances.put(session, new PathPasteboard(session));
        }
        return instances.get(session);
    }

    public static List<PathPasteboard> allPasteboards() {
        return new ArrayList<PathPasteboard>(instances.values());
    }

    private PathPasteboard(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public List<Path> copy() {
        return this.copy(SessionFactory.createSession((Host)this.session.getHost()));
    }

    public List<Path> copy(Session session) {
        ArrayList<Path> content = new ArrayList<Path>();
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Path path = (Path)i$.next();
            content.add(PathFactory.createPath((Session)session, (Object)path.getAsDictionary()));
        }
        return content;
    }

    public void delete() {
        instances.remove(this.session);
    }

    @Override
    public void clear() {
        super.clear();
    }
}

