/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.action;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.action.Worker;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChecksumWorker
extends Worker<List<String>> {
    private List<Path> files;

    public ChecksumWorker(List<Path> files) {
        this.files = files;
    }

    @Override
    public List<String> run() {
        ArrayList<String> checksum = new ArrayList<String>();
        for (Path file : this.files) {
            if (StringUtils.isBlank((String)file.attributes().getChecksum())) {
                file.readChecksum();
            }
            checksum.add(file.attributes().getChecksum());
        }
        return checksum;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(Locale.localizedString((String)"Compute MD5 hash of {0}", (String)"Status"), this.toString(this.files));
    }
}

