/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.action;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.action.Worker;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReadAclWorker
extends Worker<List<Acl.UserAndRole>> {
    private List<Path> files;

    public ReadAclWorker(List<Path> files) {
        this.files = files;
    }

    @Override
    public List<Acl.UserAndRole> run() {
        ArrayList<Acl.UserAndRole> updated = new ArrayList<Acl.UserAndRole>();
        for (Path next : this.files) {
            if (Acl.EMPTY.equals((Object)next.attributes().getAcl())) {
                next.readAcl();
            }
            for (Acl.UserAndRole acl : next.attributes().getAcl().asList()) {
                if (updated.contains(acl)) continue;
                updated.add(acl);
            }
        }
        return updated;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(Locale.localizedString((String)"Getting permission of {0}", (String)"Status"), this.toString(this.files));
    }
}

