/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.action;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.action.Worker;
import java.text.MessageFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WritePermissionWorker
extends Worker<Permission> {
    private List<Path> files;
    private Permission permission;
    private boolean recursive;

    public WritePermissionWorker(List<Path> files, Permission permission, boolean recursive) {
        this.files = files;
        this.permission = permission;
        this.recursive = recursive;
    }

    @Override
    public Permission run() {
        for (Path next : this.files) {
            if (!next.getSession().isConnected()) break;
            if (!this.recursive && next.attributes().getPermission().equals((Object)this.permission)) continue;
            if (next.attributes().isFile() && this.recursive) {
                Permission modified = new Permission(this.permission);
                if (!next.attributes().getPermission().getOwnerPermissions()[2]) {
                    modified.getOwnerPermissions()[2] = false;
                }
                if (!next.attributes().getPermission().getGroupPermissions()[2]) {
                    modified.getGroupPermissions()[2] = false;
                }
                if (!next.attributes().getPermission().getOtherPermissions()[2]) {
                    modified.getOtherPermissions()[2] = false;
                }
                next.writeUnixPermission(modified, this.recursive);
                continue;
            }
            next.writeUnixPermission(this.permission, this.recursive);
        }
        return this.permission;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(Locale.localizedString((String)"Changing permission of {0} to {1}", (String)"Status"), this.toString(this.files), this.permission);
    }
}

