/*
 * Decompiled with CFR 0.152.
 */
package com.rackspacecloud.client.cloudfiles;

import com.rackspacecloud.client.cloudfiles.FilesAccountInfo;
import com.rackspacecloud.client.cloudfiles.FilesAuthorizationException;
import com.rackspacecloud.client.cloudfiles.FilesCDNContainer;
import com.rackspacecloud.client.cloudfiles.FilesContainer;
import com.rackspacecloud.client.cloudfiles.FilesContainerExistsException;
import com.rackspacecloud.client.cloudfiles.FilesContainerInfo;
import com.rackspacecloud.client.cloudfiles.FilesContainerNotEmptyException;
import com.rackspacecloud.client.cloudfiles.FilesException;
import com.rackspacecloud.client.cloudfiles.FilesInvalidNameException;
import com.rackspacecloud.client.cloudfiles.FilesNotFoundException;
import com.rackspacecloud.client.cloudfiles.FilesObject;
import com.rackspacecloud.client.cloudfiles.FilesObjectMetaData;
import com.rackspacecloud.client.cloudfiles.FilesResponse;
import com.rackspacecloud.client.cloudfiles.FilesUtil;
import com.rackspacecloud.client.cloudfiles.IFilesTransferCallback;
import com.rackspacecloud.client.cloudfiles.wrapper.RequestEntityWrapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.text.StrTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesClient {
    public static final String VERSION = "v1";
    private String username = null;
    private String password = null;
    private String account = null;
    private String authenticationURL;
    private int connectionTimeOut;
    private String storageURL = null;
    private String cdnManagementURL = null;
    private String authToken = null;
    private boolean isLoggedin = false;
    private boolean useETag = true;
    private boolean snet = false;
    private String snetAddr = "https://snet-";
    private HttpClient client = null;
    private static Logger logger = Logger.getLogger(FilesClient.class);

    public FilesClient(HttpClient client, String username, String password, String authUrl, String account, int connectionTimeOut) {
        this.client = client;
        this.username = username;
        this.password = password;
        this.account = account;
        if (authUrl == null) {
            authUrl = FilesUtil.getProperty("auth_url");
        }
        this.authenticationURL = account != null && account.length() > 0 ? authUrl + VERSION + "/" + account + FilesUtil.getProperty("auth_url_post") : authUrl;
        this.connectionTimeOut = connectionTimeOut;
        this.setUserAgent("java-cloudfiles/1.8.0");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UserName: " + this.username));
            logger.debug((Object)("AuthenticationURL: " + this.authenticationURL));
            logger.debug((Object)("ConnectionTimeOut: " + this.connectionTimeOut));
        }
    }

    public FilesClient(String username, String password, String authUrl, String account, final int connectionTimeOut) {
        this((HttpClient)new DefaultHttpClient(){

            protected HttpParams createHttpParams() {
                BasicHttpParams params = new BasicHttpParams();
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)connectionTimeOut);
                params.setParameter("http.socket.timeout", (Object)connectionTimeOut);
                return params;
            }

            protected ClientConnectionManager createClientConnectionManager() {
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
                schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
                return new ThreadSafeClientConnManager(this.createHttpParams(), schemeRegistry);
            }
        }, username, password, authUrl, account, connectionTimeOut);
    }

    public FilesClient(String username, String password, String authUrl) {
        this(username, password, authUrl, null, FilesUtil.getIntProperty("connection_timeout"));
    }

    public FilesClient(String username, String apiAccessKey) {
        this(username, apiAccessKey, null, null, FilesUtil.getIntProperty("connection_timeout"));
    }

    public FilesClient() {
        this(FilesUtil.getProperty("username"), FilesUtil.getProperty("password"), null, FilesUtil.getProperty("account"), FilesUtil.getIntProperty("connection_timeout"));
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
        this.authenticationURL = account != null && account.length() > 0 ? FilesUtil.getProperty("auth_url") + VERSION + "/" + account + FilesUtil.getProperty("auth_url_post") : FilesUtil.getProperty("auth_url");
    }

    public boolean login() throws IOException, HttpException {
        HttpGet method = new HttpGet(this.authenticationURL);
        method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
        method.setHeader(FilesUtil.getProperty("auth_user_header", "x-auth-user"), this.username);
        method.setHeader(FilesUtil.getProperty("auth_pass_header", "x-auth-key"), this.password);
        FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
        if (response.loginSuccess()) {
            this.isLoggedin = true;
            this.storageURL = this.usingSnet() || this.envSnet() ? this.snetAddr + response.getStorageURL().substring(8) : response.getStorageURL();
            this.cdnManagementURL = response.getCDNManagementURL();
            this.authToken = response.getAuthToken();
            logger.debug((Object)("storageURL: " + this.storageURL));
            logger.debug((Object)("authToken: " + this.authToken));
            logger.debug((Object)("cdnManagementURL:" + this.cdnManagementURL));
            logger.debug((Object)("ConnectionManager:" + this.client.getConnectionManager()));
        }
        method.abort();
        return this.isLoggedin;
    }

    public List<FilesContainerInfo> listContainersInfo() throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listContainersInfo(-1, null);
    }

    public List<FilesContainerInfo> listContainersInfo(int limit) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listContainersInfo(limit, null);
    }

    public List<FilesContainerInfo> listContainersInfo(int limit, String marker) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        if (!this.isLoggedin()) {
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        HttpGet method = null;
        try {
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            if (limit > 0) {
                parameters.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(limit)));
            }
            if (marker != null) {
                parameters.add((NameValuePair)new BasicNameValuePair("marker", marker));
            }
            parameters.add((NameValuePair)new BasicNameValuePair("format", "xml"));
            String uri = this.makeURI(this.storageURL, parameters);
            method = new HttpGet(uri);
            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
            method.setHeader("X-Auth-Token", this.authToken);
            FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
            if (response.getStatusCode() == 401) {
                method.removeHeaders("X-Auth-Token");
                if (this.login()) {
                    method = new HttpGet(uri);
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                } else {
                    throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                }
            }
            if (response.getStatusCode() == 200) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(response.getResponseBodyAsStream());
                NodeList nodes = document.getChildNodes();
                Node accountNode = nodes.item(0);
                if (!"account".equals(accountNode.getNodeName())) {
                    logger.error((Object)"Got unexpected type of XML");
                    List<FilesContainerInfo> list = null;
                    return list;
                }
                ArrayList<FilesContainerInfo> containerList = new ArrayList<FilesContainerInfo>();
                NodeList containerNodes = accountNode.getChildNodes();
                for (int i = 0; i < containerNodes.getLength(); ++i) {
                    Node containerNode = containerNodes.item(i);
                    if (!"container".equals(containerNode.getNodeName())) continue;
                    String name = null;
                    int count = -1;
                    long size = -1L;
                    NodeList objectData = containerNode.getChildNodes();
                    for (int j = 0; j < objectData.getLength(); ++j) {
                        Node data = objectData.item(j);
                        if ("name".equals(data.getNodeName())) {
                            name = data.getTextContent();
                            continue;
                        }
                        if ("bytes".equals(data.getNodeName())) {
                            size = Long.parseLong(data.getTextContent());
                            continue;
                        }
                        if ("count".equals(data.getNodeName())) {
                            count = Integer.parseInt(data.getTextContent());
                            continue;
                        }
                        logger.debug((Object)("Unexpected container-info tag:" + data.getNodeName()));
                    }
                    if (name == null) continue;
                    FilesContainerInfo obj = new FilesContainerInfo(name, count, size);
                    containerList.add(obj);
                }
                ArrayList<FilesContainerInfo> arrayList = containerList;
                return arrayList;
            }
            if (response.getStatusCode() == 204) {
                ArrayList<FilesContainerInfo> arrayList = new ArrayList<FilesContainerInfo>();
                return arrayList;
            }
            try {
                if (response.getStatusCode() == 404) {
                    throw new FilesNotFoundException("Account not Found", response.getResponseHeaders(), response.getStatusLine());
                }
                throw new FilesException("Unexpected Return Code", response.getResponseHeaders(), response.getStatusLine());
            }
            catch (Exception ex) {
                throw new FilesException("Unexpected problem, probably in parsing Server XML", ex);
            }
        }
        finally {
            if (method != null) {
                method.abort();
            }
        }
    }

    public List<FilesContainer> listContainers() throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listContainers(-1, null);
    }

    public List<FilesContainer> listContainers(int limit) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listContainers(limit, null);
    }

    public List<FilesContainer> listContainers(int limit, String marker) throws IOException, HttpException, FilesException {
        if (!this.isLoggedin()) {
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        HttpGet method = null;
        try {
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            if (limit > 0) {
                parameters.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(limit)));
            }
            if (marker != null) {
                parameters.add((NameValuePair)new BasicNameValuePair("marker", marker));
            }
            String uri = parameters.size() > 0 ? this.makeURI(this.storageURL, parameters) : this.storageURL;
            method = new HttpGet(uri);
            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
            method.setHeader("X-Auth-Token", this.authToken);
            FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
            if (response.getStatusCode() == 401) {
                method.abort();
                if (this.login()) {
                    method = new HttpGet(uri);
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                } else {
                    throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                }
            }
            if (response.getStatusCode() == 200) {
                StrTokenizer tokenize = new StrTokenizer(response.getResponseBodyAsString());
                tokenize.setDelimiterString("\n");
                String[] containers = tokenize.getTokenArray();
                ArrayList<FilesContainer> containerList = new ArrayList<FilesContainer>();
                for (String container : containers) {
                    containerList.add(new FilesContainer(container, this));
                }
                ArrayList<FilesContainer> arrayList = containerList;
                return arrayList;
            }
            if (response.getStatusCode() == 204) {
                ArrayList<FilesContainer> arrayList = new ArrayList<FilesContainer>();
                return arrayList;
            }
            try {
                if (response.getStatusCode() == 404) {
                    throw new FilesNotFoundException("Account was not found", response.getResponseHeaders(), response.getStatusLine());
                }
                throw new FilesException("Unexpected resposne from server", response.getResponseHeaders(), response.getStatusLine());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new FilesException("Unexpected error, probably parsing Server XML", ex);
            }
        }
        finally {
            if (method != null) {
                method.abort();
            }
        }
    }

    public List<FilesObject> listObjectsStartingWith(String container, String startsWith, String path, int limit, String marker) throws IOException, FilesException {
        return this.listObjectsStartingWith(container, startsWith, path, limit, marker, null);
    }

    public List<FilesObject> listObjectsStartingWith(String container, String startsWith, String path, int limit, String marker, Character delimiter) throws IOException, FilesException {
        if (!this.isLoggedin()) {
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        if (!this.isValidContainerName(container)) {
            throw new FilesInvalidNameException(container);
        }
        HttpGet method = null;
        try {
            LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
            parameters.add((NameValuePair)new BasicNameValuePair("format", "xml"));
            if (startsWith != null) {
                parameters.add((NameValuePair)new BasicNameValuePair("prefix", startsWith));
            }
            if (path != null) {
                parameters.add((NameValuePair)new BasicNameValuePair("path", path));
            }
            if (limit > 0) {
                parameters.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(limit)));
            }
            if (marker != null) {
                parameters.add((NameValuePair)new BasicNameValuePair("marker", marker));
            }
            if (delimiter != null) {
                parameters.add((NameValuePair)new BasicNameValuePair("delimiter", delimiter.toString()));
            }
            String uri = parameters.size() > 0 ? this.makeURI(this.storageURL + "/" + FilesClient.sanitizeForURI(container), parameters) : this.storageURL;
            method = new HttpGet(uri);
            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
            method.setHeader("X-Auth-Token", this.authToken);
            FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
            if (response.getStatusCode() == 401) {
                method.removeHeaders("X-Auth-Token");
                if (this.login()) {
                    method = new HttpGet(uri);
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                } else {
                    throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                }
            }
            if (response.getStatusCode() == 200) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(response.getResponseBodyAsStream());
                NodeList nodes = document.getChildNodes();
                Node containerList = nodes.item(0);
                if (!"container".equals(containerList.getNodeName())) {
                    logger.error((Object)"Got unexpected type of XML");
                    List<FilesObject> list = null;
                    return list;
                }
                ArrayList<FilesObject> objectList = new ArrayList<FilesObject>();
                NodeList objectNodes = containerList.getChildNodes();
                for (int i = 0; i < objectNodes.getLength(); ++i) {
                    Node objectNode = objectNodes.item(i);
                    String nodeName = objectNode.getNodeName();
                    if (!"object".equals(nodeName) && !"subdir".equals(nodeName)) continue;
                    String name = null;
                    String eTag = null;
                    long size = -1L;
                    String mimeType = null;
                    String lastModified = null;
                    NodeList objectData = objectNode.getChildNodes();
                    if ("subdir".equals(nodeName)) {
                        size = 0L;
                        mimeType = "application/directory";
                        name = objectNode.getAttributes().getNamedItem("name").getNodeValue();
                    }
                    for (int j = 0; j < objectData.getLength(); ++j) {
                        Node data = objectData.item(j);
                        if ("name".equals(data.getNodeName())) {
                            name = data.getTextContent();
                            continue;
                        }
                        if ("content_type".equals(data.getNodeName())) {
                            mimeType = data.getTextContent();
                            continue;
                        }
                        if ("hash".equals(data.getNodeName())) {
                            eTag = data.getTextContent();
                            continue;
                        }
                        if ("bytes".equals(data.getNodeName())) {
                            size = Long.parseLong(data.getTextContent());
                            continue;
                        }
                        if ("last_modified".equals(data.getNodeName())) {
                            lastModified = data.getTextContent();
                            continue;
                        }
                        logger.warn((Object)("Unexpected tag:" + data.getNodeName()));
                    }
                    if (name == null) continue;
                    FilesObject obj = new FilesObject(name, container, this);
                    if (eTag != null) {
                        obj.setMd5sum(eTag);
                    }
                    if (mimeType != null) {
                        obj.setMimeType(mimeType);
                    }
                    if (size >= 0L) {
                        obj.setSize(size);
                    }
                    if (lastModified != null) {
                        obj.setLastModified(lastModified);
                    }
                    objectList.add(obj);
                }
                ArrayList<FilesObject> arrayList = objectList;
                return arrayList;
            }
            if (response.getStatusCode() == 204) {
                logger.debug((Object)("Container " + container + " has no Objects"));
                ArrayList<FilesObject> arrayList = new ArrayList<FilesObject>();
                return arrayList;
            }
            try {
                if (response.getStatusCode() == 404) {
                    throw new FilesNotFoundException("Container was not found", response.getResponseHeaders(), response.getStatusLine());
                }
                throw new FilesException("Unexpected Server Result", response.getResponseHeaders(), response.getStatusLine());
            }
            catch (FilesNotFoundException fnfe) {
                throw fnfe;
            }
            catch (Exception ex) {
                logger.error((Object)"Error parsing xml", (Throwable)ex);
                throw new FilesException("Error parsing server resposne", ex);
            }
        }
        finally {
            if (method != null) {
                method.abort();
            }
        }
    }

    public List<FilesObject> listObjects(String container) throws IOException, FilesAuthorizationException, FilesException {
        return this.listObjectsStartingWith(container, null, null, -1, null, null);
    }

    public List<FilesObject> listObjects(String container, Character delimiter) throws IOException, FilesAuthorizationException, FilesException {
        return this.listObjectsStartingWith(container, null, null, -1, null, delimiter);
    }

    public List<FilesObject> listObjects(String container, int limit) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStartingWith(container, null, null, limit, null, null);
    }

    public List<FilesObject> listObjects(String container, String path) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStartingWith(container, null, path, -1, null, null);
    }

    public List<FilesObject> listObjects(String container, String path, Character delimiter) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStartingWith(container, null, path, -1, null, delimiter);
    }

    public List<FilesObject> listObjects(String container, String path, int limit) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStartingWith(container, null, path, limit, null);
    }

    public List<FilesObject> listObjects(String container, String path, int limit, String marker) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStartingWith(container, null, path, limit, marker);
    }

    public List<FilesObject> listObjects(String container, int limit, String marker) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        return this.listObjectsStartingWith(container, null, null, limit, marker);
    }

    public boolean containerExists(String container) throws IOException, HttpException {
        try {
            this.getContainerInfo(container);
            return true;
        }
        catch (FilesException fnfe) {
            return false;
        }
    }

    public FilesAccountInfo getAccountInfo() throws IOException, HttpException, FilesAuthorizationException, FilesException {
        if (this.isLoggedin()) {
            HttpHead method = null;
            try {
                method = new HttpHead(this.storageURL);
                method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                method.setHeader("X-Auth-Token", this.authToken);
                FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                if (response.getStatusCode() == 401) {
                    method.removeHeaders("X-Auth-Token");
                    if (this.login()) {
                        method.abort();
                        method = new HttpHead(this.storageURL);
                        method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                        method.setHeader("X-Auth-Token", this.authToken);
                        response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    } else {
                        throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                    }
                }
                if (response.getStatusCode() == 204) {
                    int nContainers = response.getAccountContainerCount();
                    long totalSize = response.getAccountBytesUsed();
                    FilesAccountInfo filesAccountInfo = new FilesAccountInfo(totalSize, nContainers);
                    return filesAccountInfo;
                }
                throw new FilesException("Unexpected return from server", response.getResponseHeaders(), response.getStatusLine());
            }
            finally {
                if (method != null) {
                    method.abort();
                }
            }
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public FilesContainerInfo getContainerInfo(String container) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            if (this.isValidContainerName(container)) {
                HttpHead method = null;
                try {
                    method = new HttpHead(this.storageURL + "/" + FilesClient.sanitizeForURI(container));
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    if (response.getStatusCode() == 401) {
                        method.removeHeaders("X-Auth-Token");
                        if (this.login()) {
                            method = new HttpHead(this.storageURL + "/" + FilesClient.sanitizeForURI(container));
                            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                            method.setHeader("X-Auth-Token", this.authToken);
                            response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                        } else {
                            throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 204) {
                        int objCount = response.getContainerObjectCount();
                        long objSize = response.getContainerBytesUsed();
                        FilesContainerInfo filesContainerInfo = new FilesContainerInfo(container, objCount, objSize);
                        return filesContainerInfo;
                    }
                    if (response.getStatusCode() == 404) {
                        throw new FilesNotFoundException("Container not found: " + container, response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected result from server", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    if (method != null) {
                        method.abort();
                    }
                }
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public void createContainer(String name) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        if (this.isLoggedin()) {
            if (this.isValidContainerName(name)) {
                HttpPut method = new HttpPut(this.storageURL + "/" + FilesClient.sanitizeForURI(name));
                method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                method.setHeader("X-Auth-Token", this.authToken);
                try {
                    FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    if (response.getStatusCode() == 401) {
                        method.abort();
                        if (this.login()) {
                            method = new HttpPut(this.storageURL + "/" + FilesClient.sanitizeForURI(name));
                            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                            method.setHeader("X-Auth-Token", this.authToken);
                            response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                        } else {
                            throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 201) {
                        return;
                    }
                    if (response.getStatusCode() == 202) {
                        throw new FilesContainerExistsException(name, response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected Response", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    method.abort();
                }
            }
            throw new FilesInvalidNameException(name);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteContainer(String name) throws IOException, HttpException, FilesAuthorizationException, FilesInvalidNameException, FilesNotFoundException, FilesContainerNotEmptyException {
        block12: {
            if (this.isLoggedin()) {
                if (this.isValidContainerName(name)) {
                    HttpDelete method = new HttpDelete(this.storageURL + "/" + FilesClient.sanitizeForURI(name));
                    try {
                        method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                        method.setHeader("X-Auth-Token", this.authToken);
                        FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                        if (response.getStatusCode() == 401) {
                            method.abort();
                            if (this.login()) {
                                method = new HttpDelete(this.storageURL + "/" + FilesClient.sanitizeForURI(name));
                                method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                                method.setHeader("X-Auth-Token", this.authToken);
                                response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                            } else {
                                throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                            }
                        }
                        if (response.getStatusCode() == 204) {
                            logger.debug((Object)("Container Deleted : " + name));
                            boolean bl = true;
                            return bl;
                        }
                        if (response.getStatusCode() == 404) {
                            logger.debug((Object)"Container does not exist !");
                            throw new FilesNotFoundException("You can't delete an non-empty container", response.getResponseHeaders(), response.getStatusLine());
                        }
                        if (response.getStatusCode() == 409) {
                            logger.debug((Object)"Container is not empty, can not delete a none empty container !");
                            throw new FilesContainerNotEmptyException("You can't delete an non-empty container", response.getResponseHeaders(), response.getStatusLine());
                        }
                        break block12;
                    }
                    finally {
                        method.abort();
                    }
                }
                throw new FilesInvalidNameException(name);
            }
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cdnEnableContainer(String name) throws IOException, HttpException, FilesException {
        String returnValue;
        block10: {
            returnValue = null;
            if (this.isLoggedin()) {
                if (this.isValidContainerName(name)) {
                    HttpPut method = null;
                    try {
                        method = new HttpPut(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(name));
                        method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                        method.setHeader("X-Auth-Token", this.authToken);
                        FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                        if (response.getStatusCode() == 401) {
                            method.abort();
                            if (this.login()) {
                                method = new HttpPut(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(name));
                                method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                                method.setHeader("X-Auth-Token", this.authToken);
                                response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                            } else {
                                throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                            }
                        }
                        if (response.getStatusCode() == 201 || response.getStatusCode() == 202) {
                            returnValue = response.getCdnUrl();
                            break block10;
                        }
                        if (response.getStatusCode() == 401) {
                            logger.warn((Object)"Unauthorized access");
                            throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                        }
                        throw new FilesException("Unexpected Server Response", response.getResponseHeaders(), response.getStatusLine());
                    }
                    finally {
                        method.abort();
                    }
                }
                throw new FilesInvalidNameException(name);
            }
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        return returnValue;
    }

    public String cdnUpdateContainer(String name, int ttl, boolean enabled, boolean retainLogs) throws IOException, HttpException, FilesException {
        return this.cdnUpdateContainer(name, ttl, enabled, null, null, retainLogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cdnUpdateContainer(String name, int ttl, boolean enabled, String referrerAcl, String userAgentACL, boolean retainLogs) throws IOException, HttpException, FilesException {
        String returnValue;
        block15: {
            returnValue = null;
            if (this.isLoggedin()) {
                if (this.isValidContainerName(name)) {
                    HttpPost method = null;
                    try {
                        FilesResponse response;
                        method = new HttpPost(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(name));
                        method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                        method.setHeader("X-Auth-Token", this.authToken);
                        if (ttl > 0) {
                            method.setHeader("X-TTL", Integer.toString(ttl));
                        }
                        method.setHeader("X-CDN-Enabled", Boolean.toString(enabled));
                        method.setHeader("X-Log-Retention", Boolean.toString(retainLogs));
                        if (referrerAcl != null) {
                            method.setHeader("X-Referrer-ACL ", referrerAcl);
                        }
                        if (userAgentACL != null) {
                            method.setHeader("X-User-Agent-ACL", userAgentACL);
                        }
                        if ((response = new FilesResponse(this.client.execute((HttpUriRequest)method))).getStatusCode() == 401) {
                            method.abort();
                            if (this.login()) {
                                new HttpPost(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(name));
                                method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                                method.setHeader("X-Auth-Token", this.authToken);
                                if (ttl > 0) {
                                    method.setHeader("X-TTL", Integer.toString(ttl));
                                }
                                method.setHeader("X-CDN-Enabled", Boolean.toString(enabled));
                                response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                            } else {
                                throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                            }
                        }
                        if (response.getStatusCode() == 202) {
                            returnValue = response.getCdnUrl();
                            break block15;
                        }
                        if (response.getStatusCode() == 401) {
                            logger.warn((Object)"Unauthorized access");
                            throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                        }
                        throw new FilesException("Unexpected Server Response", response.getResponseHeaders(), response.getStatusLine());
                    }
                    finally {
                        if (method != null) {
                            method.abort();
                        }
                    }
                }
                throw new FilesInvalidNameException(name);
            }
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        return returnValue;
    }

    public FilesCDNContainer getCDNContainerInfo(String container) throws IOException, FilesNotFoundException, HttpException, FilesException {
        if (this.isLoggedin()) {
            if (this.isValidContainerName(container)) {
                HttpHead method = null;
                try {
                    method = new HttpHead(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(container));
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    if (response.getStatusCode() == 401) {
                        method.abort();
                        if (this.login()) {
                            method = new HttpHead(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(container));
                            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                            method.setHeader("X-Auth-Token", this.authToken);
                            response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                        } else {
                            throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 204) {
                        FilesCDNContainer result = new FilesCDNContainer(response.getCdnUrl());
                        result.setName(container);
                        for (Header hdr : response.getResponseHeaders()) {
                            String name = hdr.getName().toLowerCase();
                            if ("x-cdn-enabled".equals(name)) {
                                result.setEnabled(Boolean.valueOf(hdr.getValue()));
                                continue;
                            }
                            if ("x-log-retention".equals(name)) {
                                result.setRetainLogs(Boolean.valueOf(hdr.getValue()));
                                continue;
                            }
                            if ("x-ttl".equals(name)) {
                                result.setTtl(Integer.parseInt(hdr.getValue()));
                                continue;
                            }
                            if ("x-referrer-acl".equals(name)) {
                                result.setReferrerACL(hdr.getValue());
                                continue;
                            }
                            if (!"x-user-agent-acl".equals(name)) continue;
                            result.setUserAgentACL(hdr.getValue());
                        }
                        FilesCDNContainer filesCDNContainer = result;
                        return filesCDNContainer;
                    }
                    if (response.getStatusCode() == 401) {
                        logger.warn((Object)"Unauthorized access");
                        throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                    }
                    if (response.getStatusCode() == 404) {
                        throw new FilesNotFoundException("Container is not CDN enabled", response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected result from server: ", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    if (method != null) {
                        method.abort();
                    }
                }
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public boolean isCDNEnabled(String container) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            if (this.isValidContainerName(container)) {
                HttpHead method = null;
                try {
                    method = new HttpHead(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(container));
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    if (response.getStatusCode() == 401) {
                        method.abort();
                        if (this.login()) {
                            method = new HttpHead(this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(container));
                            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                            method.setHeader("X-Auth-Token", this.authToken);
                            response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                        } else {
                            throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 204) {
                        for (Header hdr : response.getResponseHeaders()) {
                            String name = hdr.getName().toLowerCase();
                            if (!"x-cdn-enabled".equals(name)) continue;
                            boolean bl = Boolean.valueOf(hdr.getValue());
                            return bl;
                        }
                        throw new FilesException("Server did not return X-CDN-Enabled header: ", response.getResponseHeaders(), response.getStatusLine());
                    }
                    if (response.getStatusCode() == 401) {
                        logger.warn((Object)"Unauthorized access");
                        throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                    }
                    if (response.getStatusCode() == 404) {
                        boolean bl = false;
                        return bl;
                    }
                    throw new FilesException("Unexpected result from server: ", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    if (method != null) {
                        method.abort();
                    }
                }
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public void createPath(String container, String path) throws HttpException, IOException, FilesException {
        if (!this.isValidContainerName(container)) {
            throw new FilesInvalidNameException(container);
        }
        if (!this.isValidObjectName(path)) {
            throw new FilesInvalidNameException(path);
        }
        this.storeObject(container, new byte[0], "application/directory", path, new HashMap<String, String>());
    }

    public void createFullPath(String container, String path) throws HttpException, IOException, FilesException {
        String[] parts = path.split("/");
        for (int i = 0; i < parts.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j <= i; ++j) {
                if (sb.length() != 0) {
                    sb.append("/");
                }
                sb.append(parts[j]);
            }
            this.createPath(container, sb.toString());
        }
    }

    public List<String> listCdnContainers(int limit) throws IOException, HttpException, FilesException {
        return this.listCdnContainers(limit, null);
    }

    public List<String> listCdnContainers() throws IOException, HttpException, FilesException {
        return this.listCdnContainers(-1, null);
    }

    public List<String> listCdnContainers(int limit, String marker) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            HttpGet method = null;
            try {
                LinkedList<NameValuePair> params = new LinkedList<NameValuePair>();
                if (limit > 0) {
                    params.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(limit)));
                }
                if (marker != null) {
                    params.add((NameValuePair)new BasicNameValuePair("marker", marker));
                }
                String uri = params.size() > 0 ? this.makeURI(this.cdnManagementURL, params) : this.cdnManagementURL;
                method = new HttpGet(uri);
                method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                method.setHeader("X-Auth-Token", this.authToken);
                FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                if (response.getStatusCode() == 401) {
                    method.abort();
                    if (this.login()) {
                        method = new HttpGet(uri);
                        method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                        method.setHeader("X-Auth-Token", this.authToken);
                        response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    } else {
                        throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                    }
                }
                if (response.getStatusCode() == 200) {
                    StrTokenizer tokenize = new StrTokenizer(response.getResponseBodyAsString());
                    tokenize.setDelimiterString("\n");
                    String[] containers = tokenize.getTokenArray();
                    ArrayList<String> returnValue = new ArrayList<String>();
                    for (String containerName : containers) {
                        returnValue.add(containerName);
                    }
                    ArrayList<String> arrayList = returnValue;
                    return arrayList;
                }
                if (response.getStatusCode() == 401) {
                    logger.warn((Object)"Unauthorized access");
                    throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                }
                throw new FilesException("Unexpected server response", response.getResponseHeaders(), response.getStatusLine());
            }
            finally {
                if (method != null) {
                    method.abort();
                }
            }
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public void purgeCDNContainer(String container, String emailAddresses) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        if (!this.isLoggedin) {
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        if (!this.isValidContainerName(container)) {
            throw new FilesInvalidNameException(container);
        }
        HttpDelete method = null;
        try {
            FilesResponse response;
            String deleteUri = this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(container);
            method = new HttpDelete(deleteUri);
            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
            method.setHeader("X-Auth-Token", this.authToken);
            if (emailAddresses != null) {
                method.setHeader("X-Purge-Email", emailAddresses);
            }
            if ((response = new FilesResponse(this.client.execute((HttpUriRequest)method))).getStatusCode() == 401) {
                method.abort();
                if (this.login()) {
                    method = new HttpDelete(deleteUri);
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    if (emailAddresses != null) {
                        method.setHeader("X-Purge-Email", emailAddresses);
                    }
                    response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                } else {
                    throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                }
            }
            if (response.getStatusCode() == 204) {
                return;
            }
            if (response.getStatusCode() == 401) {
                throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
            }
            throw new FilesException("Unexpected server response", response.getResponseHeaders(), response.getStatusLine());
        }
        finally {
            if (method != null) {
                method.abort();
            }
        }
    }

    public void purgeCDNObject(String container, String object, String emailAddresses) throws IOException, HttpException, FilesAuthorizationException, FilesException {
        if (!this.isLoggedin) {
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        if (!this.isValidContainerName(container)) {
            throw new FilesInvalidNameException(container);
        }
        HttpDelete method = null;
        try {
            FilesResponse response;
            String deleteUri = this.cdnManagementURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(object);
            method = new HttpDelete(deleteUri);
            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
            method.setHeader("X-Auth-Token", this.authToken);
            if (emailAddresses != null) {
                method.setHeader("X-Purge-Email", emailAddresses);
            }
            if ((response = new FilesResponse(this.client.execute((HttpUriRequest)method))).getStatusCode() == 401) {
                method.abort();
                if (this.login()) {
                    method = new HttpDelete(deleteUri);
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    if (emailAddresses != null) {
                        method.setHeader("X-Purge-Email", emailAddresses);
                    }
                    response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                } else {
                    throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                }
            }
            if (response.getStatusCode() == 204) {
                return;
            }
            if (response.getStatusCode() == 401) {
                throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
            }
            throw new FilesException("Unexpected server response", response.getResponseHeaders(), response.getStatusLine());
        }
        finally {
            if (method != null) {
                method.abort();
            }
        }
    }

    public List<FilesCDNContainer> listCdnContainerInfo() throws IOException, HttpException, FilesException {
        return this.listCdnContainerInfo(-1, null);
    }

    public List<FilesCDNContainer> listCdnContainerInfo(int limit) throws IOException, HttpException, FilesException {
        return this.listCdnContainerInfo(limit, null);
    }

    public List<FilesCDNContainer> listCdnContainerInfo(int limit, String marker) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            HttpGet method = null;
            try {
                LinkedList<NameValuePair> params = new LinkedList<NameValuePair>();
                params.add((NameValuePair)new BasicNameValuePair("format", "xml"));
                if (limit > 0) {
                    params.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(limit)));
                }
                if (marker != null) {
                    params.add((NameValuePair)new BasicNameValuePair("marker", marker));
                }
                String uri = params.size() > 0 ? this.makeURI(this.cdnManagementURL, params) : this.cdnManagementURL;
                method = new HttpGet(uri);
                method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                method.setHeader("X-Auth-Token", this.authToken);
                FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                if (response.getStatusCode() == 401) {
                    method.abort();
                    if (this.login()) {
                        method = new HttpGet(uri);
                        method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                        method.setHeader("X-Auth-Token", this.authToken);
                        response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    } else {
                        throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                    }
                }
                if (response.getStatusCode() == 200) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(response.getResponseBodyAsStream());
                    NodeList nodes = document.getChildNodes();
                    Node accountNode = nodes.item(0);
                    if (!"account".equals(accountNode.getNodeName())) {
                        logger.error((Object)"Got unexpected type of XML");
                        List<FilesCDNContainer> list = null;
                        return list;
                    }
                    ArrayList<FilesCDNContainer> containerList = new ArrayList<FilesCDNContainer>();
                    NodeList containerNodes = accountNode.getChildNodes();
                    for (int i = 0; i < containerNodes.getLength(); ++i) {
                        Node containerNode = containerNodes.item(i);
                        if (!"container".equals(containerNode.getNodeName())) continue;
                        FilesCDNContainer container = new FilesCDNContainer();
                        NodeList objectData = containerNode.getChildNodes();
                        for (int j = 0; j < objectData.getLength(); ++j) {
                            Node data = objectData.item(j);
                            if ("name".equals(data.getNodeName())) {
                                container.setName(data.getTextContent());
                                continue;
                            }
                            if ("cdn_url".equals(data.getNodeName())) {
                                container.setCdnURL(data.getTextContent());
                                continue;
                            }
                            if ("cdn_enabled".equals(data.getNodeName())) {
                                container.setEnabled(Boolean.parseBoolean(data.getTextContent()));
                                continue;
                            }
                            if ("log_retention".equals(data.getNodeName())) {
                                container.setRetainLogs(Boolean.parseBoolean(data.getTextContent()));
                                continue;
                            }
                            if ("ttl".equals(data.getNodeName())) {
                                container.setTtl(Integer.parseInt(data.getTextContent()));
                                continue;
                            }
                            if ("referrer_acl".equals(data.getNodeName())) {
                                container.setReferrerACL(data.getTextContent());
                                continue;
                            }
                            if (!"useragent_acl".equals(data.getNodeName())) continue;
                            container.setUserAgentACL(data.getTextContent());
                        }
                        if (container.getName() == null) continue;
                        containerList.add(container);
                    }
                    ArrayList<FilesCDNContainer> arrayList = containerList;
                    return arrayList;
                }
                try {
                    if (response.getStatusCode() == 401) {
                        logger.warn((Object)"Unauthorized access");
                        throw new FilesAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected server response", response.getResponseHeaders(), response.getStatusLine());
                }
                catch (SAXException ex) {
                    throw new FilesException("Problem parsing XML", ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new FilesException("Problem parsing XML", ex);
                }
            }
            finally {
                if (method != null) {
                    method.abort();
                }
            }
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public String storeObjectAs(String container, File obj, String contentType, String name) throws IOException, HttpException, FilesException {
        return this.storeObjectAs(container, obj, contentType, name, new HashMap<String, String>(), null);
    }

    public String storeObjectAs(String container, File obj, String contentType, String name, IFilesTransferCallback callback) throws IOException, HttpException, FilesException {
        return this.storeObjectAs(container, obj, contentType, name, new HashMap<String, String>(), callback);
    }

    public String storeObjectAs(String container, File obj, String contentType, String name, Map<String, String> metadata) throws IOException, HttpException, FilesException {
        return this.storeObjectAs(container, obj, contentType, name, metadata, null);
    }

    public String storeObjectAs(String container, File obj, String contentType, String name, Map<String, String> metadata, IFilesTransferCallback callback) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            if (this.isValidContainerName(container) && this.isValidObjectName(name)) {
                if (!obj.exists()) {
                    throw new FileNotFoundException(name + " does not exist");
                }
                if (obj.isDirectory()) {
                    throw new IOException("The alleged file was a directory");
                }
                HttpPut method = null;
                try {
                    method = new HttpPut(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(name));
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    if (this.useETag) {
                        method.setHeader("ETag", FilesClient.md5Sum(obj));
                    }
                    method.setEntity((HttpEntity)new RequestEntityWrapper((HttpEntity)new FileEntity(obj, contentType), callback));
                    for (String key : metadata.keySet()) {
                        method.setHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                    }
                    FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    if (response.getStatusCode() == 401) {
                        method.abort();
                        if (this.login()) {
                            method = new HttpPut(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(name));
                            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                            method.setHeader("X-Auth-Token", this.authToken);
                            if (this.useETag) {
                                method.setHeader("ETag", FilesClient.md5Sum(obj));
                            }
                            method.setEntity((HttpEntity)new RequestEntityWrapper((HttpEntity)new FileEntity(obj, contentType), callback));
                            for (String key : metadata.keySet()) {
                                method.setHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                            }
                            response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                        } else {
                            throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 201) {
                        String string = response.getResponseHeader("ETag").getValue();
                        return string;
                    }
                    if (response.getStatusCode() == 412) {
                        throw new FilesException("Etag missmatch", response.getResponseHeaders(), response.getStatusLine());
                    }
                    if (response.getStatusCode() == 411) {
                        throw new FilesException("Length miss-match", response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected Server Response", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    if (method != null) {
                        method.abort();
                    }
                }
            }
            if (!this.isValidObjectName(name)) {
                throw new FilesInvalidNameException(name);
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public String storeObject(String container, File obj, String contentType) throws IOException, HttpException, FilesException {
        return this.storeObjectAs(container, obj, contentType, obj.getName());
    }

    public boolean storeObject(String container, byte[] obj, String contentType, String name, Map<String, String> metadata) throws IOException, HttpException, FilesException {
        return this.storeObject(container, obj, contentType, name, metadata, null);
    }

    public boolean storeObject(String container, byte[] obj, String contentType, String name, Map<String, String> metadata, IFilesTransferCallback callback) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            String objName = name;
            if (this.isValidContainerName(container) && this.isValidObjectName(objName)) {
                HttpPut method = null;
                try {
                    method = new HttpPut(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    if (this.useETag) {
                        method.setHeader("ETag", FilesClient.md5Sum(obj));
                    }
                    ByteArrayEntity entity = new ByteArrayEntity(obj);
                    entity.setContentType(contentType);
                    method.setEntity((HttpEntity)new RequestEntityWrapper((HttpEntity)entity, callback));
                    for (String key : metadata.keySet()) {
                        method.setHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                    }
                    FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    if (response.getStatusCode() == 401) {
                        method.abort();
                        if (this.login()) {
                            method = new HttpPut(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                            method.setHeader("X-Auth-Token", this.authToken);
                            if (this.useETag) {
                                method.setHeader("ETag", FilesClient.md5Sum(obj));
                            }
                            entity = new ByteArrayEntity(obj);
                            entity.setContentType(contentType);
                            method.setEntity((HttpEntity)new RequestEntityWrapper((HttpEntity)entity, callback));
                            for (String key : metadata.keySet()) {
                                method.setHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                            }
                            response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                        } else {
                            throw new FilesAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 201) {
                        boolean bl = true;
                        return bl;
                    }
                    if (response.getStatusCode() == 412) {
                        throw new FilesException("Etag missmatch", response.getResponseHeaders(), response.getStatusLine());
                    }
                    if (response.getStatusCode() == 411) {
                        throw new FilesException("Length miss-match", response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected Server Response", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    if (method != null) {
                        method.abort();
                    }
                }
            }
            if (!this.isValidObjectName(objName)) {
                throw new FilesInvalidNameException(objName);
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public String storeStreamedObject(String container, InputStream data, String contentType, String name, Map<String, String> metadata) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            String objName = name;
            if (this.isValidContainerName(container) && this.isValidObjectName(objName)) {
                HttpPut method = new HttpPut(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                method.setHeader("X-Auth-Token", this.authToken);
                InputStreamEntity entity = new InputStreamEntity(data, -1L);
                entity.setChunked(true);
                entity.setContentType(contentType);
                method.setEntity((HttpEntity)entity);
                for (String key : metadata.keySet()) {
                    method.setHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                }
                method.removeHeaders("Content-Length");
                try {
                    FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    if (response.getStatusCode() == 201) {
                        String string = response.getResponseHeader("ETag").getValue();
                        return string;
                    }
                    logger.error((Object)response.getStatusLine());
                    throw new FilesException("Unexpected result", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    method.abort();
                }
            }
            if (!this.isValidObjectName(objName)) {
                throw new FilesInvalidNameException(objName);
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    public String storeObjectAs(String container, String name, HttpEntity entity, Map<String, String> metadata, String md5sum) throws IOException, HttpException, FilesException {
        if (this.isLoggedin()) {
            String objName = name;
            if (this.isValidContainerName(container) && this.isValidObjectName(objName)) {
                HttpPut method = new HttpPut(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                method.setHeader("X-Auth-Token", this.authToken);
                method.setEntity(entity);
                if (this.useETag && md5sum != null) {
                    method.setHeader("ETag", md5sum);
                }
                method.setHeader(entity.getContentType());
                for (String key : metadata.keySet()) {
                    method.setHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                }
                try {
                    FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    if (response.getStatusCode() == 401) {
                        method.abort();
                        this.login();
                        method = new HttpPut(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                        method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                        method.setHeader("X-Auth-Token", this.authToken);
                        method.setEntity(entity);
                        method.setHeader(entity.getContentType());
                        for (String key : metadata.keySet()) {
                            method.setHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                        }
                        response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    }
                    if (response.getStatusCode() == 201) {
                        String string = response.getResponseHeader("ETag").getValue();
                        return string;
                    }
                    logger.debug((Object)response.getStatusLine());
                    throw new FilesException("Unexpected result", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    method.abort();
                }
            }
            if (!this.isValidObjectName(objName)) {
                throw new FilesInvalidNameException(objName);
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(String container, String objName) throws IOException, FilesNotFoundException, HttpException, FilesException {
        block10: {
            if (this.isLoggedin()) {
                if (this.isValidContainerName(container) && this.isValidObjectName(objName)) {
                    HttpDelete method = null;
                    try {
                        method = new HttpDelete(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                        method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                        method.setHeader("X-Auth-Token", this.authToken);
                        FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                        if (response.getStatusCode() == 401) {
                            method.abort();
                            this.login();
                            method = new HttpDelete(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                            method.setHeader("X-Auth-Token", this.authToken);
                            response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                        }
                        if (response.getStatusCode() == 204) {
                            logger.debug((Object)("Object Deleted : " + objName));
                            break block10;
                        }
                        if (response.getStatusCode() == 404) {
                            throw new FilesNotFoundException("Object was not found " + objName, response.getResponseHeaders(), response.getStatusLine());
                        }
                        throw new FilesException("Unexpected status from server", response.getResponseHeaders(), response.getStatusLine());
                    }
                    finally {
                        if (method != null) {
                            method.abort();
                        }
                    }
                }
                if (!this.isValidObjectName(objName)) {
                    throw new FilesInvalidNameException(objName);
                }
                throw new FilesInvalidNameException(container);
            }
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
    }

    public FilesObjectMetaData getObjectMetaData(String container, String objName) throws IOException, FilesNotFoundException, HttpException, FilesAuthorizationException, FilesInvalidNameException {
        if (this.isLoggedin()) {
            if (this.isValidContainerName(container) && this.isValidObjectName(objName)) {
                HttpHead method = new HttpHead(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                try {
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    if (response.getStatusCode() == 401) {
                        method.abort();
                        this.login();
                        method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                        method.setHeader("X-Auth-Token", this.authToken);
                        response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                    }
                    if (response.getStatusCode() == 204 || response.getStatusCode() == 200) {
                        logger.debug((Object)("Object metadata retreived  : " + objName));
                        String mimeType = response.getContentType();
                        String lastModified = response.getLastModified();
                        String eTag = response.getETag();
                        String contentLength = response.getContentLength();
                        FilesObjectMetaData metaData = new FilesObjectMetaData(mimeType, contentLength, eTag, lastModified);
                        Header[] headers = response.getResponseHeaders();
                        HashMap<String, String> headerMap = new HashMap<String, String>();
                        for (Header h : headers) {
                            if (!h.getName().startsWith("X-Object-Meta-")) continue;
                            headerMap.put(h.getName().substring("X-Object-Meta-".length()), FilesClient.unencodeURI(h.getValue()));
                        }
                        if (headerMap.size() > 0) {
                            metaData.setMetaData(headerMap);
                        }
                        FilesObjectMetaData filesObjectMetaData = metaData;
                        return filesObjectMetaData;
                    }
                    if (response.getStatusCode() == 404) {
                        throw new FilesNotFoundException("Container: " + container + " did not have object " + objName, response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new FilesException("Unexpected Return Code from Server", response.getResponseHeaders(), response.getStatusLine());
                }
                finally {
                    method.abort();
                }
            }
            if (!this.isValidObjectName(objName)) {
                throw new FilesInvalidNameException(objName);
            }
            throw new FilesInvalidNameException(container);
        }
        throw new FilesAuthorizationException("You must be logged in", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObject(String container, String objName) throws IOException, HttpException, FilesAuthorizationException, FilesInvalidNameException, FilesNotFoundException {
        block9: {
            if (this.isLoggedin()) {
                if (this.isValidContainerName(container) && this.isValidObjectName(objName)) {
                    HttpGet method = new HttpGet(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    try {
                        FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
                        if (response.getStatusCode() == 200) {
                            logger.debug((Object)("Object data retreived  : " + objName));
                            byte[] byArray = response.getResponseBody();
                            return byArray;
                        }
                        if (response.getStatusCode() == 404) {
                            throw new FilesNotFoundException("Container: " + container + " did not have object " + objName, response.getResponseHeaders(), response.getStatusLine());
                        }
                        break block9;
                    }
                    finally {
                        method.abort();
                    }
                }
                if (!this.isValidObjectName(objName)) {
                    throw new FilesInvalidNameException(objName);
                }
                throw new FilesInvalidNameException(container);
            }
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream getObjectAsStream(String container, String objName) throws IOException, HttpException, FilesAuthorizationException, FilesInvalidNameException, FilesNotFoundException {
        if (!this.isLoggedin()) throw new FilesAuthorizationException("You must be logged in", null, null);
        if (this.isValidContainerName(container) && this.isValidObjectName(objName)) {
            if (objName.length() > 1024) {
                logger.warn((Object)"Object Name supplied was truncated to Max allowed of 1024 characters !");
                objName = objName.substring(0, 1024);
                logger.warn((Object)("Truncated Object Name is: " + objName));
            }
            HttpGet method = new HttpGet(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
            method.setHeader("X-Auth-Token", this.authToken);
            FilesResponse response = new FilesResponse(this.client.execute((HttpUriRequest)method));
            if (response.getStatusCode() == 401) {
                method.abort();
                this.login();
                method = new HttpGet(this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(objName));
                method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                method.setHeader("X-Auth-Token", this.authToken);
                response = new FilesResponse(this.client.execute((HttpUriRequest)method));
            }
            if (response.getStatusCode() == 200) {
                logger.info((Object)("Object data retreived  : " + objName));
                return response.getResponseBodyAsStream();
            }
            if (response.getStatusCode() != 404) return null;
            method.abort();
            throw new FilesNotFoundException("Container: " + container + " did not have object " + objName, response.getResponseHeaders(), response.getStatusLine());
        }
        if (this.isValidObjectName(objName)) throw new FilesInvalidNameException(container);
        throw new FilesInvalidNameException(objName);
    }

    static void writeInputStreamToFile(InputStream is, File f) throws IOException {
        BufferedOutputStream bf = new BufferedOutputStream(new FileOutputStream(f));
        byte[] buffer = new byte[1024];
        int read = 0;
        while ((read = is.read(buffer)) > 0) {
            bf.write(buffer, 0, read);
        }
        is.close();
        bf.flush();
        bf.close();
    }

    static String inputStreamToString(InputStream stream, String encoding) throws IOException {
        char[] buffer = new char[4096];
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(stream, "utf-8");
        int nRead = 0;
        while ((nRead = isr.read(buffer)) >= 0) {
            sb.append(buffer, 0, nRead);
        }
        isr.close();
        return sb.toString();
    }

    public static String md5Sum(File f) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            FileInputStream is = new FileInputStream(f);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            ((InputStream)is).close();
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String md5 = bigInt.toString(16);
            while (md5.length() != 32) {
                md5 = "0" + md5;
            }
            return md5;
        }
        catch (NoSuchAlgorithmException e) {
            logger.fatal((Object)"The JRE is misconfigured on this computer", (Throwable)e);
            return null;
        }
    }

    public static String md5Sum(byte[] data) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] md5sum = digest.digest(data);
            BigInteger bigInt = new BigInteger(1, md5sum);
            String md5 = bigInt.toString(16);
            while (md5.length() != 32) {
                md5 = "0" + md5;
            }
            return md5;
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.fatal((Object)"Major problems with your Java configuration", (Throwable)nsae);
            return null;
        }
    }

    public static String sanitizeForURI(String str) {
        URLCodec codec = new URLCodec();
        try {
            return codec.encode(str).replaceAll("\\+", "%20");
        }
        catch (EncoderException ee) {
            logger.warn((Object)"Error trying to encode string for URI", (Throwable)ee);
            return str;
        }
    }

    public static String unencodeURI(String str) {
        URLCodec codec = new URLCodec();
        try {
            return codec.decode(str);
        }
        catch (DecoderException ee) {
            logger.warn((Object)"Error trying to encode string for URI", (Throwable)ee);
            return str;
        }
    }

    public int getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    public void setConnectionTimeOut(int connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public String getStorageURL() {
        return this.storageURL;
    }

    public String getStorageToken() {
        return this.authToken;
    }

    public boolean isLoggedin() {
        return this.isLoggedin;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String userName) {
        this.username = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAuthenticationURL() {
        return this.authenticationURL;
    }

    public void setAuthenticationURL(String authenticationURL) {
        this.authenticationURL = authenticationURL;
    }

    public boolean getUseETag() {
        return this.useETag;
    }

    public void setUseETag(boolean useETag) {
        this.useETag = useETag;
    }

    public void setUserAgent(String userAgent) {
        this.client.getParams().setParameter("User-Agent", (Object)userAgent);
    }

    public String getUserAgent() {
        return this.client.getParams().getParameter("User-Agent").toString();
    }

    private boolean isValidContainerName(String name) {
        if (name == null) {
            return false;
        }
        int length = name.length();
        if (length == 0 || length > 256) {
            return false;
        }
        return name.indexOf(47) == -1;
    }

    private boolean isValidObjectName(String name) {
        if (name == null) {
            return false;
        }
        int length = name.length();
        return length != 0 && length <= 1024;
    }

    public String getCdnManagementURL() {
        return this.cdnManagementURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateObjectMetadata(String container, String object, Map<String, String> metadata) throws FilesAuthorizationException, HttpException, IOException, FilesInvalidNameException {
        if (!this.isLoggedin) {
            throw new FilesAuthorizationException("You must be logged in", null, null);
        }
        if (!this.isValidContainerName(container)) {
            throw new FilesInvalidNameException(container);
        }
        if (!this.isValidObjectName(object)) {
            throw new FilesInvalidNameException(object);
        }
        String postUrl = this.storageURL + "/" + FilesClient.sanitizeForURI(container) + "/" + FilesClient.sanitizeForURI(object);
        HttpPost method = null;
        try {
            HttpResponse resp;
            FilesResponse response;
            method = new HttpPost(postUrl);
            method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
            method.setHeader("X-Auth-Token", this.authToken);
            if (metadata != null && !metadata.isEmpty()) {
                for (String key : metadata.keySet()) {
                    method.setHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                }
            }
            if ((response = new FilesResponse(resp = this.client.execute((HttpUriRequest)method))).getStatusCode() == 401) {
                method.abort();
                if (this.login()) {
                    method = new HttpPost(postUrl);
                    method.getParams().setIntParameter("http.socket.timeout", this.connectionTimeOut);
                    method.setHeader("X-Auth-Token", this.authToken);
                    if (metadata != null && !metadata.isEmpty()) {
                        for (String key : metadata.keySet()) {
                            method.setHeader("X-Object-Meta-" + key, FilesClient.sanitizeForURI(metadata.get(key)));
                        }
                    }
                    this.client.execute((HttpUriRequest)method);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (method != null) {
                method.abort();
            }
        }
    }

    private String makeURI(String base, List<NameValuePair> parameters) {
        return base + "?" + URLEncodedUtils.format(parameters, (String)"UTF-8");
    }

    public void useSnet() {
        if (!this.snet) {
            this.snet = true;
            if (this.storageURL != null) {
                this.storageURL = this.snetAddr + this.storageURL.substring(8);
            }
        }
    }

    public void usePublic() {
        if (this.snet) {
            this.snet = false;
            if (this.storageURL != null) {
                this.storageURL = "https://" + this.storageURL.substring(this.snetAddr.length());
            }
        }
    }

    public boolean usingSnet() {
        return this.snet;
    }

    private boolean envSnet() {
        if (System.getenv("RACKSPACE_SERVICENET") == null) {
            return false;
        }
        this.snet = true;
        return true;
    }
}

