/*
 * Decompiled with CFR 0.152.
 */
package com.rackspacecloud.client.cloudfiles;

import com.rackspacecloud.client.cloudfiles.FilesUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class FilesResponse {
    private HttpResponse response = null;
    private HttpEntity entity = null;
    private static Logger logger = Logger.getLogger(FilesResponse.class);

    public FilesResponse(HttpResponse response) {
        this.response = response;
        this.entity = response.getEntity();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Status Line: " + this.getStatusLine()));
            Header[] responseHeaders = this.getResponseHeaders();
            for (int i = 0; i < responseHeaders.length; ++i) {
                logger.debug((Object)responseHeaders[i]);
            }
        }
    }

    public boolean loginSuccess() {
        int statusCode = this.getStatusCode();
        return statusCode >= 200 && statusCode < 300;
    }

    public String getAuthToken() {
        return this.getResponseHeader(FilesUtil.getProperty("auth_token_name", "X-Auth-Token")).getValue();
    }

    public String getStorageURL() {
        return this.getResponseHeader("X-Storage-Url").getValue();
    }

    public String getCDNManagementURL() {
        Header header = this.getResponseHeader("X-CDN-Management-URL");
        return header == null ? null : header.getValue();
    }

    public String getContentType() {
        return this.getResponseHeader("Content-Type").getValue();
    }

    public String getContentLength() {
        Header hdr = this.getResponseHeader("Content-Length");
        if (hdr == null) {
            return "0";
        }
        return hdr.getValue();
    }

    public String getETag() {
        Header hdr = this.getResponseHeader("ETag");
        if (hdr == null) {
            return null;
        }
        return hdr.getValue();
    }

    public String getLastModified() {
        return this.getResponseHeader("Last-Modified").getValue();
    }

    public Header[] getResponseHeaders() {
        return this.response.getAllHeaders();
    }

    public StatusLine getStatusLine() {
        return this.response.getStatusLine();
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getStatusMessage() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public String getResponseBodyAsString() throws IOException {
        return EntityUtils.toString((HttpEntity)this.entity);
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        return this.entity.getContent();
    }

    public byte[] getResponseBody() throws IOException {
        return EntityUtils.toByteArray((HttpEntity)this.entity);
    }

    public Header getResponseHeader(String headerName) {
        return this.response.getFirstHeader(headerName);
    }

    public int getContainerObjectCount() {
        Header contCountHeader = this.getResponseHeader("X-Container-Object-Count");
        if (contCountHeader != null) {
            return Integer.parseInt(contCountHeader.getValue());
        }
        return -1;
    }

    public long getContainerBytesUsed() {
        Header contBytesUsedHeader = this.getResponseHeader("X-Container-Bytes-Used");
        if (contBytesUsedHeader != null) {
            return Long.parseLong(contBytesUsedHeader.getValue());
        }
        return -1L;
    }

    public int getAccountContainerCount() {
        Header contCountHeader = this.getResponseHeader("X-Account-Container-Count");
        if (contCountHeader != null) {
            return Integer.parseInt(contCountHeader.getValue());
        }
        return -1;
    }

    public long getAccountBytesUsed() {
        Header accountBytesUsedHeader = this.getResponseHeader("X-Account-Bytes-Used");
        if (accountBytesUsedHeader != null) {
            return Long.parseLong(accountBytesUsedHeader.getValue());
        }
        return -1L;
    }

    public String getCdnUrl() {
        Header cdnHeader = this.getResponseHeader("X-CDN-URI");
        if (cdnHeader != null) {
            return cdnHeader.getValue();
        }
        return null;
    }

    public Header[] getResponseHeaders(String headerName) {
        return this.response.getHeaders(headerName);
    }

    public String getContentEncoding() {
        return this.entity.getContentEncoding().getValue();
    }
}

