/*
 * Decompiled with CFR 0.152.
 */
package com.rackspacecloud.client.cloudfiles.sample;

import com.rackspacecloud.client.cloudfiles.FilesClient;
import com.rackspacecloud.client.cloudfiles.FilesException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;

public class FilesMakeContainer {
    public static void main(String[] args) throws NoSuchAlgorithmException, FilesException {
        Options options = FilesMakeContainer.addCommandLineOptions();
        if (args.length <= 0) {
            FilesMakeContainer.printHelp(options);
        }
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help")) {
                FilesMakeContainer.printHelp(options);
            }
            String containerName = null;
            if (line.hasOption("container")) {
                containerName = line.getOptionValue("container");
                FilesMakeContainer.createContaier(containerName);
            } else if (args.length > 0) {
                containerName = args[0];
                FilesMakeContainer.createContaier(containerName);
            } else {
                System.err.println("You must provide the -container with a valid value for this to work !");
                System.exit(-1);
            }
        }
        catch (ParseException err) {
            System.err.println("Please see the logs for more details. Error Message: " + err.getMessage());
            err.printStackTrace(System.err);
        }
        catch (Exception err) {
            System.err.println("Please see the logs for more details. Error Message: " + err.getMessage());
        }
    }

    private static void createContaier(String containerName) throws HttpException, IOException, FilesException {
        FilesClient client;
        if (!StringUtils.isNotBlank((String)containerName) || containerName.indexOf(47) != -1) {
            System.err.println("You must provide a valid value for the  Container name !");
            System.exit(-1);
        }
        if ((client = new FilesClient()).login()) {
            client.createContainer(containerName);
        } else {
            System.out.println("Failed to login to Cloud Files!");
        }
        System.exit(0);
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("MkDir [-container] ContainerName", options);
    }

    private static Options addCommandLineOptions() {
        Option help = new Option("help", "print this message");
        OptionBuilder.withArgName((String)"container");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"Name of container to create.");
        Option container = OptionBuilder.create((String)"container");
        Options options = new Options();
        options.addOption(help);
        options.addOption(container);
        return options;
    }
}

