/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.EditableCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.i18n.Locale;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHostCollection
extends Collection<Host>
implements EditableCollection {
    private static Logger log = Logger.getLogger(AbstractHostCollection.class);
    private static final AbstractHostCollection EMPTY = new AbstractHostCollection(){

        public void load() {
        }

        public String getName() {
            return Locale.localizedString("None");
        }
    };

    public static AbstractHostCollection empty() {
        return EMPTY;
    }

    public AbstractHostCollection() {
    }

    public AbstractHostCollection(java.util.Collection<Host> c) {
        super(c);
    }

    public abstract String getName();

    public String getComment(Host h) {
        if (StringUtils.isNotBlank((String)h.getComment())) {
            return StringUtils.remove((String)StringUtils.remove((String)h.getComment(), (char)'\n'), (char)'\r');
        }
        return null;
    }

    @Override
    public boolean addAll(java.util.Collection<? extends Host> c) {
        ArrayList<Host> temporary = new ArrayList<Host>();
        for (Host host : c) {
            if (temporary.contains(host)) {
                log.warn((Object)("Reset UUID of duplicate in collection:" + host));
                host.setUuid(null);
            }
            temporary.add(host);
        }
        return super.addAll(temporary);
    }

    @Override
    public boolean add(Host host) {
        if (this.contains(host)) {
            log.warn((Object)("Reset UUID of duplicate in collection:" + host));
            host.setUuid(null);
        }
        return super.add(host);
    }

    @Override
    public void add(int row, Host host) {
        if (this.contains(host)) {
            log.warn((Object)("Reset UUID of duplicate in collection:" + host));
            host.setUuid(null);
        }
        super.add(row, host);
    }

    @Override
    public void collectionItemAdded(Host item) {
        this.sort();
        super.collectionItemAdded(item);
    }

    @Override
    public void collectionItemRemoved(Host item) {
        this.sort();
        super.collectionItemRemoved(item);
    }

    protected void sort() {
    }

    public Host lookup(String uuid) {
        for (Host bookmark : this) {
            if (!bookmark.getUuid().equals(uuid)) continue;
            return bookmark;
        }
        return null;
    }

    @Override
    public boolean allowsAdd() {
        return true;
    }

    @Override
    public boolean allowsDelete() {
        return true;
    }

    @Override
    public boolean allowsEdit() {
        return true;
    }

    public void save() {
    }

    public void load(Collection<Host> c) {
        this.addAll((java.util.Collection<? extends Host>)c);
        this.collectionLoaded();
    }

    public boolean isLocked() {
        return false;
    }
}

