/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import java.security.cert.X509Certificate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractKeychain {
    private static Logger log = Logger.getLogger(AbstractKeychain.class);

    public String find(Host host) {
        String p;
        if (log.isInfoEnabled()) {
            log.info((Object)("Fetching password from Keychain:" + host));
        }
        if (StringUtils.isEmpty((String)host.getHostname())) {
            log.warn((Object)"No hostname given");
            return null;
        }
        Credentials credentials = host.getCredentials();
        if (StringUtils.isEmpty((String)credentials.getUsername())) {
            log.warn((Object)"No username given");
            return null;
        }
        if (credentials.isPublicKeyAuthentication()) {
            p = this.getPassword(host.getHostname(), credentials.getIdentity().getAbbreviatedPath());
            if (null == p) {
                p = this.getPassword("SSHKeychain", credentials.getIdentity().getAbbreviatedPath());
            }
        } else {
            p = this.getPassword(host.getProtocol().getScheme(), host.getPort(), host.getHostname(), credentials.getUsername());
        }
        if (null == p && log.isInfoEnabled()) {
            log.info((Object)("Password not found in Keychain:" + host));
        }
        return p;
    }

    public void save(Host host) {
        if (StringUtils.isEmpty((String)host.getHostname())) {
            log.warn((Object)"No hostname given");
            return;
        }
        Credentials credentials = host.getCredentials();
        if (StringUtils.isEmpty((String)credentials.getUsername())) {
            log.warn((Object)"No username given");
            return;
        }
        if (StringUtils.isEmpty((String)credentials.getPassword())) {
            log.warn((Object)"No password given");
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Add Password to Keychain:" + host));
        }
        if (credentials.isPublicKeyAuthentication()) {
            this.addPassword(host.getHostname(), credentials.getIdentity().getAbbreviatedPath(), credentials.getPassword());
        } else {
            this.addPassword(host.getProtocol().getScheme(), host.getPort(), host.getHostname(), credentials.getUsername(), credentials.getPassword());
        }
    }

    public abstract String getPassword(String var1, int var2, String var3, String var4);

    public abstract String getPassword(String var1, String var2);

    public abstract void addPassword(String var1, String var2, String var3);

    public abstract void addPassword(String var1, int var2, String var3, String var4, String var5);

    public abstract boolean isTrusted(String var1, X509Certificate[] var2);

    public abstract boolean displayCertificates(X509Certificate[] var1);

    public X509Certificate chooseCertificate(String[] issuers, String prompt) {
        return null;
    }
}

