/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.KeychainFactory;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.i18n.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractLoginController
implements LoginController {
    private static Logger log = Logger.getLogger(AbstractLoginController.class);

    public void warn(String title, String message, String preference) throws LoginCanceledException {
        this.warn(title, message, Locale.localizedString("Continue", "Credentials"), Locale.localizedString("Disconnect", "Credentials"), preference);
    }

    public abstract void warn(String var1, String var2, String var3, String var4, String var5) throws LoginCanceledException;

    public void check(Host host, String title, String message) throws LoginCanceledException {
        this.check(host, title, message, Preferences.instance().getBoolean("connection.login.useKeychain"), host.getProtocol().equals(Protocol.SFTP), host.getProtocol().isAnonymousConfigurable());
    }

    public void check(Host host, String title, String message, boolean enableKeychain, boolean enablePublicKey, boolean enableAnonymous) throws LoginCanceledException {
        Credentials credentials = host.getCredentials();
        StringBuilder reason = new StringBuilder();
        if (StringUtils.isNotBlank((String)message)) {
            reason.append(message).append(". ");
        }
        if (!credentials.validate(host.getProtocol())) {
            if (StringUtils.isNotBlank((String)credentials.getUsername())) {
                if (Preferences.instance().getBoolean("connection.login.useKeychain")) {
                    String saved = KeychainFactory.instance().find(host);
                    if (StringUtils.isBlank((String)saved)) {
                        if (!credentials.isPublicKeyAuthentication()) {
                            reason.append(Locale.localizedString("No login credentials could be found in the Keychain", "Credentials")).append(".");
                            this.prompt(host.getProtocol(), credentials, title, reason.toString(), enableKeychain, enablePublicKey, enableAnonymous);
                        }
                    } else {
                        credentials.setPassword(saved);
                        credentials.setUseKeychain(false);
                    }
                } else {
                    reason.append(Locale.localizedString("The use of the Keychain is disabled in the Preferences", "Credentials")).append(".");
                    this.prompt(host.getProtocol(), credentials, title, reason.toString(), enableKeychain, enablePublicKey, enableAnonymous);
                }
            } else {
                reason.append(Locale.localizedString("No login credentials could be found in the Keychain", "Credentials")).append(".");
                this.prompt(host.getProtocol(), credentials, title, reason.toString(), enableKeychain, enablePublicKey, enableAnonymous);
            }
        }
    }

    public void fail(Protocol protocol, Credentials credentials, String reason) throws LoginCanceledException {
        this.prompt(protocol, credentials, Locale.localizedString("Login failed", "Credentials"), reason);
    }

    public void success(Host host) {
        Credentials credentials = host.getCredentials();
        if (credentials.isAnonymousLogin()) {
            log.info((Object)"Do not write anonymous credentials to Keychain");
            return;
        }
        if (!credentials.isUseKeychain()) {
            log.info((Object)"Do not write credentials to Keychain");
            return;
        }
        KeychainFactory.instance().save(host);
    }

    public void fail(Protocol protocol, Credentials credentials) throws LoginCanceledException {
        this.prompt(protocol, credentials, Locale.localizedString("Login failed", "Credentials"), Locale.localizedString("Login with username and password", "Credentials"));
    }

    public void prompt(Protocol protocol, Credentials credentials, String title, String reason) throws LoginCanceledException {
        this.prompt(protocol, credentials, title, reason, Preferences.instance().getBoolean("connection.login.useKeychain"), protocol.equals(Protocol.SFTP), protocol.isAnonymousConfigurable());
    }

    public abstract void prompt(Protocol var1, Credentials var2, String var3, String var4, boolean var5, boolean var6, boolean var7) throws LoginCanceledException;
}

