/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Proxy;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

public abstract class AbstractProxy
implements Proxy {
    private static Logger log = Logger.getLogger(AbstractProxy.class);
    private static final String SOCKS_PORT = "socksProxyPort";
    private static final String SOCKS_HOST = "socksProxyHost";

    public void configure(Host host) {
        Properties properties = System.getProperties();
        if (Preferences.instance().getBoolean("connection.proxy.enable") && this.isSOCKSProxyEnabled(host)) {
            int port = this.getSOCKSProxyPort(host);
            properties.put(SOCKS_PORT, Integer.toString(port));
            String proxy = this.getSOCKSProxyHost(host);
            properties.put(SOCKS_HOST, proxy);
            if (log.isInfoEnabled()) {
                log.info((Object)("Using SOCKS Proxy " + proxy + ":" + port));
            }
        } else {
            properties.remove(SOCKS_HOST);
            properties.remove(SOCKS_PORT);
        }
        System.setProperties(properties);
    }

    protected boolean matches(String wildcard, String hostname) {
        String host = wildcard.replace("*", ".*").replace("?", ".");
        String regex = new StringBuffer("^").append(host).append("$").toString();
        try {
            return hostname.matches(regex);
        }
        catch (PatternSyntaxException e) {
            log.warn((Object)("Failed converting wildcard to regular expression:" + e.getMessage()));
            return false;
        }
    }
}

