/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Rendezvous;
import ch.cyberduck.core.RendezvousListener;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.DateFormatterFactory;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRendezvous
implements Rendezvous {
    private static Logger log = Logger.getLogger(AbstractRendezvous.class);
    protected static final String SERVICE_TYPE_SFTP = "_sftp-ssh._tcp.";
    protected static final String SERVICE_TYPE_FTP = "_ftp._tcp.";
    protected static final String SERVICE_TYPE_WEBDAV = "_webdav._tcp";
    protected static final String SERVICE_TYPE_WEBDAV_TLS = "_webdavs._tcp";
    private final String[] serviceTypes = new String[]{"_sftp-ssh._tcp.", "_ftp._tcp.", "_webdav._tcp", "_webdavs._tcp"};
    private Map<String, Host> services = new ConcurrentHashMap<String, Host>();
    private Set<RendezvousListener> listeners = Collections.synchronizedSet(new HashSet());
    private RendezvousListener notifier = new RendezvousListener(){

        public void serviceResolved(String identifier, Host host) {
            RendezvousListener[] l;
            log.info((Object)("Service resolved:" + host));
            for (RendezvousListener listener : l = AbstractRendezvous.this.listeners.toArray(new RendezvousListener[AbstractRendezvous.this.listeners.size()])) {
                listener.serviceResolved(identifier, host);
            }
        }

        public void serviceLost(String servicename) {
            RendezvousListener[] l;
            log.info((Object)("Service lost:" + servicename));
            for (RendezvousListener listener : l = AbstractRendezvous.this.listeners.toArray(new RendezvousListener[AbstractRendezvous.this.listeners.size()])) {
                listener.serviceLost(servicename);
            }
        }
    };

    public String[] getServiceTypes() {
        return this.serviceTypes;
    }

    @Override
    public void addListener(RendezvousListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RendezvousListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int numberOfServices() {
        return this.services.size();
    }

    @Override
    public Host getService(int index) {
        return this.services.values().toArray(new Host[this.services.size()])[index];
    }

    @Override
    public Iterator<Host> iterator() {
        return this.services.values().iterator();
    }

    @Override
    public String getDisplayedName(int index) {
        if (index < this.numberOfServices()) {
            Host host = this.services.values().toArray(new Host[this.services.size()])[index];
            return host.getNickname();
        }
        return Locale.localizedString("Unknown");
    }

    @Override
    public String getDisplayedName(String identifier) {
        Host host = this.services.get(identifier);
        if (null == host) {
            return Locale.localizedString("Unknown");
        }
        return host.getNickname();
    }

    protected void add(String fullname, String hostname, int port, String user, String password, String path) {
        Protocol protocol = this.getProtocol(fullname, port);
        if (null == protocol) {
            log.warn((Object)("Unknown service type:" + fullname));
            return;
        }
        Host host = new Host(protocol, hostname, port);
        host.getCredentials().setUsername(user);
        host.getCredentials().setPassword(password);
        if (StringUtils.isNotBlank((String)path)) {
            host.setDefaultPath(Path.normalize(path));
        }
        host.setComment(DateFormatterFactory.instance().getLongFormat(new Date().getTime()));
        this.add(fullname, host);
    }

    public Protocol getProtocol(String fullname, int port) {
        if (fullname.contains(SERVICE_TYPE_SFTP)) {
            return Protocol.SFTP;
        }
        if (fullname.contains(SERVICE_TYPE_FTP)) {
            return Protocol.FTP;
        }
        if (fullname.contains(SERVICE_TYPE_WEBDAV)) {
            return Protocol.WEBDAV;
        }
        if (fullname.contains(SERVICE_TYPE_WEBDAV_TLS)) {
            return Protocol.WEBDAV_SSL;
        }
        log.warn((Object)("Cannot find service type in:" + fullname));
        return null;
    }

    protected void add(String fullname, Host host) {
        log.debug((Object)("add:" + fullname));
        if (null == this.services.put(fullname, host)) {
            this.notifier.serviceResolved(fullname, host);
        }
    }

    protected void remove(String identifier) {
        log.debug((Object)("remove:" + identifier));
        if (null == this.services.remove(identifier)) {
            return;
        }
        this.notifier.serviceLost(identifier);
    }
}

