/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.FolderBookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.serializer.HostReaderFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkCollection
extends AbstractHostCollection {
    private static Logger log = Logger.getLogger(BookmarkCollection.class);
    private static BookmarkCollection DEFAULT_COLLECTION = new BookmarkCollection(LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path"), "Favorites.plist"));
    protected Local file;
    private boolean locked = true;

    public static BookmarkCollection defaultCollection() {
        return DEFAULT_COLLECTION;
    }

    @Override
    public String getName() {
        return Locale.localizedString("Favorites");
    }

    public BookmarkCollection(Local file) {
        this.setFile(file);
    }

    protected void setFile(Local file) {
        this.file = file;
        this.file.getParent().mkdir(true);
    }

    public Local getFile() {
        return this.file;
    }

    @Override
    public boolean allowsAdd() {
        return FolderBookmarkCollection.favoritesCollection().allowsAdd();
    }

    @Override
    public boolean allowsDelete() {
        return FolderBookmarkCollection.favoritesCollection().allowsDelete();
    }

    @Override
    public boolean allowsEdit() {
        return FolderBookmarkCollection.favoritesCollection().allowsEdit();
    }

    @Override
    public Host lookup(String uuid) {
        return FolderBookmarkCollection.favoritesCollection().lookup(uuid);
    }

    @Override
    public int size() {
        return FolderBookmarkCollection.favoritesCollection().size();
    }

    @Override
    public boolean isEmpty() {
        return FolderBookmarkCollection.favoritesCollection().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return FolderBookmarkCollection.favoritesCollection().contains(o);
    }

    @Override
    public Host get(int row) {
        return (Host)FolderBookmarkCollection.favoritesCollection().get(row);
    }

    @Override
    public boolean addAll(Collection<? extends Host> hosts) {
        return FolderBookmarkCollection.favoritesCollection().addAll(hosts);
    }

    @Override
    public boolean add(Host host) {
        return FolderBookmarkCollection.favoritesCollection().add(host);
    }

    @Override
    public void add(int row, Host host) {
        FolderBookmarkCollection.favoritesCollection().add(row, host);
    }

    @Override
    public Host remove(int row) {
        return (Host)FolderBookmarkCollection.favoritesCollection().remove(row);
    }

    @Override
    public boolean remove(Object host) {
        return FolderBookmarkCollection.favoritesCollection().remove(host);
    }

    @Override
    protected void sort() {
        FolderBookmarkCollection.favoritesCollection().sort();
    }

    @Override
    public int indexOf(Object elem) {
        return FolderBookmarkCollection.favoritesCollection().indexOf(elem);
    }

    @Override
    public int lastIndexOf(Object elem) {
        return FolderBookmarkCollection.favoritesCollection().lastIndexOf(elem);
    }

    @Override
    public void addListener(CollectionListener<Host> l) {
        FolderBookmarkCollection.favoritesCollection().addListener(l);
    }

    @Override
    public void removeListener(CollectionListener<Host> l) {
        FolderBookmarkCollection.favoritesCollection().removeListener(l);
    }

    @Override
    public void clear() {
        FolderBookmarkCollection.favoritesCollection().clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return FolderBookmarkCollection.favoritesCollection().removeAll(c);
    }

    @Override
    public void collectionItemChanged(Host item) {
        FolderBookmarkCollection.favoritesCollection().collectionItemChanged(item);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Host> c) {
        return FolderBookmarkCollection.favoritesCollection().addAll(index, c);
    }

    @Override
    public Iterator<Host> iterator() {
        return FolderBookmarkCollection.favoritesCollection().iterator();
    }

    @Override
    public ListIterator<Host> listIterator() {
        return FolderBookmarkCollection.favoritesCollection().listIterator();
    }

    @Override
    public ListIterator<Host> listIterator(int index) {
        return FolderBookmarkCollection.favoritesCollection().listIterator(index);
    }

    @Override
    public List<Host> subList(int fromIndex, int toIndex) {
        return FolderBookmarkCollection.favoritesCollection().subList(fromIndex, toIndex);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return FolderBookmarkCollection.favoritesCollection().containsAll(c);
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void save() {
        if (this.locked) {
            log.debug((Object)"Do not write locked collection");
            return;
        }
        FolderBookmarkCollection.favoritesCollection().save();
    }

    @Override
    public void load() {
        FolderBookmarkCollection favorites = FolderBookmarkCollection.favoritesCollection();
        if (this.file.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Found Bookmarks file: " + this.file.getAbsolute()));
            }
            favorites.load(HostReaderFactory.instance().readCollection(this.file));
            log.info((Object)"Moving deprecated bookmarks file to Trash");
            this.file.delete(true);
        } else {
            favorites.load();
        }
        this.locked = false;
    }
}

