/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Preferences;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache<E extends AbstractPath> {
    protected static Logger log = Logger.getLogger(Cache.class);
    private final Map<PathReference, AttributedList<E>> _impl = Collections.synchronizedMap(new LRUMap(Preferences.instance().getInteger("browser.cache.size")){

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            log.debug((Object)("Removing from cache:" + entry));
            return true;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E lookup(PathReference reference) {
        Map<PathReference, AttributedList<E>> map = this._impl;
        synchronized (map) {
            for (AttributedList<E> list : this._impl.values()) {
                E path = list.get(reference);
                if (null == path) continue;
                return path;
            }
            log.warn((Object)("Lookup failed for " + reference + " in cache"));
            return null;
        }
    }

    public boolean isEmpty() {
        return this._impl.isEmpty();
    }

    public boolean containsKey(PathReference reference) {
        return this._impl.containsKey(reference);
    }

    public AttributedList<E> remove(PathReference reference) {
        return this._impl.remove(reference);
    }

    public AttributedList<E> get(PathReference reference) {
        AttributedList<E> children = this.get(reference, null, null);
        if (null == children) {
            log.warn((Object)("No cache for " + reference));
            return AttributedList.emptyList();
        }
        return children;
    }

    public AttributedList<E> get(PathReference reference, Comparator<E> comparator, PathFilter<E> filter) {
        AttributedList<E> children = this._impl.get(reference);
        if (null == children) {
            log.warn((Object)("No cache for " + reference));
            return AttributedList.emptyList();
        }
        boolean needsSorting = false;
        if (null != comparator) {
            needsSorting = !((Object)children.attributes().getComparator()).equals(comparator);
        }
        boolean needsFiltering = false;
        if (null != filter) {
            boolean bl = needsFiltering = !children.attributes().getFilter().equals(filter);
        }
        if (needsSorting) {
            if (!needsFiltering) {
                children.sort(comparator);
            }
            children.attributes().setComparator(comparator);
        }
        if (needsFiltering) {
            List<E> hidden = children.attributes().getHidden();
            children.addAll(hidden);
            hidden.clear();
            for (AbstractPath child : children) {
                if (filter.accept(child)) continue;
                children.attributes().addHidden(child);
                children.remove(child);
            }
            children.attributes().setFilter(filter);
            children.sort(comparator);
        }
        return children;
    }

    public AttributedList<E> put(PathReference reference, AttributedList<E> children) {
        return this._impl.put(reference, children);
    }

    public void clear() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Clearing cache " + this.toString()));
        }
        this._impl.clear();
    }
}

