/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class Credentials {
    private static Logger log = Logger.getLogger(Credentials.class);
    private String user;
    private transient String password;
    private Local identity;
    private boolean shouldBeAddedToKeychain;

    public Credentials() {
        this(Preferences.instance().getProperty("connection.login.name"), null, Preferences.instance().getBoolean("connection.login.useKeychain"));
    }

    public Credentials(String user, String password) {
        this(user, password, Preferences.instance().getBoolean("connection.login.useKeychain"));
    }

    public Credentials(String user, String password, boolean shouldBeAddedToKeychain) {
        this.setUseKeychain(shouldBeAddedToKeychain);
        this.init(user, password);
    }

    private void init(String username, String password) {
        this.user = username;
        this.password = password;
    }

    public String getUsername() {
        return this.user;
    }

    public void setUsername(String user) {
        this.user = user;
    }

    public String getPassword() {
        if (StringUtils.isEmpty((String)this.password) && this.isAnonymousLogin()) {
            return Preferences.instance().getProperty("connection.login.anon.pass");
        }
        return this.password;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public void setUseKeychain(boolean shouldBeAddedToKeychain) {
        this.shouldBeAddedToKeychain = shouldBeAddedToKeychain;
    }

    public boolean isUseKeychain() {
        return this.shouldBeAddedToKeychain;
    }

    public boolean isAnonymousLogin() {
        String user = this.getUsername();
        if (StringUtils.isEmpty((String)user)) {
            return false;
        }
        return Preferences.instance().getProperty("connection.login.anon.name").equals(user);
    }

    public boolean isPublicKeyAuthentication() {
        if (null == this.getIdentity()) {
            return false;
        }
        return this.getIdentity().exists();
    }

    public void setIdentity(Local file) {
        this.identity = file;
    }

    public Local getIdentity() {
        return this.identity;
    }

    public boolean validate(Protocol protocol) {
        return protocol.validate(this);
    }

    public void clear() {
        this.user = null;
        this.password = null;
    }

    public abstract String getUsernamePlaceholder();

    public abstract String getPasswordPlaceholder();
}

