/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractFolderHostCollection;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.serializer.HostWriterFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderBookmarkCollection
extends AbstractFolderHostCollection {
    private static Logger log = Logger.getLogger(FolderBookmarkCollection.class);
    private static FolderBookmarkCollection FAVORITES_COLLECTION = new FolderBookmarkCollection(LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path"), "Bookmarks"));
    private static final String PREFIX = "bookmark.";

    public static FolderBookmarkCollection favoritesCollection() {
        return FAVORITES_COLLECTION;
    }

    public FolderBookmarkCollection(Local f) {
        super(f);
    }

    @Override
    public void collectionItemAdded(Host bookmark) {
        if (this.isLocked()) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        this.save(bookmark);
        this.index();
        super.collectionItemAdded(bookmark);
    }

    protected void save(Host bookmark) {
        HostWriterFactory.instance().write(bookmark, this.getFile(bookmark));
    }

    @Override
    public boolean addAll(java.util.Collection<? extends Host> c) {
        ArrayList<Host> temporary = new ArrayList<Host>();
        for (Host host : c) {
            if (temporary.contains(host)) {
                log.warn((Object)("Reset UUID of duplicate in collection:" + host));
                host.setUuid(null);
            }
            temporary.add(host);
        }
        return super.addAll((java.util.Collection<? extends Host>)temporary);
    }

    protected void index() {
        for (int i = 0; i < this.size(); ++i) {
            Preferences.instance().setProperty(PREFIX + ((Host)this.get(i)).getUuid(), i);
        }
    }

    @Override
    public void load(Collection<Host> c) {
        super.load(c);
        this.index();
        this.sort();
        for (Host bookmark : this) {
            this.save(bookmark);
        }
        this.collectionLoaded();
    }

    @Override
    protected void sort() {
        Collections.sort(this, new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                return new Integer(Preferences.instance().getInteger(FolderBookmarkCollection.PREFIX + o1.getUuid())).compareTo(Preferences.instance().getInteger(FolderBookmarkCollection.PREFIX + o2.getUuid()));
            }
        });
    }
}

