/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractFolderHostCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.DateFormatterFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.apache.log4j.Logger;

public class HistoryCollection
extends AbstractFolderHostCollection {
    private static Logger log = Logger.getLogger(HistoryCollection.class);
    private static HistoryCollection HISTORY_COLLECTION = new HistoryCollection(LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path"), "History"));

    public HistoryCollection(Local f) {
        super(f);
    }

    public static HistoryCollection defaultCollection() {
        return HISTORY_COLLECTION;
    }

    public Local getFile(Host bookmark) {
        return LocalFactory.createLocal(this.folder, bookmark.getNickname(true) + ".duck");
    }

    public String getComment(Host host) {
        Date timestamp = host.getTimestamp();
        if (null != timestamp) {
            return DateFormatterFactory.instance().getLongFormat(timestamp.getTime());
        }
        return null;
    }

    public void add(int row, Host bookmark) {
        if (this.contains(bookmark)) {
            this.remove(bookmark);
        }
        super.add(row, bookmark);
    }

    public boolean add(Host bookmark) {
        if (this.contains(bookmark)) {
            this.remove(bookmark);
        }
        return super.add(bookmark);
    }

    protected void sort() {
        Collections.sort(this, new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                if (null == o1.getTimestamp()) {
                    return 1;
                }
                if (null == o2.getTimestamp()) {
                    return -1;
                }
                return -o1.getTimestamp().compareTo(o2.getTimestamp());
            }
        });
    }

    public boolean allowsAdd() {
        return false;
    }

    public boolean allowsEdit() {
        return false;
    }
}

