/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.EditableCollection;
import ch.cyberduck.core.FolderBookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Preferences;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleBookmarkCollection
extends Collection<FolderBookmarkCollection>
implements EditableCollection {
    private static Logger log = Logger.getLogger(FolderBookmarkCollection.class);
    private static final MultipleBookmarkCollection EMPTY = new MultipleBookmarkCollection(null){

        public void load() {
        }
    };
    private static MultipleBookmarkCollection DEFAULT_COLLECTION = new MultipleBookmarkCollection(LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path"), "Bookmarks"));
    private Local folder;

    public static MultipleBookmarkCollection empty() {
        return EMPTY;
    }

    public static MultipleBookmarkCollection defaultCollection() {
        return DEFAULT_COLLECTION;
    }

    public MultipleBookmarkCollection(Local f) {
        this.folder = f;
        this.folder.mkdir(true);
        this.load();
    }

    @Override
    public void load() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Reloading:" + this.folder));
        }
        AttributedList<Local> groups = this.folder.children(new PathFilter<Local>(){

            @Override
            public boolean accept(Local file) {
                return file.attributes().isDirectory();
            }
        });
        for (Local group : groups) {
            this.add(new FolderBookmarkCollection(group));
        }
    }

    public boolean contains(Host bookmark) {
        for (FolderBookmarkCollection c : this) {
            if (!c.contains(bookmark)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsAdd() {
        for (FolderBookmarkCollection c : this) {
            if (c.allowsAdd()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean allowsDelete() {
        for (FolderBookmarkCollection c : this) {
            if (c.allowsDelete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean allowsEdit() {
        for (FolderBookmarkCollection c : this) {
            if (c.allowsEdit()) continue;
            return false;
        }
        return true;
    }
}

