/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AbstractStreamListener;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferAdapter;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.IOResumeException;
import ch.cyberduck.core.io.ThrottledInputStream;
import ch.cyberduck.core.io.ThrottledOutputStream;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.DeserializerFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.serializer.SerializerFactory;
import com.ibm.icu.text.Normalizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Path
extends AbstractPath
implements Serializable {
    private static Logger log = Logger.getLogger(Path.class);
    private String path;
    private Local local;
    private Status status;
    private Pattern TEXT_FILETYPE_PATTERN = null;
    private static final int CHUNKSIZE = Preferences.instance().getInteger("connection.chunksize");
    private Pattern BINARY_FILETYPE_PATTERN;
    public static final char DELIMITER = '/';
    private Path parent;
    private PathAttributes attributes;
    private String symlink;

    public Pattern getTextFiletypePattern() {
        String regex = Preferences.instance().getProperty("filetype.text.regex");
        if (null == this.TEXT_FILETYPE_PATTERN || !this.TEXT_FILETYPE_PATTERN.pattern().equals(regex)) {
            try {
                this.TEXT_FILETYPE_PATTERN = Pattern.compile(regex, 2);
            }
            catch (PatternSyntaxException e) {
                log.warn((Object)e.getMessage());
            }
        }
        return this.TEXT_FILETYPE_PATTERN;
    }

    public Pattern getBinaryFiletypePattern() {
        String regex = Preferences.instance().getProperty("filetype.binary.regex");
        if (null == this.BINARY_FILETYPE_PATTERN || !this.BINARY_FILETYPE_PATTERN.pattern().equals(regex)) {
            try {
                this.BINARY_FILETYPE_PATTERN = Pattern.compile(regex, 2);
            }
            catch (PatternSyntaxException e) {
                log.warn((Object)e.getMessage());
            }
        }
        return this.BINARY_FILETYPE_PATTERN;
    }

    protected <T> Path(T dict) {
        this.init(dict);
    }

    @Override
    public <T> void init(T serialized) {
        Deserializer dict = DeserializerFactory.createDeserializer(serialized);
        this.init(dict);
    }

    protected void init(Deserializer dict) {
        Object attributesObj;
        String symlinkObj;
        String localObj;
        String pathObj = dict.stringForKey("Remote");
        if (pathObj != null) {
            this.setPath(pathObj);
        }
        if ((localObj = dict.stringForKey("Local")) != null) {
            this.setLocal(LocalFactory.createLocal(localObj));
        }
        if ((symlinkObj = dict.stringForKey("Symlink")) != null) {
            this.setSymlinkTarget(symlinkObj);
        }
        if ((attributesObj = dict.objectForKey("Attributes")) != null) {
            this.attributes = new PathAttributes(attributesObj);
        }
        if (dict.stringForKey("Complete") != null) {
            this.status().setComplete(true);
        }
    }

    public <S> S getAsDictionary() {
        Serializer dict = SerializerFactory.createSerializer();
        return this.getAsDictionary(dict);
    }

    protected <S> S getAsDictionary(Serializer dict) {
        dict.setStringForKey(this.getAbsolute(), "Remote");
        if (this.local != null) {
            dict.setStringForKey(this.local.toString(), "Local");
        }
        if (StringUtils.isNotBlank((String)this.symlink)) {
            dict.setStringForKey(this.symlink, "Symlink");
        }
        dict.setObjectForKey(this.attributes, "Attributes");
        if (this.status().isComplete()) {
            dict.setStringForKey(String.valueOf(true), "Complete");
        }
        return (S)dict.getSerialized();
    }

    protected Path(String parent, String name, int type) {
        this.setPath(parent, name);
        this.attributes().setType(type);
    }

    protected Path(String path, int type) {
        this.setPath(path);
        this.attributes().setType(type);
    }

    protected Path(String parent, Local local) {
        this.setPath(parent, local);
        this.attributes().setType(local.attributes().isDirectory() ? 2 : 1);
    }

    protected void setPath(String parent, Local file) {
        this.setPath(parent, file.getName());
        this.setLocal(file);
    }

    protected void setPath(Path parent, String name) {
        super.setPath(parent.getAbsolute(), name);
        this.setParent(parent);
    }

    @Override
    protected void setPath(String name) {
        this.path = Path.normalize(name);
        this.parent = null;
        this.reference = null;
    }

    public void setParent(Path parent) {
        if (this.isChild(parent)) {
            this.parent = parent;
        } else {
            log.warn((Object)("Attempt to set invalid parent directory:" + parent));
        }
    }

    @Override
    public char getPathDelimiter() {
        return String.valueOf('/').charAt(0);
    }

    public static String normalize(String path) {
        return Path.normalize(path, true);
    }

    public static String normalize(String path, boolean absolute) {
        if (null == path) {
            return String.valueOf('/');
        }
        String normalized = path;
        if (Preferences.instance().getBoolean("path.normalize")) {
            String[] segments;
            int index;
            if (absolute) {
                while (!normalized.startsWith("\\\\") && !normalized.startsWith(String.valueOf('/'))) {
                    normalized = '/' + normalized;
                }
            }
            while (!normalized.endsWith(String.valueOf('/'))) {
                normalized = normalized + '/';
            }
            while ((index = normalized.indexOf("/./")) >= 0) {
                normalized = normalized.substring(0, index) + normalized.substring(index + 2);
            }
            while ((index = normalized.indexOf("/../")) >= 0) {
                if (index == 0) {
                    return String.valueOf('/');
                }
                normalized = normalized.substring(0, normalized.lastIndexOf(47, index - 1)) + normalized.substring(index + 3);
            }
            StringBuilder n = new StringBuilder();
            if (normalized.startsWith("//")) {
                n.append('/');
                n.append('/');
            } else if (!normalized.startsWith("\\\\")) {
                if (absolute) {
                    n.append('/');
                } else if (normalized.startsWith(String.valueOf('/'))) {
                    n.append('/');
                }
            }
            for (String segment : segments = normalized.split(String.valueOf('/'))) {
                if (segment.equals("")) continue;
                n.append(segment);
                n.append('/');
            }
            normalized = n.toString();
            while (normalized.endsWith(String.valueOf('/')) && normalized.length() > 1) {
                normalized = normalized.substring(0, normalized.length() - 1);
            }
        }
        if (Preferences.instance().getBoolean("path.normalize.unicode") && !Normalizer.isNormalized((String)normalized, (Normalizer.Mode)Normalizer.NFC, (int)32)) {
            normalized = Normalizer.normalize((String)normalized, (Normalizer.Mode)Normalizer.NFC, (int)32);
        }
        return normalized;
    }

    public boolean isContainer() {
        return this.equals(this.getContainer());
    }

    public String getContainerName() {
        if (StringUtils.isNotBlank((String)this.getHost().getDefaultPath())) {
            return Path.normalize(this.getHost().getDefaultPath(), true);
        }
        return String.valueOf('/');
    }

    public Path getContainer() {
        return PathFactory.createPath(this.getSession(), this.getContainerName(), 10);
    }

    @Override
    public Path getParent() {
        if (null == this.parent) {
            if (this.isRoot()) {
                return this;
            }
            String name = this.getParent(this.getAbsolute());
            this.parent = String.valueOf('/').equals(name) ? PathFactory.createPath(this.getSession(), String.valueOf('/'), 10) : PathFactory.createPath(this.getSession(), name, 2);
        }
        return this.parent;
    }

    @Override
    public PathAttributes attributes() {
        if (null == this.attributes) {
            this.attributes = new PathAttributes();
        }
        return this.attributes;
    }

    public Status status() {
        if (null == this.status) {
            this.status = new Status();
        }
        return this.status;
    }

    public Host getHost() {
        return this.getSession().getHost();
    }

    @Override
    public void invalidate() {
        if (this.attributes().isDirectory()) {
            this.getSession().cdn().clear();
        }
        super.invalidate();
    }

    public AttributedList<Path> list() {
        return this.list(new AttributedList<Path>(){

            @Override
            public boolean add(Path path) {
                if (!path.isChild(Path.this)) {
                    log.warn((Object)("Skip adding child to directory listing:" + path));
                    return false;
                }
                return super.add(path);
            }

            @Override
            public boolean addAll(Collection<? extends Path> c) {
                for (Path path : c) {
                    this.add(path);
                }
                return true;
            }
        });
    }

    protected abstract AttributedList<Path> list(AttributedList<Path> var1);

    public Cache<Path> cache() {
        return this.getSession().cache();
    }

    public void writeOwner(String owner, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    public void writeGroup(String group, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    public void readChecksum() {
    }

    public abstract void readSize();

    public abstract void readTimestamp();

    public abstract void readUnixPermission();

    public void writeAcl(Acl acl, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    public void readAcl() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        if (this.isRoot()) {
            return String.valueOf('/');
        }
        String abs = this.getAbsolute();
        int index = abs.lastIndexOf(47);
        return abs.substring(index + 1);
    }

    public String getKey() {
        return this.getWebPath(this.getAbsolute());
    }

    @Override
    public String getAbsolute() {
        return this.path;
    }

    public void setLocal(Local file) {
        this.local = file;
    }

    public Local getLocal() {
        if (null == this.local) {
            return this.getDefaultLocal();
        }
        return this.local;
    }

    private Local getDefaultLocal() {
        return LocalFactory.createLocal(this.getHost().getDownloadFolder(), this.getName());
    }

    public void setSymlinkTarget(String name) {
        this.symlink = name;
    }

    @Override
    public AbstractPath getSymlinkTarget() {
        if (this.attributes().isSymbolicLink()) {
            if (this.symlink.startsWith(String.valueOf('/'))) {
                return PathFactory.createPath(this.getSession(), this.symlink, this.attributes().isDirectory() ? 2 : 1);
            }
            return PathFactory.createPath(this.getSession(), this.getParent().getAbsolute(), this.symlink, this.attributes().isDirectory() ? 2 : 1);
        }
        return null;
    }

    @Override
    public void symlink(String target) {
        log.warn((Object)("Touching file instead of creating symbolic link:" + this));
        this.touch();
    }

    @Override
    public String kind() {
        if (this.attributes().isSymbolicLink()) {
            if (this.attributes().isFile()) {
                return Locale.localizedString("Symbolic Link (File)");
            }
            if (this.attributes().isDirectory()) {
                return Locale.localizedString("Symbolic Link (Folder)");
            }
        }
        if (this.attributes().isFile()) {
            return this.getLocal().kind();
        }
        if (this.attributes().isDirectory()) {
            return Locale.localizedString("Folder");
        }
        return Locale.localizedString("Unknown");
    }

    public abstract Session getSession();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void touch() {
        if (this.attributes().isFile()) {
            int no = 0;
            String filename = this.getLocal().getName();
            this.setLocal(LocalFactory.createLocal(Preferences.instance().getProperty("tmp.dir"), filename));
            while (this.getLocal().exists()) {
                String proposal = FilenameUtils.getBaseName((String)filename) + "-" + ++no;
                if (StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)filename))) {
                    proposal = proposal + "." + FilenameUtils.getExtension((String)filename);
                }
                this.setLocal(LocalFactory.createLocal(Preferences.instance().getProperty("tmp.dir"), proposal));
            }
            this.getLocal().touch(true);
            TransferOptions options = new TransferOptions();
            options.closeSession = false;
            try {
                UploadTransfer upload = new UploadTransfer(this);
                upload.start(new TransferPrompt(){

                    public TransferAction prompt() {
                        return TransferAction.ACTION_OVERWRITE;
                    }
                }, options);
                this.getParent().invalidate();
                Object var6_5 = null;
                this.getLocal().delete(false);
                this.setLocal(null);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.getLocal().delete(false);
                this.setLocal(null);
                throw throwable;
            }
        }
    }

    public void revert() {
        throw new UnsupportedOperationException();
    }

    protected void download() {
        this.download(new AbstractStreamListener());
    }

    protected void download(boolean check) {
        this.download(new BandwidthThrottle(-1.0f), new AbstractStreamListener(), check);
    }

    protected void download(StreamListener listener) {
        this.download(new BandwidthThrottle(-1.0f), listener);
    }

    protected void download(BandwidthThrottle throttle, StreamListener listener) {
        this.download(throttle, listener, false);
    }

    protected abstract void download(BandwidthThrottle var1, StreamListener var2, boolean var3);

    protected void upload() {
        this.upload(new AbstractStreamListener());
    }

    protected void upload(StreamListener listener) {
        this.upload(new BandwidthThrottle(-1.0f), listener);
    }

    protected void upload(BandwidthThrottle throttle, StreamListener listener) {
        this.upload(throttle, listener, false);
    }

    protected abstract void upload(BandwidthThrottle var1, StreamListener var2, boolean var3);

    protected void upload(OutputStream out, InputStream in, BandwidthThrottle throttle, StreamListener l) throws IOException {
        this.upload(out, in, throttle, l, this.status().getCurrent(), -1L);
    }

    protected void upload(OutputStream out, InputStream in, BandwidthThrottle throttle, StreamListener l, long offset, long limit) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("upload(" + out.toString() + ", " + in.toString()));
        }
        this.getSession().message(MessageFormat.format(Locale.localizedString("Uploading {0}", "Status"), this.getName()));
        if (offset > 0L) {
            long skipped = in.skip(offset);
            log.info((Object)("Skipping " + skipped + " bytes"));
            if (skipped < this.status().getCurrent()) {
                throw new IOResumeException("Skipped " + skipped + " bytes instead of " + this.status().getCurrent());
            }
        }
        this.transfer(in, new ThrottledOutputStream(out, throttle), l, limit);
    }

    protected void download(InputStream in, OutputStream out, BandwidthThrottle throttle, final StreamListener l) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("download(" + in.toString() + ", " + out.toString()));
        }
        this.getSession().message(MessageFormat.format(Locale.localizedString("Downloading {0}", "Status"), this.getName()));
        final boolean updateIcon = this.attributes().getSize() > Status.MEGA * 5L;
        final Local local = this.getLocal();
        local.setIcon(0);
        if (Preferences.instance().getBoolean("queue.download.quarantine")) {
            local.setQuarantine(this.getHost().toURL(), this.toURL());
        }
        if (Preferences.instance().getBoolean("queue.download.wherefrom")) {
            local.setWhereFrom(this.toURL());
        }
        StreamListener listener = new StreamListener(){
            int step = 0;

            public void bytesSent(long bytes) {
                l.bytesSent(bytes);
            }

            public void bytesReceived(long bytes) {
                if (-1L == bytes) {
                    local.setIcon(-1);
                } else {
                    int fraction;
                    l.bytesReceived(bytes);
                    if (updateIcon && (fraction = (int)(Path.this.status().getCurrent() / Path.this.attributes().getSize() * 10L)) > this.step) {
                        local.setIcon(++this.step);
                    }
                }
            }
        };
        this.transfer(new ThrottledInputStream(in, throttle), out, listener, -1L);
    }

    private void transfer(InputStream in, OutputStream out, StreamListener listener, long limit) throws IOException {
        byte[] chunk = new byte[CHUNKSIZE];
        long bytesTransferred = 0L;
        while (!this.status().isCanceled()) {
            int read = in.read(chunk, 0, CHUNKSIZE);
            listener.bytesReceived(read);
            if (-1 == read) {
                log.debug((Object)"End of file reached");
                this.status().setComplete(true);
                break;
            }
            out.write(chunk, 0, read);
            listener.bytesSent(read);
            this.status().addCurrent(read);
            if (limit != (bytesTransferred += (long)read)) continue;
            log.debug((Object)("Limit reached reading from stream:" + limit));
            if (0 != in.available()) break;
            this.status().setComplete(true);
            break;
        }
        out.flush();
        if (this.status().isCanceled()) {
            throw new ConnectionCanceledException("Interrupted transfer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(AbstractPath copy) {
        Local local = LocalFactory.createLocal(Preferences.instance().getProperty("tmp.dir"), copy.getName());
        TransferOptions options = new TransferOptions();
        options.closeSession = false;
        try {
            this.setLocal(local);
            DownloadTransfer download = new DownloadTransfer(this);
            download.addListener(new TransferAdapter(){

                public void transferDidEnd() {
                    Path.this.getSession().message(Locale.localizedString("Download complete", "Growl"));
                }
            });
            download.start(new TransferPrompt(){

                public TransferAction prompt() {
                    return TransferAction.ACTION_OVERWRITE;
                }
            }, options);
            if (download.isComplete()) {
                ((Path)copy).setLocal(local);
                UploadTransfer upload = new UploadTransfer((Path)copy);
                upload.addListener(new TransferAdapter(){

                    public void transferDidEnd() {
                        Path.this.getSession().message(Locale.localizedString("Upload complete", "Growl"));
                    }
                });
                upload.start(new TransferPrompt(){

                    public TransferAction prompt() {
                        return TransferAction.ACTION_OVERWRITE;
                    }
                }, options);
                copy.getParent().invalidate();
            } else {
                this.error("Cannot copy {0}");
            }
            Object var7_6 = null;
            this.setLocal(null);
            local.delete();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setLocal(null);
            local.delete();
            throw throwable;
        }
    }

    @Override
    public boolean exists() {
        if (this.isRoot()) {
            return true;
        }
        return this.getParent().children().contains(this.getReference());
    }

    public int hashCode() {
        return this.getReference().hashCode();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof Path) {
            return this.getReference().equals(((Path)other).getReference());
        }
        return false;
    }

    public String toString() {
        return this.getAbsolute();
    }

    public static String encode(String p) {
        try {
            StringBuilder b = new StringBuilder();
            StringTokenizer t = new StringTokenizer(p, "/");
            if (!t.hasMoreTokens()) {
                return p;
            }
            while (t.hasMoreTokens()) {
                b.append('/').append(URLEncoder.encode(t.nextToken(), "UTF-8"));
            }
            return b.toString().replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    @Override
    public String toURL() {
        return this.getHost().toURL() + Path.encode(this.getAbsolute());
    }

    public String toHttpURL() {
        return this.toHttpURL(this.getHost().getWebURL());
    }

    protected String toHttpURL(String host) {
        try {
            return new URI(host + this.getWebPath(this.getAbsolute())).normalize().toString();
        }
        catch (URISyntaxException e) {
            log.error((Object)("Failure parsing URI:" + e.getMessage()));
            return null;
        }
    }

    private String getWebPath(String path) {
        String documentRoot = this.getHost().getDefaultPath();
        if (StringUtils.isNotBlank((String)documentRoot) && path.contains(documentRoot)) {
            return Path.encode(Path.normalize(path.substring(path.indexOf(documentRoot) + documentRoot.length()), true));
        }
        return Path.encode(Path.normalize(path, true));
    }

    public AbstractPath.DescriptiveUrl toAuthenticatedUrl() {
        return new AbstractPath.DescriptiveUrl(null, null);
    }

    public Set<AbstractPath.DescriptiveUrl> getURLs() {
        LinkedHashSet<AbstractPath.DescriptiveUrl> list = new LinkedHashSet<AbstractPath.DescriptiveUrl>();
        list.add(new AbstractPath.DescriptiveUrl(this.toURL(), MessageFormat.format(Locale.localizedString("{0} URL"), this.getHost().getProtocol().getScheme().toUpperCase())));
        list.addAll(this.getHttpURLs());
        return list;
    }

    public Set<AbstractPath.DescriptiveUrl> getHttpURLs() {
        LinkedHashSet<AbstractPath.DescriptiveUrl> urls = new LinkedHashSet<AbstractPath.DescriptiveUrl>();
        String http = this.toHttpURL();
        if (StringUtils.isNotBlank((String)http)) {
            urls.add(new AbstractPath.DescriptiveUrl(http, MessageFormat.format(Locale.localizedString("{0} URL"), "HTTP")));
        }
        Session session = this.getSession();
        for (Distribution.Method method : session.cdn().getMethods()) {
            Distribution distribution;
            String container;
            if (!session.cdn().isConfigured(method) || null == (container = this.getContainerName()) || !(distribution = session.cdn().read(session.cdn().getOrigin(method, container), method)).isDeployed()) continue;
            urls.addAll(distribution.getURLs(this));
        }
        return urls;
    }

    protected void error(String message) {
        this.error(message, null);
    }

    protected void error(String message, Throwable throwable) {
        this.getSession().error(this, message, throwable);
    }

    public boolean isUploadResumable() {
        if (this.exists()) {
            this.readSize();
            return this.attributes().getSize() > 0L;
        }
        return false;
    }
}

