/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.DeserializerFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.serializer.SerializerFactory;
import java.util.Arrays;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Permission
implements Serializable {
    private static Logger log = Logger.getLogger(Permission.class);
    private static final int EMPTY_MASK = 0;
    public static final Permission EMPTY = new Permission(){

        public boolean isExecutable() {
            return true;
        }

        public boolean isReadable() {
            return true;
        }

        public boolean isWritable() {
            return true;
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public String toString() {
            return Locale.localizedString("Unknown");
        }
    };
    public static final int OWNER = 0;
    public static final int GROUP = 1;
    public static final int OTHER = 2;
    public static final int READ = 0;
    public static final int WRITE = 1;
    public static final int EXECUTE = 2;
    private boolean[] owner = new boolean[3];
    private boolean[] group = new boolean[3];
    private boolean[] other = new boolean[3];
    private boolean setuid;
    private boolean setgid;
    private boolean sticky;

    public <T> Permission(T dict) {
        this.init(dict);
    }

    @Override
    public <T> void init(T serialized) {
        Deserializer dict = DeserializerFactory.createDeserializer(serialized);
        String maskObj = dict.stringForKey("Mask");
        if (maskObj != null) {
            this.init(maskObj);
        }
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = SerializerFactory.createSerializer();
        dict.setStringForKey(this.getMask(), "Mask");
        return dict.getSerialized();
    }

    public Permission() {
        this(0);
    }

    public Permission(Permission p) {
        this.init(p.getMask());
    }

    public Permission(String symbolic) {
        this.init(symbolic);
    }

    private void init(String symbolic) {
        if (symbolic.length() != 9) {
            log.error((Object)("Invalid mask:" + symbolic));
            throw new NumberFormatException("Must be a nine digit string");
        }
        this.owner = this.getOwnerPermissions(symbolic);
        this.group = this.getGroupPermissions(symbolic);
        this.other = this.getOtherPermissions(symbolic);
    }

    public Permission(boolean[][] p) {
        this.init(p);
    }

    private void init(boolean[][] p) {
        this.owner[0] = p[0][0];
        this.owner[1] = p[0][1];
        this.owner[2] = p[0][2];
        this.group[0] = p[1][0];
        this.group[1] = p[1][1];
        this.group[2] = p[1][2];
        this.other[0] = p[2][0];
        this.other[1] = p[2][1];
        this.other[2] = p[2][2];
    }

    public Permission(int number) {
        String octal = String.valueOf(number);
        StringBuilder sb = new StringBuilder();
        for (int leadingZeros = 4 - octal.length(); leadingZeros > 0; --leadingZeros) {
            sb.append(String.valueOf(0));
        }
        sb.append(octal);
        octal = sb.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Permission:" + octal));
        }
        switch (Integer.parseInt(octal.substring(1, 2))) {
            case 0: {
                this.owner = new boolean[]{false, false, false};
                break;
            }
            case 1: {
                this.owner = new boolean[]{false, false, true};
                break;
            }
            case 2: {
                this.owner = new boolean[]{false, true, false};
                break;
            }
            case 3: {
                this.owner = new boolean[]{false, true, true};
                break;
            }
            case 4: {
                this.owner = new boolean[]{true, false, false};
                break;
            }
            case 5: {
                this.owner = new boolean[]{true, false, true};
                break;
            }
            case 6: {
                this.owner = new boolean[]{true, true, false};
                break;
            }
            case 7: {
                this.owner = new boolean[]{true, true, true};
            }
        }
        switch (Integer.parseInt(octal.substring(2, 3))) {
            case 0: {
                this.group = new boolean[]{false, false, false};
                break;
            }
            case 1: {
                this.group = new boolean[]{false, false, true};
                break;
            }
            case 2: {
                this.group = new boolean[]{false, true, false};
                break;
            }
            case 3: {
                this.group = new boolean[]{false, true, true};
                break;
            }
            case 4: {
                this.group = new boolean[]{true, false, false};
                break;
            }
            case 5: {
                this.group = new boolean[]{true, false, true};
                break;
            }
            case 6: {
                this.group = new boolean[]{true, true, false};
                break;
            }
            case 7: {
                this.group = new boolean[]{true, true, true};
            }
        }
        switch (Integer.parseInt(octal.substring(3, 4))) {
            case 0: {
                this.other = new boolean[]{false, false, false};
                break;
            }
            case 1: {
                this.other = new boolean[]{false, false, true};
                break;
            }
            case 2: {
                this.other = new boolean[]{false, true, false};
                break;
            }
            case 3: {
                this.other = new boolean[]{false, true, true};
                break;
            }
            case 4: {
                this.other = new boolean[]{true, false, false};
                break;
            }
            case 5: {
                this.other = new boolean[]{true, false, true};
                break;
            }
            case 6: {
                this.other = new boolean[]{true, true, false};
                break;
            }
            case 7: {
                this.other = new boolean[]{true, true, true};
            }
        }
    }

    public boolean[] getOwnerPermissions() {
        return this.owner;
    }

    public boolean[] getGroupPermissions() {
        return this.group;
    }

    public boolean[] getOtherPermissions() {
        return this.other;
    }

    public boolean isSetuid() {
        return this.setuid;
    }

    public boolean isSetgid() {
        return this.setgid;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    private boolean[] getOwnerPermissions(String s) {
        return new boolean[]{s.charAt(0) == 'r', s.charAt(1) == 'w', s.charAt(2) == 'x' || s.charAt(2) == 's' || s.charAt(2) == 'S' || s.charAt(2) == 't' || s.charAt(2) == 'T' || s.charAt(2) == 'L'};
    }

    private boolean[] getGroupPermissions(String s) {
        return new boolean[]{s.charAt(3) == 'r', s.charAt(4) == 'w', s.charAt(5) == 'x' || s.charAt(5) == 's' || s.charAt(5) == 'S' || s.charAt(5) == 't' || s.charAt(5) == 'T' || s.charAt(5) == 'L'};
    }

    private boolean[] getOtherPermissions(String s) {
        return new boolean[]{s.charAt(6) == 'r', s.charAt(7) == 'w', s.charAt(8) == 'x' || s.charAt(8) == 's' || s.charAt(8) == 'S' || s.charAt(8) == 't' || s.charAt(8) == 'T' || s.charAt(8) == 'L'};
    }

    public String toString() {
        return this.getMask() + " (" + this.getOctalString() + ")";
    }

    public String getMask() {
        String owner = this.getSymbolicMode(this.getOwnerPermissions());
        String group = this.getSymbolicMode(this.getGroupPermissions());
        String other = this.getSymbolicMode(this.getOtherPermissions());
        return owner + group + other;
    }

    public String getOctalString() {
        String owner = String.valueOf(this.getNumber(this.getOwnerPermissions()));
        String group = String.valueOf(this.getNumber(this.getGroupPermissions()));
        String other = String.valueOf(this.getNumber(this.getOtherPermissions()));
        return owner + group + other;
    }

    private int getNumber(boolean[] permissions) {
        if (Arrays.equals(permissions, new boolean[]{false, false, false})) {
            return 0;
        }
        if (Arrays.equals(permissions, new boolean[]{false, false, true})) {
            return 1;
        }
        if (Arrays.equals(permissions, new boolean[]{false, true, false})) {
            return 2;
        }
        if (Arrays.equals(permissions, new boolean[]{false, true, true})) {
            return 3;
        }
        if (Arrays.equals(permissions, new boolean[]{true, false, false})) {
            return 4;
        }
        if (Arrays.equals(permissions, new boolean[]{true, false, true})) {
            return 5;
        }
        if (Arrays.equals(permissions, new boolean[]{true, true, false})) {
            return 6;
        }
        if (Arrays.equals(permissions, new boolean[]{true, true, true})) {
            return 7;
        }
        return -1;
    }

    private String getSymbolicMode(boolean[] permissions) {
        String read = permissions[0] ? "r" : "-";
        String write = permissions[1] ? "w" : "-";
        String execute = permissions[2] ? "x" : "-";
        return read + write + execute;
    }

    public boolean isExecutable() {
        return this.getOwnerPermissions()[2] || this.getGroupPermissions()[2] || this.getOtherPermissions()[2];
    }

    public boolean isReadable() {
        return this.getOwnerPermissions()[0] || this.getGroupPermissions()[0] || this.getOtherPermissions()[0];
    }

    public boolean isWritable() {
        return this.getOwnerPermissions()[1] || this.getGroupPermissions()[1] || this.getOtherPermissions()[1];
    }

    public int hashCode() {
        return Integer.parseInt(this.getOctalString());
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o instanceof Permission) {
            Permission other = (Permission)o;
            return Integer.valueOf(this.getOctalString()).equals(Integer.valueOf(other.getOctalString()));
        }
        return false;
    }
}

