/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.PreferencesFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.i18n.Locale;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Preferences {
    private static Logger log = Logger.getLogger(Preferences.class);
    private static Preferences current = null;
    protected Map<String, String> defaults = new HashMap<String, String>();
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Preferences instance() {
        Object object = lock;
        synchronized (object) {
            if (null == current) {
                current = PreferencesFactory.createPreferences();
                current.load();
                current.setDefaults();
                current.post();
            }
            return current;
        }
    }

    protected void post() {
        if (this.getBoolean("connection.dns.ipv6")) {
            System.setProperty("java.net.preferIPv6Addresses", String.valueOf(true));
        }
    }

    public abstract void setProperty(String var1, String var2);

    public abstract void setProperty(String var1, List<String> var2);

    public abstract void deleteProperty(String var1);

    public void setProperty(String property, boolean v) {
        this.setProperty(property, v ? String.valueOf(true) : String.valueOf(false));
    }

    public void setProperty(String property, int v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, float v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, long v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, double v) {
        this.setProperty(property, String.valueOf(v));
    }

    protected void setDefaults() {
        this.defaults.put("tmp.dir", System.getProperty("java.io.tmpdir"));
        this.defaults.put("logging", "error");
        this.defaults.put("uses", "0");
        this.defaults.put("donate.reminder", String.valueOf(-1));
        this.defaults.put("donate.reminder.interval", String.valueOf(20));
        this.defaults.put("donate.reminder.date", String.valueOf(new Date(0L).getTime()));
        this.defaults.put("defaulthandler.reminder", String.valueOf(true));
        this.defaults.put("mail.feedback", "mailto:feedback@cyberduck.ch");
        this.defaults.put("website.donate", "http://cyberduck.ch/donate/");
        this.defaults.put("website.home", "http://cyberduck.ch/");
        this.defaults.put("website.forum", "http://forum.cyberduck.ch/");
        this.defaults.put("website.help", "http://help.cyberduck.ch/" + this.locale());
        this.defaults.put("website.bug", "http://trac.cyberduck.ch/newticket/");
        this.defaults.put("website.crash", "http://crash.cyberduck.ch/report");
        this.defaults.put("rendezvous.enable", String.valueOf(true));
        this.defaults.put("rendezvous.loopback.supress", String.valueOf(true));
        this.defaults.put("growl.enable", String.valueOf(true));
        this.defaults.put("growl.limit", String.valueOf(10));
        this.defaults.put("protocol." + Protocol.FTP + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.FTP_TLS + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.SFTP + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.WEBDAV + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.WEBDAV_SSL + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.IDISK + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.S3_SSL + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.S3 + ".enable", String.valueOf(false));
        this.defaults.put("protocol." + Protocol.GOOGLESTORAGE_SSL + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.EUCALYPTUS + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.CLOUDFILES + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.SWIFT + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.GDOCS_SSL + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.AZURE_SSL + ".enable", String.valueOf(true));
        this.defaults.put("protocol." + Protocol.DROPBOX_SSL + ".enable", String.valueOf(false));
        this.defaults.put("path.symboliclink.resolve", String.valueOf(false));
        this.defaults.put("path.normalize", String.valueOf(true));
        this.defaults.put("path.normalize.unicode", String.valueOf(false));
        this.defaults.put("local.symboliclink.resolve", String.valueOf(false));
        this.defaults.put("local.normalize.unicode", String.valueOf(true));
        this.defaults.put("browser.cache.size", String.valueOf(1000));
        this.defaults.put("transfer.cache.size", String.valueOf(50));
        this.defaults.put("icon.cache.size", String.valueOf(50));
        this.defaults.put("browser.model.cache.size", String.valueOf(200));
        this.defaults.put("bookmark.model.cache.size", String.valueOf(100));
        this.defaults.put("queue.model.cache.size", String.valueOf(50));
        this.defaults.put("info.toolbar.selected", String.valueOf(0));
        this.defaults.put("preferences.toolbar.selected", String.valueOf(0));
        this.defaults.put("browser.view", "1");
        this.defaults.put("browser.serialize", String.valueOf(true));
        this.defaults.put("browser.font.size", String.valueOf(12.0f));
        this.defaults.put("browser.view.autoexpand", String.valueOf(true));
        this.defaults.put("browser.view.autoexpand.useDelay", String.valueOf(true));
        this.defaults.put("browser.view.autoexpand.delay", "1.0");
        this.defaults.put("browser.hidden.regex", "\\..*");
        this.defaults.put("browser.openUntitled", String.valueOf(true));
        this.defaults.put("browser.defaultBookmark", Locale.localizedString("None"));
        this.defaults.put("browser.markInaccessibleFolders", String.valueOf(true));
        this.defaults.put("browser.confirmDisconnect", String.valueOf(false));
        this.defaults.put("browser.disconnect.showBookmarks", String.valueOf(false));
        this.defaults.put("browser.info.isInspector", String.valueOf(true));
        this.defaults.put("browser.columnKind", String.valueOf(false));
        this.defaults.put("browser.columnExtension", String.valueOf(false));
        this.defaults.put("browser.columnSize", String.valueOf(true));
        this.defaults.put("browser.columnModification", String.valueOf(true));
        this.defaults.put("browser.columnOwner", String.valueOf(false));
        this.defaults.put("browser.columnGroup", String.valueOf(false));
        this.defaults.put("browser.columnPermissions", String.valueOf(false));
        this.defaults.put("browser.sort.column", "FILENAME");
        this.defaults.put("browser.sort.ascending", String.valueOf(true));
        this.defaults.put("browser.alternatingRows", String.valueOf(false));
        this.defaults.put("browser.verticalLines", String.valueOf(false));
        this.defaults.put("browser.horizontalLines", String.valueOf(true));
        this.defaults.put("browser.showHidden", String.valueOf(false));
        this.defaults.put("browser.charset.encoding", "UTF-8");
        this.defaults.put("browser.doubleclick.edit", String.valueOf(false));
        this.defaults.put("browser.enterkey.rename", String.valueOf(true));
        this.defaults.put("browser.editable", String.valueOf(true));
        this.defaults.put("browser.confirmMove", String.valueOf(false));
        this.defaults.put("browser.logDrawer.isOpen", String.valueOf(false));
        this.defaults.put("browser.logDrawer.size.height", String.valueOf(200));
        this.defaults.put("browser.duplicate.format", "{0} ({1}){2}");
        this.defaults.put("browser.filesize.decimal", String.valueOf(false));
        this.defaults.put("info.toggle.permission", String.valueOf(1));
        this.defaults.put("info.toggle.distribution", String.valueOf(0));
        this.defaults.put("info.toggle.s3", String.valueOf(0));
        this.defaults.put("connection.toggle.options", String.valueOf(0));
        this.defaults.put("bookmark.toggle.options", String.valueOf(0));
        this.defaults.put("alert.toggle.transcript", String.valueOf(0));
        this.defaults.put("transfer.toggle.details", String.valueOf(1));
        this.defaults.put("editor.bundleIdentifier", "com.macromates.textmate");
        this.defaults.put("editor.alwaysUseDefault", String.valueOf(false));
        this.defaults.put("editor.odb.enable", String.valueOf(true));
        this.defaults.put("editor.kqueue.enable", String.valueOf(true));
        this.defaults.put("editor.tmp.directory", System.getProperty("java.io.tmpdir"));
        this.defaults.put("editor.file.trash", String.valueOf(true));
        this.defaults.put("filetype.text.regex", ".*\\.txt|.*\\.cgi|.*\\.htm|.*\\.html|.*\\.shtml|.*\\.xml|.*\\.xsl|.*\\.php|.*\\.php3|.*\\.js|.*\\.css|.*\\.asp|.*\\.java|.*\\.c|.*\\.cp|.*\\.cpp|.*\\.m|.*\\.h|.*\\.pl|.*\\.py|.*\\.rb|.*\\.sh");
        this.defaults.put("filetype.binary.regex", ".*\\.pdf|.*\\.ps|.*\\.exe|.*\\.bin|.*\\.jpeg|.*\\.jpg|.*\\.jp2|.*\\.gif|.*\\.tif|.*\\.ico|.*\\.icns|.*\\.tiff|.*\\.bmp|.*\\.pict|.*\\.sgi|.*\\.tga|.*\\.png|.*\\.psd|.*\\.hqx|.*\\.rar|.*\\.sea|.*\\.dmg|.*\\.zip|.*\\.sit|.*\\.tar|.*\\.gz|.*\\.tgz|.*\\.bz2|.*\\.avi|.*\\.qtl|.*\\.bom|.*\\.pax|.*\\.pgp|.*\\.mpg|.*\\.mpeg|.*\\.mp3|.*\\.m4p|.*\\.m4a|.*\\.mov|.*\\.avi|.*\\.qt|.*\\.ram|.*\\.aiff|.*\\.aif|.*\\.wav|.*\\.wma|.*\\.doc|.*\\.iso|.*\\.xls|.*\\.ppt");
        this.defaults.put("favorites.save", String.valueOf(true));
        this.defaults.put("queue.openByDefault", String.valueOf(false));
        this.defaults.put("queue.save", String.valueOf(true));
        this.defaults.put("queue.removeItemWhenComplete", String.valueOf(false));
        this.defaults.put("queue.maxtransfers", String.valueOf(5));
        this.defaults.put("queue.postProcessItemWhenComplete", String.valueOf(false));
        this.defaults.put("queue.orderFrontOnStart", String.valueOf(true));
        this.defaults.put("queue.orderBackOnStop", String.valueOf(false));
        this.defaults.put("queue.download.fileExists", TransferAction.ACTION_CALLBACK.toString());
        this.defaults.put("queue.upload.fileExists", TransferAction.ACTION_CALLBACK.toString());
        this.defaults.put("queue.download.reload.fileExists", TransferAction.ACTION_CALLBACK.toString());
        this.defaults.put("queue.upload.reload.fileExists", TransferAction.ACTION_CALLBACK.toString());
        this.defaults.put("queue.upload.changePermissions", String.valueOf(true));
        this.defaults.put("queue.upload.permissions.useDefault", String.valueOf(false));
        this.defaults.put("queue.upload.permissions.file.default", String.valueOf(644));
        this.defaults.put("queue.upload.permissions.folder.default", String.valueOf(755));
        this.defaults.put("queue.upload.preserveDate", String.valueOf(false));
        this.defaults.put("queue.upload.skip.enable", String.valueOf(true));
        this.defaults.put("queue.upload.skip.regex.default", ".*~\\..*|\\.DS_Store|\\.svn|CVS");
        this.defaults.put("queue.upload.skip.regex", ".*~\\..*|\\.DS_Store|\\.svn|CVS");
        this.defaults.put("queue.upload.file.temporary", String.valueOf(false));
        this.defaults.put("queue.upload.file.temporary.format", "{0}-{1}");
        this.defaults.put("queue.upload.file.rename.format", "{0} ({1}){2}");
        this.defaults.put("queue.download.file.rename.format", "{0} ({1}){2}");
        this.defaults.put("queue.download.changePermissions", String.valueOf(true));
        this.defaults.put("queue.download.permissions.useDefault", String.valueOf(false));
        this.defaults.put("queue.download.permissions.file.default", String.valueOf(644));
        this.defaults.put("queue.download.permissions.folder.default", String.valueOf(755));
        this.defaults.put("queue.download.preserveDate", String.valueOf(true));
        this.defaults.put("queue.download.skip.enable", String.valueOf(true));
        this.defaults.put("queue.download.skip.regex.default", ".*~\\..*|\\.DS_Store|\\.svn|CVS|RCS|SCCS|\\.git|\\.bzr|\\.bzrignore|\\.bzrtags|\\.hg|\\.hgignore|\\.hgtags|_darcs");
        this.defaults.put("queue.download.skip.regex", ".*~\\..*|\\.DS_Store|\\.svn|CVS|RCS|SCCS|\\.git|\\.bzr|\\.bzrignore|\\.bzrtags|\\.hg|\\.hgignore|\\.hgtags|_darcs");
        this.defaults.put("queue.download.quarantine", String.valueOf(true));
        this.defaults.put("queue.download.wherefrom", String.valueOf(true));
        this.defaults.put("queue.sync.compare.hash", String.valueOf(true));
        this.defaults.put("queue.sync.compare.size", String.valueOf(false));
        this.defaults.put("queue.dock.badge", String.valueOf(false));
        StringBuilder options = new StringBuilder();
        options.append(5L * Status.KILO).append(",");
        options.append(10L * Status.KILO).append(",");
        options.append(20L * Status.KILO).append(",");
        options.append(50L * Status.KILO).append(",");
        options.append(100L * Status.KILO).append(",");
        options.append(150L * Status.KILO).append(",");
        options.append(200L * Status.KILO).append(",");
        options.append(500L * Status.KILO).append(",");
        options.append(1L * Status.MEGA).append(",");
        options.append(2L * Status.MEGA).append(",");
        options.append(5L * Status.MEGA).append(",");
        options.append(10L * Status.MEGA).append(",");
        options.append(15L * Status.MEGA).append(",");
        options.append(20L * Status.MEGA).append(",");
        options.append(50L * Status.MEGA).append(",");
        options.append(100L * Status.MEGA).append(",");
        this.defaults.put("queue.bandwidth.options", options.toString());
        this.defaults.put("queue.transferspeed.bits", String.valueOf(false));
        this.defaults.put("queue.upload.bandwidth.bytes", String.valueOf(-1));
        this.defaults.put("queue.download.bandwidth.bytes", String.valueOf(-1));
        this.defaults.put("queue.download.updateIcon", String.valueOf(true));
        this.defaults.put("queue.sync.action.default", SyncTransfer.ACTION_UPLOAD.toString());
        this.defaults.put("queue.prompt.action.default", TransferAction.ACTION_OVERWRITE.toString());
        this.defaults.put("queue.logDrawer.isOpen", String.valueOf(false));
        this.defaults.put("queue.logDrawer.size.height", String.valueOf(200));
        this.defaults.put("ftp.command.feat", String.valueOf(true));
        this.defaults.put("ftp.command.lista", String.valueOf(true));
        this.defaults.put("ftp.command.stat", String.valueOf(true));
        this.defaults.put("ftp.command.mlsd", String.valueOf(true));
        this.defaults.put("ftp.command.utime", String.valueOf(true));
        this.defaults.put("ftp.connectmode.fallback", String.valueOf(true));
        this.defaults.put("ftp.tls.datachannel", "P");
        this.defaults.put("ftp.timezone.auto", String.valueOf(false));
        this.defaults.put("ftp.timezone.default", TimeZone.getDefault().getID());
        this.defaults.put("s3.location", "US");
        this.defaults.put("s3.storage.class", "STANDARD");
        this.defaults.put("s3.url.expire.seconds", String.valueOf(86400));
        this.defaults.put("s3.mfa.serialnumber", "");
        this.defaults.put("s3.listing.chunksize", String.valueOf(1000));
        this.defaults.put("s3.revisions.enable", String.valueOf(true));
        this.defaults.put("s3.upload.metadata.md5", String.valueOf(false));
        this.defaults.put("s3.upload.concurency", String.valueOf(5));
        this.defaults.put("s3.logging.prefix", "logs/");
        this.defaults.put("cloudfront.logging.prefix", "logs/");
        int MONTH = 2592000;
        this.defaults.put("s3.cache.seconds", String.valueOf(2592000));
        this.defaults.put("s3.metadata.default", "");
        this.defaults.put("azure.metadata.default", "");
        this.defaults.put("cf.authentication.host", "auth.api.rackspacecloud.com");
        this.defaults.put("cf.authentication.context", "/v1.0");
        this.defaults.put("cf.upload.metadata.md5", String.valueOf(false));
        this.defaults.put("cf.metadata.default", "");
        this.defaults.put("cf.list.limit", String.valueOf(10000));
        this.defaults.put("google.docs.export.document", "doc");
        this.defaults.put("google.docs.export.document.formats", "doc,html,odt,pdf,png,rtf,txt,zip");
        this.defaults.put("google.docs.export.presentation", "ppt");
        this.defaults.put("google.docs.export.presentation.formats", "ppt,pdf,png,swf,txt");
        this.defaults.put("google.docs.export.spreadsheet", "xls");
        this.defaults.put("google.docs.export.spreadsheet.formats", "xls,csv,pdf,ods,tsv,html");
        this.defaults.put("google.docs.upload.convert", String.valueOf(true));
        this.defaults.put("google.docs.upload.ocr", String.valueOf(false));
        this.defaults.put("google.docs.revisions.enable", String.valueOf(false));
        this.defaults.put("dropbox.key", "");
        this.defaults.put("dropbox.secret", "");
        this.defaults.put("webdav.ntlm.domain", "");
        this.defaults.put("webdav.followRedirects", String.valueOf(true));
        this.defaults.put("connection.host.max", String.valueOf(-1));
        this.defaults.put("connection.login.name", System.getProperty("user.name"));
        this.defaults.put("connection.login.anon.name", "anonymous");
        this.defaults.put("connection.login.anon.pass", "cyberduck@example.net");
        this.defaults.put("connection.login.useKeychain", String.valueOf(true));
        this.defaults.put("connection.login.addKeychain", String.valueOf(true));
        this.defaults.put("connection.port.default", String.valueOf(21));
        this.defaults.put("connection.protocol.default", Protocol.FTP.getIdentifier());
        this.defaults.put("connection.timeout.seconds", String.valueOf(30));
        this.defaults.put("connection.retry", String.valueOf(0));
        this.defaults.put("connection.retry.delay", String.valueOf(10));
        this.defaults.put("connection.hostname.default", "");
        this.defaults.put("connection.hostname.check", String.valueOf(true));
        this.defaults.put("connection.hostname.idn", String.valueOf(true));
        this.defaults.put("connection.dns.ipv6", String.valueOf(false));
        this.defaults.put("connection.proxy.enable", String.valueOf(true));
        this.defaults.put("connection.proxy.ntlm.domain", "");
        this.defaults.put("connection.unsecure.warning", String.valueOf(false));
        this.defaults.put("connection.unsecure.switch", String.valueOf(true));
        this.defaults.put("connection.ssl.protocols", "SSLv3, TLSv1");
        this.defaults.put("connection.chunksize", String.valueOf(32768));
        this.defaults.put("transcript.length", String.valueOf(1000));
        this.defaults.put("bookmark.favicon.download", String.valueOf(true));
        this.defaults.put("bookmark.icon.size", String.valueOf(64));
        this.defaults.put("ssh.transfer", Protocol.SFTP.getIdentifier());
        this.defaults.put("ssh.CSEncryption", "blowfish-cbc");
        this.defaults.put("ssh.SCEncryption", "blowfish-cbc");
        this.defaults.put("ssh.CSAuthentication", "hmac-md5");
        this.defaults.put("ssh.SCAuthentication", "hmac-md5");
        this.defaults.put("ssh.publickey", "ssh-rsa");
        this.defaults.put("ssh.compression", "none");
        this.defaults.put("ssh.authentication.publikey.default.enable", String.valueOf(true));
        this.defaults.put("ssh.authentication.publickey.default.rsa", "~/.ssh/id_rsa");
        this.defaults.put("ssh.authentication.publickey.default.dsa", "~/.ssh/id_dsa");
        this.defaults.put("archive.default", "tar.gz");
        this.defaults.put("archive.command.create.tar", "tar -cpPf {0}.tar {1}");
        this.defaults.put("archive.command.create.tar.gz", "tar -czpPf {0}.tar.gz {1}");
        this.defaults.put("archive.command.create.tar.bz2", "tar -cjpPf {0}.tar.bz2 {1}");
        this.defaults.put("archive.command.create.zip", "zip -qr {0}.zip {1}");
        this.defaults.put("archive.command.create.gz", "gzip -qr {1}");
        this.defaults.put("archive.command.create.bz2", "bzip2 -zk {1}");
        this.defaults.put("archive.command.expand.tar", "tar -xpPf {0} -C {1}");
        this.defaults.put("archive.command.expand.tar.gz", "tar -xzpPf {0} -C {1}");
        this.defaults.put("archive.command.expand.tar.bz2", "tar -xjpPf {0} -C {1}");
        this.defaults.put("archive.command.expand.zip", "unzip -qn {0} -d {1}");
        this.defaults.put("archive.command.expand.gz", "gzip -d {0}");
        this.defaults.put("archive.command.expand.bz2", "bzip2 -dk {0}");
        this.defaults.put("update.check", String.valueOf(true));
        int DAY = 86400;
        this.defaults.put("update.check.interval", String.valueOf(86400));
        this.defaults.put("terminal.bundle.identifier", "com.apple.Terminal");
        this.defaults.put("terminal.command", "do script \"{0}\"");
        this.defaults.put("terminal.command.ssh", "ssh -t {0} {1}@{2} -p {3} \"cd {4} && exec \\$SHELL\"");
    }

    public String getDefault(String property) {
        String value = this.defaults.get(property);
        if (null == value) {
            log.warn((Object)("No property with key '" + property + "'"));
        }
        return value;
    }

    public List<String> getList(String property) {
        return Arrays.asList(this.getProperty(property).split("\\p{javaWhitespace}+"));
    }

    public abstract String getProperty(String var1);

    public int getInteger(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1;
        }
        return Integer.parseInt(v);
    }

    public float getFloat(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1.0f;
        }
        return Float.parseFloat(v);
    }

    public long getLong(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1L;
        }
        return Long.parseLong(v);
    }

    public double getDouble(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1.0;
        }
        return Double.parseDouble(v);
    }

    public boolean getBoolean(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return false;
        }
        if (v.equalsIgnoreCase(String.valueOf(true))) {
            return true;
        }
        if (v.equalsIgnoreCase(String.valueOf(false))) {
            return false;
        }
        if (v.equalsIgnoreCase(String.valueOf(1))) {
            return true;
        }
        if (v.equalsIgnoreCase(String.valueOf(0))) {
            return false;
        }
        try {
            return v.equalsIgnoreCase("yes");
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public abstract void save();

    protected abstract void load();

    public String locale() {
        return this.applicationLocales().iterator().next();
    }

    public abstract List<String> applicationLocales();

    public abstract List<String> systemLocales();

    public String getDisplayName(String locale) {
        java.util.Locale l = StringUtils.contains((String)locale, (String)"_") ? new java.util.Locale(locale.split("_")[0], locale.split("_")[1]) : new java.util.Locale(locale);
        return StringUtils.capitalize((String)l.getDisplayName(l));
    }

    static {
        System.setProperty("networkaddress.cache.ttl", "10");
        System.setProperty("networkaddress.cache.negative.ttl", "5");
        lock = new Object();
    }
}

