/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.azure.AzurePath;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.cf.CFPath;
import ch.cyberduck.core.cf.CFSession;
import ch.cyberduck.core.dav.DAVPath;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.dropbox.DropboxPath;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.eucalyptus.ECPath;
import ch.cyberduck.core.eucalyptus.ECSession;
import ch.cyberduck.core.ftp.FTPPath;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.gdocs.GDPath;
import ch.cyberduck.core.gdocs.GDSession;
import ch.cyberduck.core.gstorage.GSPath;
import ch.cyberduck.core.gstorage.GSSession;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.idisk.IDiskPath;
import ch.cyberduck.core.idisk.IDiskSession;
import ch.cyberduck.core.s3.S3Path;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.sftp.SFTPPath;
import ch.cyberduck.core.sftp.SFTPSession;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.Constants;
import org.soyatec.windows.azure.authenticate.Base64;

public abstract class Protocol {
    protected static Logger log = Logger.getLogger(Protocol.class);
    public static final Protocol SFTP = new Protocol(){

        public String getDescription() {
            return Locale.localizedString("SFTP (SSH File Transfer Protocol)");
        }

        public int getDefaultPort() {
            return 22;
        }

        public String getScheme() {
            return "sftp";
        }

        public boolean isSecure() {
            return true;
        }

        public boolean isEncodingConfigurable() {
            return true;
        }

        public boolean validate(Credentials credentials) {
            if (credentials.isPublicKeyAuthentication()) {
                return StringUtils.isNotBlank((String)credentials.getUsername());
            }
            return FTP.validate(credentials);
        }

        public SessionFactory getSessionFactory() {
            return SFTPSession.factory();
        }

        public PathFactory getPathFactory() {
            return SFTPPath.factory();
        }
    };
    public static final Protocol SCP = new Protocol(){

        public String getDescription() {
            return Locale.localizedString("SCP (Secure Copy)");
        }

        public int getDefaultPort() {
            return 22;
        }

        public String getScheme() {
            return "scp";
        }

        public boolean isSecure() {
            return true;
        }

        public SessionFactory getSessionFactory() {
            throw new RuntimeException();
        }

        public PathFactory getPathFactory() {
            throw new RuntimeException();
        }

        public boolean isEnabled() {
            return false;
        }
    };
    public static final Protocol FTP = new Protocol(){

        public String getDescription() {
            return Locale.localizedString("FTP (File Transfer Protocol)");
        }

        public int getDefaultPort() {
            return 21;
        }

        public String getScheme() {
            return "ftp";
        }

        public boolean isUTCTimezone() {
            return false;
        }

        public boolean isEncodingConfigurable() {
            return true;
        }

        public boolean isConnectModeConfigurable() {
            return true;
        }

        public boolean validate(Credentials credentials) {
            return StringUtils.isNotBlank((String)credentials.getUsername()) && null != credentials.getPassword();
        }

        public SessionFactory getSessionFactory() {
            return FTPSession.factory();
        }

        public PathFactory getPathFactory() {
            return FTPPath.factory();
        }
    };
    public static final Protocol FTP_TLS = new Protocol(){

        public String getName() {
            return "FTP-SSL";
        }

        public String getDescription() {
            return Locale.localizedString("FTP-SSL (Explicit AUTH TLS)");
        }

        public int getDefaultPort() {
            return 21;
        }

        public String getScheme() {
            return "ftps";
        }

        public boolean isSecure() {
            return true;
        }

        public String disk() {
            return SFTP.disk();
        }

        public String icon() {
            return SFTP.icon();
        }

        public boolean isUTCTimezone() {
            return false;
        }

        public boolean isEncodingConfigurable() {
            return true;
        }

        public boolean isConnectModeConfigurable() {
            return true;
        }

        public SessionFactory getSessionFactory() {
            return FTPSession.factory();
        }

        public PathFactory getPathFactory() {
            return FTPPath.factory();
        }
    };
    public static final Protocol S3_SSL = new Protocol(){

        public String getName() {
            return "S3";
        }

        public String getDescription() {
            return Locale.localizedString("S3 (Amazon Simple Storage Service)", "S3");
        }

        public String getIdentifier() {
            return "s3";
        }

        public int getDefaultPort() {
            return 443;
        }

        public boolean isPortConfigurable() {
            return false;
        }

        public String getScheme() {
            return "https";
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "s3"};
        }

        public boolean isSecure() {
            return true;
        }

        public String getDefaultHostname() {
            return Constants.S3_DEFAULT_HOSTNAME;
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }

        public String getUsernamePlaceholder() {
            return Locale.localizedString("Access Key ID", "S3");
        }

        public String getPasswordPlaceholder() {
            return Locale.localizedString("Secret Access Key", "S3");
        }

        public String favicon() {
            return this.icon();
        }

        public SessionFactory getSessionFactory() {
            return S3Session.factory();
        }

        public PathFactory getPathFactory() {
            return S3Path.factory();
        }
    };
    public static final Protocol S3 = new Protocol(){

        public String getName() {
            return "S3";
        }

        public String getDescription() {
            return Locale.localizedString("S3/HTTP (Amazon Simple Storage Service)", "S3");
        }

        public String getIdentifier() {
            return "s3h";
        }

        public int getDefaultPort() {
            return 80;
        }

        public boolean isPortConfigurable() {
            return false;
        }

        public String getScheme() {
            return "http";
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "s3"};
        }

        public String getDefaultHostname() {
            return Constants.S3_DEFAULT_HOSTNAME;
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }

        public String getUsernamePlaceholder() {
            return Locale.localizedString("Access Key ID", "S3");
        }

        public String getPasswordPlaceholder() {
            return Locale.localizedString("Secret Access Key", "S3");
        }

        public String disk() {
            return S3_SSL.disk();
        }

        public String icon() {
            return S3_SSL.icon();
        }

        public String favicon() {
            return this.icon();
        }

        public SessionFactory getSessionFactory() {
            return S3Session.factory();
        }

        public PathFactory getPathFactory() {
            return S3Path.factory();
        }
    };
    public static final Protocol EUCALYPTUS = new Protocol(){

        public String getName() {
            return "S3";
        }

        public String getDescription() {
            return Locale.localizedString("Eucalyptus Walrus S3", "S3");
        }

        public String getIdentifier() {
            return "ec";
        }

        public String getDefaultHostname() {
            return "ecc.eucalyptus.com";
        }

        public int getDefaultPort() {
            return 8443;
        }

        public String getScheme() {
            return "https";
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "walrus"};
        }

        public boolean isSecure() {
            return true;
        }

        public boolean isHostnameConfigurable() {
            return true;
        }

        public String disk() {
            return S3_SSL.disk();
        }

        public String icon() {
            return "eucalyptus-icon";
        }

        public SessionFactory getSessionFactory() {
            return ECSession.factory();
        }

        public PathFactory getPathFactory() {
            return ECPath.factory();
        }
    };
    public static final Protocol WEBDAV = new Protocol(){

        public String getName() {
            return "WebDAV (HTTP)";
        }

        public String getDescription() {
            return Locale.localizedString("WebDAV (Web-based Distributed Authoring and Versioning)");
        }

        public String getIdentifier() {
            return "dav";
        }

        public int getDefaultPort() {
            return 80;
        }

        public String getScheme() {
            return "http";
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "dav"};
        }

        public String disk() {
            return FTP.disk();
        }

        public String icon() {
            return FTP.icon();
        }

        public SessionFactory getSessionFactory() {
            return DAVSession.factory();
        }

        public PathFactory getPathFactory() {
            return DAVPath.factory();
        }
    };
    public static final Protocol WEBDAV_SSL = new Protocol(){

        public String getName() {
            return "WebDAV (HTTPS)";
        }

        public String getDescription() {
            return Locale.localizedString("WebDAV (HTTP/SSL)");
        }

        public String getIdentifier() {
            return "davs";
        }

        public int getDefaultPort() {
            return 443;
        }

        public String getScheme() {
            return "https";
        }

        public boolean isSecure() {
            return true;
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "davs"};
        }

        public String disk() {
            return FTP_TLS.disk();
        }

        public String icon() {
            return FTP_TLS.icon();
        }

        public SessionFactory getSessionFactory() {
            return DAVSession.factory();
        }

        public PathFactory getPathFactory() {
            return DAVPath.factory();
        }
    };
    public static final Protocol IDISK = new Protocol(){

        public String getName() {
            return "MobileMe";
        }

        public String getDescription() {
            return Locale.localizedString("MobileMe iDisk (WebDAV)");
        }

        public String getIdentifier() {
            return "me";
        }

        public int getDefaultPort() {
            return 443;
        }

        public boolean isPortConfigurable() {
            return false;
        }

        public String getScheme() {
            return "https";
        }

        public boolean isSecure() {
            return true;
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "idisk"};
        }

        public boolean isHostnameConfigurable() {
            return false;
        }

        public String getDefaultHostname() {
            return "idisk.me.com";
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }

        public boolean isAnonymousConfigurable() {
            return false;
        }

        public String disk() {
            return WEBDAV_SSL.disk();
        }

        public String icon() {
            return "NSDotMac";
        }

        public String getUsernamePlaceholder() {
            return Locale.localizedString("MobileMe Member Name", "IDisk");
        }

        public SessionFactory getSessionFactory() {
            return IDiskSession.factory();
        }

        public PathFactory getPathFactory() {
            return IDiskPath.factory();
        }
    };
    public static final Protocol CLOUDFILES = new Protocol(){

        public String getName() {
            return Locale.localizedString("Cloud Files", "Mosso");
        }

        public String getDescription() {
            return Locale.localizedString("Rackspace Cloud Files", "Mosso");
        }

        public String getIdentifier() {
            return "cf";
        }

        public int getDefaultPort() {
            return 443;
        }

        public boolean isPortConfigurable() {
            return false;
        }

        public String getScheme() {
            return "https";
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "mosso", "cloudfiles", "cf"};
        }

        public boolean isSecure() {
            return true;
        }

        public boolean isHostnameConfigurable() {
            return false;
        }

        public String getDefaultHostname() {
            return "storage.clouddrive.com";
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }

        public boolean isAnonymousConfigurable() {
            return false;
        }

        public String getPasswordPlaceholder() {
            return Locale.localizedString("API Access Key", "Mosso");
        }

        public SessionFactory getSessionFactory() {
            return CFSession.factory();
        }

        public PathFactory getPathFactory() {
            return CFPath.factory();
        }
    };
    public static final Protocol SWIFT = new Protocol(){

        public String getName() {
            return Locale.localizedString("Swift", "Mosso");
        }

        public String getDescription() {
            return Locale.localizedString("Swift (OpenStack Object Storage)", "Mosso");
        }

        public String getIdentifier() {
            return "swift";
        }

        public int getDefaultPort() {
            return 443;
        }

        public String getScheme() {
            return "https";
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "swift"};
        }

        public boolean isSecure() {
            return true;
        }

        public boolean isHostnameConfigurable() {
            return true;
        }

        public String getDefaultHostname() {
            return "auth.api.rackspacecloud.com";
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }

        public boolean isAnonymousConfigurable() {
            return false;
        }

        public String getPasswordPlaceholder() {
            return Locale.localizedString("API Access Key", "Mosso");
        }

        public SessionFactory getSessionFactory() {
            return CFSession.factory();
        }

        public PathFactory getPathFactory() {
            return CFPath.factory();
        }
    };
    public static final Protocol GDOCS_SSL = new Protocol(){

        public String getName() {
            return Locale.localizedString("Google Docs");
        }

        public String getDescription() {
            return this.getName();
        }

        public String getIdentifier() {
            return "gd";
        }

        public String disk() {
            return "google";
        }

        public String icon() {
            return "google-icon";
        }

        public boolean isSecure() {
            return true;
        }

        public boolean isHostnameConfigurable() {
            return false;
        }

        public String getDefaultHostname() {
            return "docs.google.com";
        }

        public String getScheme() {
            return "https";
        }

        public int getDefaultPort() {
            return 443;
        }

        public boolean isPortConfigurable() {
            return false;
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }

        public boolean isAnonymousConfigurable() {
            return false;
        }

        public String getUsernamePlaceholder() {
            return Locale.localizedString("Google Account Email", "S3");
        }

        public String getPasswordPlaceholder() {
            return Locale.localizedString("Google Account Password", "S3");
        }

        public String favicon() {
            return this.icon();
        }

        public boolean validate(Credentials credentials) {
            if (super.validate(credentials)) {
                try {
                    new InternetAddress(credentials.getUsername()).validate();
                    return true;
                }
                catch (AddressException e) {
                    log.warn((Object)e.getMessage());
                }
            }
            return false;
        }

        public SessionFactory getSessionFactory() {
            return GDSession.factory();
        }

        public PathFactory getPathFactory() {
            return GDPath.factory();
        }
    };
    public static final Protocol GOOGLESTORAGE_SSL = new Protocol(){

        public String getName() {
            return "Google Storage";
        }

        public String getDescription() {
            return Locale.localizedString("Google Storage", "S3");
        }

        public String getIdentifier() {
            return "gs";
        }

        public String disk() {
            return "google";
        }

        public String icon() {
            return "google-icon";
        }

        public boolean isSecure() {
            return true;
        }

        public boolean isHostnameConfigurable() {
            return false;
        }

        public String getDefaultHostname() {
            return "commondatastorage.googleapis.com";
        }

        public String getScheme() {
            return "https";
        }

        public int getDefaultPort() {
            return 443;
        }

        public boolean isPortConfigurable() {
            return false;
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }

        public boolean isAnonymousConfigurable() {
            return false;
        }

        public String getUsernamePlaceholder() {
            return Locale.localizedString("Access Key", "S3");
        }

        public String getPasswordPlaceholder() {
            return Locale.localizedString("Secret", "S3");
        }

        public String favicon() {
            return this.icon();
        }

        public SessionFactory getSessionFactory() {
            return GSSession.factory();
        }

        public PathFactory getPathFactory() {
            return GSPath.factory();
        }
    };
    public static final Protocol AZURE_SSL = new Protocol(){

        public String getName() {
            return "Azure";
        }

        public String getDescription() {
            return "Windows Azure Cloud Storage";
        }

        public String getIdentifier() {
            return "azure";
        }

        public boolean isSecure() {
            return true;
        }

        public boolean isHostnameConfigurable() {
            return false;
        }

        public String getDefaultHostname() {
            return "blob.core.windows.net";
        }

        public String getScheme() {
            return "https";
        }

        public int getDefaultPort() {
            return 443;
        }

        public boolean isPortConfigurable() {
            return false;
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }

        public boolean isAnonymousConfigurable() {
            return false;
        }

        public String getUsernamePlaceholder() {
            return Locale.localizedString(" Storage Account Name", "Azure");
        }

        public String getPasswordPlaceholder() {
            return Locale.localizedString("Primary Access Key", "Azure");
        }

        public boolean validate(Credentials credentials) {
            if (super.validate(credentials)) {
                return null != Base64.decode(credentials.getPassword());
            }
            return false;
        }

        public String favicon() {
            return this.icon();
        }

        public SessionFactory getSessionFactory() {
            return AzureSession.factory();
        }

        public PathFactory getPathFactory() {
            return AzurePath.factory();
        }
    };
    public static final Protocol DROPBOX_SSL = new Protocol(){

        public String getName() {
            return "Dropbox";
        }

        public String getDescription() {
            return "Dropbox";
        }

        public String getIdentifier() {
            return "dropbox";
        }

        public boolean isSecure() {
            return true;
        }

        public boolean isHostnameConfigurable() {
            return false;
        }

        public String getDefaultHostname() {
            return "api.getdropbox.com";
        }

        public String getScheme() {
            return "https";
        }

        public int getDefaultPort() {
            return 443;
        }

        public boolean isPortConfigurable() {
            return false;
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }

        public boolean isAnonymousConfigurable() {
            return false;
        }

        public String getUsernamePlaceholder() {
            return Locale.localizedString("Email Address", "S3");
        }

        public String favicon() {
            return this.icon();
        }

        public SessionFactory getSessionFactory() {
            return DropboxSession.factory();
        }

        public PathFactory getPathFactory() {
            return DropboxPath.factory();
        }
    };

    public String getIdentifier() {
        return this.getScheme();
    }

    public String getVendor() {
        return this.getIdentifier();
    }

    public String getName() {
        return this.getScheme().toUpperCase();
    }

    public String favicon() {
        return null;
    }

    public boolean isEnabled() {
        return Preferences.instance().getBoolean("protocol." + this.getIdentifier() + ".enable");
    }

    public void register() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Register protocol:" + this));
        }
        SessionFactory.addFactory(this, this.getSessionFactory());
        PathFactory.addFactory(this, this.getPathFactory());
    }

    public abstract String getDescription();

    public abstract String getScheme();

    public String[] getSchemes() {
        return new String[]{this.getScheme()};
    }

    public boolean equals(Object other) {
        if (other instanceof Protocol) {
            return ((Protocol)other).getIdentifier().equals(this.getIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public String toString() {
        return this.getIdentifier();
    }

    public String disk() {
        return this.getIdentifier();
    }

    public String icon() {
        return this.getIdentifier() + "-icon";
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isHostnameConfigurable() {
        return true;
    }

    public boolean isPortConfigurable() {
        return true;
    }

    public boolean isWebUrlConfigurable() {
        return true;
    }

    public boolean isEncodingConfigurable() {
        return false;
    }

    public boolean isConnectModeConfigurable() {
        return false;
    }

    public boolean isAnonymousConfigurable() {
        return true;
    }

    public boolean isUTCTimezone() {
        return true;
    }

    public String getUsernamePlaceholder() {
        return Locale.localizedString("Username", "Credentials");
    }

    public String getPasswordPlaceholder() {
        return Locale.localizedString("Password", "Credentials");
    }

    public String getDefaultHostname() {
        return Preferences.instance().getProperty("connection.hostname.default");
    }

    public abstract SessionFactory getSessionFactory();

    public abstract PathFactory getPathFactory();

    public boolean validate(Credentials credentials) {
        return StringUtils.isNotBlank((String)credentials.getUsername()) && StringUtils.isNotEmpty((String)credentials.getPassword());
    }

    public abstract int getDefaultPort();
}

