/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.RendezvousFactory;
import ch.cyberduck.core.RendezvousListener;
import ch.cyberduck.core.i18n.Locale;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendezvousCollection
extends AbstractHostCollection {
    private static RendezvousCollection RENDEZVOUS_COLLECTION = new RendezvousCollection();

    private RendezvousCollection() {
        RendezvousFactory.instance().addListener(new RendezvousListener(){

            public void serviceResolved(String identifier, Host host) {
                RendezvousCollection.this.collectionItemAdded(host);
            }

            public void serviceLost(String servicename) {
                RendezvousCollection.this.collectionItemRemoved(null);
            }
        });
    }

    public static RendezvousCollection defaultCollection() {
        return RENDEZVOUS_COLLECTION;
    }

    @Override
    public String getName() {
        return Locale.localizedString("Bonjour");
    }

    @Override
    public Host get(int row) {
        return RendezvousFactory.instance().getService(row);
    }

    @Override
    public int size() {
        return RendezvousFactory.instance().numberOfServices();
    }

    @Override
    public Host remove(int row) {
        return null;
    }

    @Override
    public Object[] toArray() {
        Object[] content = new Host[this.size()];
        int i = 0;
        for (Host host : this) {
            content[i] = host;
        }
        return content;
    }

    @Override
    public Iterator<Host> iterator() {
        return RendezvousFactory.instance().iterator();
    }

    @Override
    public boolean allowsAdd() {
        return false;
    }

    @Override
    public boolean allowsDelete() {
        return false;
    }

    @Override
    public boolean allowsEdit() {
        return false;
    }
}

