/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractRendezvous;
import ch.cyberduck.core.Rendezvous;
import ch.cyberduck.core.RendezvousFactory;
import ch.cyberduck.ui.cocoa.foundation.NSAutoreleasePool;
import com.apple.dnssd.BrowseListener;
import com.apple.dnssd.DNSSD;
import com.apple.dnssd.DNSSDException;
import com.apple.dnssd.DNSSDService;
import com.apple.dnssd.ResolveListener;
import com.apple.dnssd.TXTRecord;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class RendezvousResponder
extends AbstractRendezvous
implements BrowseListener,
ResolveListener {
    private static Logger log = Logger.getLogger(RendezvousResponder.class);
    private Map<String, DNSSDService> browsers;
    private static RendezvousResponder instance = null;
    private static final Object lock = new Object();

    public static void register() {
        RendezvousFactory.addFactory(Factory.NATIVE_PLATFORM, new Factory());
    }

    private RendezvousResponder() {
        log.debug((Object)"Rendezvous");
        this.browsers = new ConcurrentHashMap<String, DNSSDService>();
    }

    public void init() {
        log.debug((Object)"init");
        try {
            for (String protocol : this.getServiceTypes()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Adding Rendezvous service listener for " + protocol));
                }
                this.browsers.put(protocol, DNSSD.browse((String)protocol, (BrowseListener)this));
            }
        }
        catch (DNSSDException e) {
            log.error((Object)e.getMessage());
            this.quit();
        }
    }

    public void quit() {
        for (String protocol : this.getServiceTypes()) {
            DNSSDService service;
            if (log.isInfoEnabled()) {
                log.info((Object)("Removing Rendezvous service listener for " + protocol));
            }
            if (null == (service = this.browsers.get(protocol))) continue;
            service.stop();
        }
    }

    public void serviceFound(DNSSDService browser, int flags, int ifIndex, String servicename, String regType, String domain) {
        log.debug((Object)("serviceFound:" + servicename));
        try {
            DNSSD.resolve((int)flags, (int)ifIndex, (String)servicename, (String)regType, (String)domain, (ResolveListener)this);
        }
        catch (DNSSDException e) {
            log.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceLost(DNSSDService browser, int flags, int ifIndex, String serviceName, String regType, String domain) {
        log.debug((Object)("serviceLost:" + serviceName));
        NSAutoreleasePool pool = NSAutoreleasePool.push();
        try {
            String identifier = DNSSD.constructFullName((String)serviceName, (String)regType, (String)domain);
            this.remove(identifier);
        }
        catch (DNSSDException e) {
            log.error((Object)e.getMessage());
        }
        finally {
            pool.drain();
        }
    }

    public void operationFailed(DNSSDService resolver, int errorCode) {
        log.warn((Object)("operationFailed:" + errorCode));
        resolver.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceResolved(DNSSDService resolver, int flags, int ifIndex, String fullname, String hostname, int port, TXTRecord txtRecord) {
        log.debug((Object)("serviceResolved:" + fullname));
        NSAutoreleasePool pool = NSAutoreleasePool.push();
        try {
            String user = null;
            String password = null;
            String path = null;
            log.debug((Object)("TXT Record:" + txtRecord));
            if (txtRecord.contains("u")) {
                user = txtRecord.getValueAsString("u");
            }
            if (txtRecord.contains("p")) {
                password = txtRecord.getValueAsString("p");
            }
            if (txtRecord.contains("path")) {
                path = txtRecord.getValueAsString("path");
            }
            this.add(fullname, hostname, port, user, password, path);
        }
        finally {
            resolver.stop();
            pool.drain();
        }
    }

    private static class Factory
    extends RendezvousFactory {
        private Factory() {
        }

        protected Rendezvous create() {
            return new RendezvousResponder();
        }
    }
}

