/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Archive;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.ConnectionListener;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.ErrorListener;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.LoginControllerFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.ProxyFactory;
import ch.cyberduck.core.ResolveCanceledException;
import ch.cyberduck.core.Resolver;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cloudfront.CloudFrontDistributionConfiguration;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundException;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import sun.security.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Session
implements TranscriptListener {
    private static Logger log = Logger.getLogger(Session.class);
    protected Host host;
    protected Path workdir;
    private final String ua = Preferences.instance().getProperty("application.name") + "/" + Preferences.instance().getProperty("application.version") + " (" + System.getProperty("os.name") + "/" + System.getProperty("os.version") + ")" + " (" + System.getProperty("os.arch") + ")";
    private boolean unsecurewarning = Preferences.instance().getBoolean("connection.unsecure.warning");
    private boolean opening;
    private Set<ConnectionListener> connectionListeners = Collections.synchronizedSet(new HashSet());
    private Set<TranscriptListener> transcriptListeners = Collections.synchronizedSet(new HashSet());
    private DistributionConfiguration cf;
    private Set<ProgressListener> progressListeners = Collections.synchronizedSet(new HashSet());
    private Set<ErrorListener> errorListeners = Collections.synchronizedSet(new HashSet());
    private Cache<Path> cache;

    protected Session(Host h) {
        this.host = h;
    }

    protected abstract <C> C getClient() throws ConnectionCanceledException;

    public String getUserAgent() {
        return this.ua;
    }

    public void check() throws IOException {
        try {
            try {
                if (!this.isConnected()) {
                    if (StringUtils.isBlank((String)this.host.getHostname())) {
                        if (StringUtils.isBlank((String)this.host.getProtocol().getDefaultHostname())) {
                            log.warn((Object)("No hostname configured:" + this.host));
                            throw new ConnectionCanceledException();
                        }
                        this.host.setHostname(this.host.getProtocol().getDefaultHostname());
                    }
                    this.connect();
                } else {
                    try {
                        this.noop();
                    }
                    catch (IOException e) {
                        this.interrupt();
                        this.connect();
                    }
                }
            }
            catch (SocketException e) {
                if (e.getMessage().equals("Software caused connection abort")) {
                    log.warn((Object)("Supressed socket exception:" + e.getMessage()));
                    throw new ConnectionCanceledException();
                }
                if (e.getMessage().equals("Socket closed")) {
                    log.warn((Object)("Supressed socket exception:" + e.getMessage()));
                    throw new ConnectionCanceledException();
                }
                throw e;
            }
            catch (SSLHandshakeException e) {
                log.error((Object)("SSL Handshake failed: " + e.getMessage()));
                if (e.getCause() instanceof ValidatorException) {
                    throw e;
                }
                throw new ConnectionCanceledException(e.getMessage());
            }
        }
        catch (IOException e) {
            this.interrupt();
            this.error("Connection failed", e);
            throw e;
        }
    }

    protected int timeout() {
        return (int)Preferences.instance().getDouble("connection.timeout.seconds") * 1000;
    }

    public boolean isSecure() {
        if (this.isConnected()) {
            return this.host.getProtocol().isSecure();
        }
        return false;
    }

    protected abstract void connect() throws IOException;

    protected void prompt(LoginController login) throws LoginCanceledException {
        String username = this.host.getCredentials().getUsername();
        login.check(this.host, Locale.localizedString("Login with username and password", "Credentials"), null);
        if (!StringUtils.equals((String)username, (String)this.host.getCredentials().getUsername()) && BookmarkCollection.defaultCollection().contains(this.host)) {
            BookmarkCollection.defaultCollection().collectionItemChanged(this.host);
        }
    }

    public boolean isUnsecurewarning() {
        return this.unsecurewarning;
    }

    public void setUnsecurewarning(boolean unsecurewarning) {
        this.unsecurewarning = unsecurewarning;
    }

    protected void login() throws IOException {
        this.login(LoginControllerFactory.instance(this));
    }

    protected void login(LoginController controller) throws IOException {
        this.prompt(controller);
        Credentials credentials = this.host.getCredentials();
        this.warn(controller, credentials);
        this.message(MessageFormat.format(Locale.localizedString("Authenticating as {0}", "Status"), credentials.getUsername()));
        this.login(controller, credentials);
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        controller.success(this.host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void warn(LoginController login, Credentials credentials) throws IOException {
        if (this.isUnsecurewarning() && !this.host.getProtocol().isSecure() && !credentials.isAnonymousLogin() && !Preferences.instance().getBoolean("connection.unsecure." + this.host.getHostname())) {
            try {
                login.warn(MessageFormat.format(Locale.localizedString("Unsecured {0} connection", "Credentials"), this.host.getProtocol().getName()), MessageFormat.format(Locale.localizedString("{0} will be sent in plaintext.", "Credentials"), credentials.getPasswordPlaceholder()), "connection.unsecure." + this.host.getHostname());
                Object var4_3 = null;
                this.setUnsecurewarning(false);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.setUnsecurewarning(false);
                throw throwable;
            }
        }
    }

    protected abstract void login(LoginController var1, Credentials var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path mount() {
        block7: {
            block6: {
                if (!StringUtils.isNotBlank((String)this.host.getWorkdir())) break block6;
                Path path = this.mount(this.host.getWorkdir());
                Object var3_5 = null;
                this.host.setWorkdir(null);
                return path;
            }
            if (!StringUtils.isNotBlank((String)this.host.getDefaultPath())) break block7;
            Path path = this.mount(this.host.getDefaultPath());
            Object var3_6 = null;
            this.host.setWorkdir(null);
            return path;
        }
        try {
            Path path = this.mount(null);
            Object var3_7 = null;
            this.host.setWorkdir(null);
            return path;
        }
        catch (IOException e) {
            try {
                this.interrupt();
                Object var3_8 = null;
                this.host.setWorkdir(null);
            }
            catch (Throwable throwable) {
                Object var3_9 = null;
                this.host.setWorkdir(null);
                throw throwable;
            }
        }
        return null;
    }

    protected Path mount(String directory) throws IOException {
        Path home;
        this.message(MessageFormat.format(Locale.localizedString("Mounting {0}", "Status"), this.host.getHostname()));
        this.check();
        if (!this.isConnected()) {
            return null;
        }
        if (directory != null) {
            home = directory.startsWith(String.valueOf('/')) || directory.equals(this.workdir().getName()) ? PathFactory.createPath(this, directory, directory.equals(String.valueOf('/')) ? 10 : 2) : (directory.startsWith("~") ? PathFactory.createPath(this, this.workdir().getAbsolute(), directory.substring(1), 2) : PathFactory.createPath(this, this.workdir().getAbsolute(), directory, 2));
            if (!home.children().attributes().isReadable()) {
                home = this.workdir();
            }
        } else {
            home = this.workdir();
        }
        return home;
    }

    public abstract void close();

    public Host getHost() {
        return this.host;
    }

    public String getEncoding() {
        if (null == this.host.getEncoding()) {
            return Preferences.instance().getProperty("browser.charset.encoding");
        }
        return this.host.getEncoding();
    }

    public int getMaxConnections() {
        if (null == this.host.getMaxConnections()) {
            return Preferences.instance().getInteger("connection.host.max");
        }
        return this.host.getMaxConnections();
    }

    public Path workdir() throws ConnectionCanceledException {
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        if (null == this.workdir) {
            this.workdir = PathFactory.createPath(this, String.valueOf('/'), 10);
        }
        return this.workdir;
    }

    public void setWorkdir(Path workdir) throws IOException {
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        this.workdir = workdir;
    }

    public boolean isCreateFolderSupported(Path workdir) {
        return true;
    }

    public boolean isCreateFileSupported(Path workdir) {
        return true;
    }

    public boolean isRenameSupported(Path file) {
        return true;
    }

    public boolean isAclSupported() {
        return false;
    }

    public boolean isUnixPermissionsSupported() {
        return true;
    }

    public boolean isTimestampSupported() {
        return true;
    }

    public boolean isChecksumSupported() {
        return false;
    }

    public boolean isRevertSupported() {
        return false;
    }

    protected void noop() throws IOException {
    }

    public void interrupt() {
        this.close();
    }

    public boolean isSendCommandSupported() {
        return false;
    }

    public void sendCommand(String command) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isArchiveSupported() {
        return false;
    }

    public void archive(Archive archive, List<Path> files) {
        try {
            this.check();
            this.sendCommand(archive.getCompressCommand(files));
            for (Path file : files) {
                file.getParent().invalidate();
            }
        }
        catch (IOException e) {
            this.error("Cannot create archive", e);
        }
    }

    public boolean isUnarchiveSupported() {
        return false;
    }

    public void unarchive(Archive archive, Path file) {
        try {
            this.check();
            this.sendCommand(archive.getDecompressCommand(file));
            file.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot expand archive", e);
        }
    }

    public boolean isConnected() {
        try {
            this.getClient();
        }
        catch (ConnectionCanceledException e) {
            return false;
        }
        return true;
    }

    public boolean isOpening() {
        return this.opening;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    protected void fireConnectionWillOpenEvent() throws ResolveCanceledException, UnknownHostException {
        ConnectionListener[] l;
        log.debug((Object)"connectionWillOpen");
        for (ConnectionListener listener : l = this.connectionListeners.toArray(new ConnectionListener[this.connectionListeners.size()])) {
            listener.connectionWillOpen();
        }
        this.opening = true;
        ProxyFactory.instance().configure(this.host);
        Resolver resolver = this.getResolver();
        this.message(MessageFormat.format(Locale.localizedString("Resolving {0}", "Status"), this.host.getHostname()));
        resolver.resolve();
        this.message(MessageFormat.format(Locale.localizedString("Opening {0} connection to {1}", "Status"), this.host.getProtocol().getName(), this.host.getHostname()));
    }

    protected Resolver getResolver() {
        return new Resolver(this.host.getHostname(true));
    }

    protected void fireConnectionDidOpenEvent() {
        log.debug((Object)"connectionDidOpen");
        this.host.setTimestamp(new Date());
        this.opening = false;
        HistoryCollection history = HistoryCollection.defaultCollection();
        history.add(new Host(this.host.getAsDictionary()));
        for (ConnectionListener listener : this.connectionListeners.toArray(new ConnectionListener[this.connectionListeners.size()])) {
            listener.connectionDidOpen();
        }
        this.message(MessageFormat.format(Locale.localizedString("{0} connection opened", "Status"), this.host.getProtocol().getName()));
    }

    protected void fireConnectionWillCloseEvent() {
        log.debug((Object)"connectionWillClose");
        this.message(MessageFormat.format(Locale.localizedString("Disconnecting {0}", "Status"), this.host.getHostname()));
        for (ConnectionListener listener : this.connectionListeners.toArray(new ConnectionListener[this.connectionListeners.size()])) {
            listener.connectionWillClose();
        }
    }

    protected void fireConnectionDidCloseEvent() {
        log.debug((Object)"connectionDidClose");
        this.workdir = null;
        this.cdn().clear();
        for (ConnectionListener listener : this.connectionListeners.toArray(new ConnectionListener[this.connectionListeners.size()])) {
            listener.connectionDidClose();
        }
        this.opening = false;
    }

    public void addTranscriptListener(TranscriptListener listener) {
        this.transcriptListeners.add(listener);
    }

    public void removeTranscriptListener(TranscriptListener listener) {
        this.transcriptListeners.remove(listener);
    }

    @Override
    public void log(boolean request, String message) {
        log.info((Object)message);
        for (TranscriptListener listener : this.transcriptListeners.toArray(new TranscriptListener[this.transcriptListeners.size()])) {
            listener.log(request, message);
        }
    }

    public boolean isDownloadResumable() {
        return true;
    }

    public boolean isUploadResumable() {
        return true;
    }

    public boolean isCreateSymlinkSupported() {
        return false;
    }

    public List<Acl.User> getAvailableAclUsers() {
        return Collections.emptyList();
    }

    public Acl getPrivateAcl(String container) {
        return Acl.EMPTY;
    }

    public Acl getPublicAcl(String container, boolean readable, boolean writable) {
        return Acl.EMPTY;
    }

    public boolean isMetadataSupported() {
        return false;
    }

    public boolean isCDNSupported() {
        return true;
    }

    protected Credentials getCdnCredentials() {
        return this.host.getCdnCredentials();
    }

    public DistributionConfiguration cdn() {
        if (null == this.cf) {
            this.cf = new CloudFrontDistributionConfiguration(LoginControllerFactory.instance(this), this.host.getCdnCredentials(), new ErrorListener(){

                public void error(BackgroundException exception) {
                    Session.this.error(exception);
                }
            }){

                @Override
                protected void fireConnectionDidOpenEvent() {
                    if (BookmarkCollection.defaultCollection().contains(Session.this.getHost())) {
                        BookmarkCollection.defaultCollection().collectionItemChanged(Session.this.getHost());
                    }
                    super.fireConnectionDidOpenEvent();
                }

                @Override
                public String toString() {
                    if (this.isCDNSupported()) {
                        return super.toString();
                    }
                    return Locale.localizedString("None");
                }

                @Override
                public List<Distribution.Method> getMethods() {
                    if (this.isCDNSupported()) {
                        return Arrays.asList(Distribution.CUSTOM);
                    }
                    return Collections.emptyList();
                }

                @Override
                public String getOrigin(Distribution.Method method, String container) {
                    if (Distribution.CUSTOM.equals(method)) {
                        try {
                            return new URI(Session.this.getHost().getWebURL()).getHost();
                        }
                        catch (URISyntaxException e) {
                            log.error((Object)("Failure parsing URI:" + e.getMessage()));
                        }
                    }
                    return super.getOrigin(method, container);
                }
            };
        }
        return this.cf;
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Collections.emptyList();
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public void message(String message) {
        log.info((Object)message);
        for (ProgressListener listener : this.progressListeners.toArray(new ProgressListener[this.progressListeners.size()])) {
            listener.message(message);
        }
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners.add(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners.remove(listener);
    }

    protected void error(String message, Throwable e) {
        this.error(this.workdir, message, e);
    }

    protected void error(Path path, String message, Throwable e) {
        this.error(new BackgroundException(this, path, message, e));
    }

    protected void error(BackgroundException failure) {
        this.message(failure.getMessage());
        for (ErrorListener listener : this.errorListeners.toArray(new ErrorListener[this.errorListeners.size()])) {
            listener.error(failure);
        }
    }

    public Cache<Path> cache() {
        if (null == this.cache) {
            this.cache = new Cache<Path>(){

                public String toString() {
                    return "Cache for " + Session.this.toString();
                }
            };
        }
        return this.cache;
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof Session) {
            return this.host.getHostname().equals(((Session)other).getHost().getHostname()) && this.host.getProtocol().equals(((Session)other).getHost().getProtocol());
        }
        return super.equals(other);
    }

    public String toString() {
        return "Session " + this.host.toURL();
    }
}

