/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.i18n.Locale;
import java.text.MessageFormat;

public class Speedometer {
    private long timestamp;
    private double initialBytesTransferred;
    private double bytesTransferred;
    private Transfer transfer;

    public Speedometer(Transfer transfer) {
        this.transfer = transfer;
        this.reset();
    }

    public float getSpeed() {
        this.bytesTransferred = this.transfer.getTransferred();
        if (this.bytesTransferred > this.initialBytesTransferred) {
            if (0.0 == this.initialBytesTransferred) {
                this.initialBytesTransferred = this.bytesTransferred;
                return -1.0f;
            }
            double elapsedSeconds = (System.currentTimeMillis() - this.timestamp) / 1000L;
            if (elapsedSeconds > 1.0) {
                double bytes = this.bytesTransferred - this.initialBytesTransferred;
                if (Preferences.instance().getBoolean("queue.transferspeed.bits")) {
                    double bits = bytes * 8.0;
                    return (float)(bits / elapsedSeconds);
                }
                return (float)(bytes / elapsedSeconds);
            }
        }
        return -1.0f;
    }

    public String getProgress() {
        StringBuilder b = new StringBuilder();
        double size = this.transfer.getSize();
        double transferred = this.transfer.getTransferred();
        b.append(MessageFormat.format(Locale.localizedString("{0} of {1}"), Status.getSizeAsString(transferred, size != transferred), Status.getSizeAsString(size)));
        float speed = this.getSpeed();
        if (this.transfer.isRunning() && (size > -1.0 || speed > 0.0f)) {
            b.append(" (");
            if (size > -1.0) {
                if (0.0 == size) {
                    b.append(0);
                } else {
                    b.append((int)(transferred / size * 100.0));
                }
                b.append("%");
            }
            if (speed > 0.0f) {
                if (size > -1.0) {
                    b.append(", ");
                }
                b.append(Status.getSpeedAsString(speed));
                b.append("/sec");
                double t = this.getBytesTransfered();
                if (size > 0.0 && t < size) {
                    b.append(", ");
                    double remaining = (size - t) / (double)speed;
                    b.append(Status.getRemainingAsString(remaining));
                }
            }
            b.append(")");
        }
        return b.toString();
    }

    public double getBytesTransfered() {
        return this.bytesTransferred;
    }

    public void reset() {
        this.timestamp = System.currentTimeMillis();
        this.initialBytesTransferred = this.transfer.getTransferred();
        this.bytesTransferred = 0.0;
    }
}

