/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.ftp.FTPPath;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.ui.growl.Growl;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TimeZone;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncTransfer
extends Transfer {
    private static Logger log = Logger.getLogger(SyncTransfer.class);
    private Transfer _delegateUpload;
    private Transfer _delegateDownload;
    private TransferAction action = TransferAction.forName(Preferences.instance().getProperty("queue.sync.action.default"));
    public static final TransferAction ACTION_DOWNLOAD = new TransferAction(){

        public String toString() {
            return "download";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Download");
        }
    };
    public static final TransferAction ACTION_UPLOAD = new TransferAction(){

        public String toString() {
            return "upload";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Upload");
        }
    };
    public static final TransferAction ACTION_MIRROR = new TransferAction(){

        public String toString() {
            return "mirror";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Mirror");
        }
    };
    private Transfer.TransferFilter ACTION_OVERWRITE = new Transfer.TransferFilter(){
        private Transfer.TransferFilter _delegateFilterDownload;
        private Transfer.TransferFilter _delegateFilterUpload;
        {
            this._delegateFilterDownload = SyncTransfer.this._delegateDownload.filter(TransferAction.ACTION_OVERWRITE);
            this._delegateFilterUpload = SyncTransfer.this._delegateUpload.filter(TransferAction.ACTION_OVERWRITE);
        }

        public void prepare(Path p) {
            Comparison compare = SyncTransfer.this.compare(p);
            if (compare.equals(COMPARISON_REMOTE_NEWER)) {
                this._delegateFilterDownload.prepare(p);
            } else if (compare.equals(COMPARISON_LOCAL_NEWER)) {
                this._delegateFilterUpload.prepare(p);
            }
        }

        public boolean accept(Path p) {
            Comparison compare = SyncTransfer.this.compare(p);
            if (!COMPARISON_EQUAL.equals(compare)) {
                if (compare.equals(COMPARISON_REMOTE_NEWER)) {
                    return this._delegateFilterDownload.accept(p);
                }
                if (compare.equals(COMPARISON_LOCAL_NEWER)) {
                    return this._delegateFilterUpload.accept(p);
                }
            }
            return false;
        }

        public void complete(Path p) {
        }
    };
    private final Cache<Path> cache = new Cache<Path>(){

        @Override
        public AttributedList<Path> remove(PathReference reference) {
            SyncTransfer.this._delegateDownload.cache().remove(reference);
            SyncTransfer.this._delegateUpload.cache().remove(reference);
            return super.remove(reference);
        }

        @Override
        public void clear() {
            SyncTransfer.this._delegateDownload.cache().clear();
            SyncTransfer.this._delegateUpload.cache().clear();
            super.clear();
        }

        @Override
        public boolean containsKey(PathReference reference) {
            return SyncTransfer.this._delegateDownload.cache().containsKey(reference) || SyncTransfer.this._delegateUpload.cache().containsKey(reference);
        }

        @Override
        public AttributedList<Path> get(PathReference reference, Comparator<Path> c, PathFilter<Path> f) {
            HashSet<Path> children = new HashSet<Path>();
            if (SyncTransfer.this._delegateDownload.cache().containsKey(reference)) {
                children.addAll(SyncTransfer.this._delegateDownload.cache().get(reference, c, f));
            }
            if (SyncTransfer.this._delegateUpload.cache().containsKey(reference)) {
                children.addAll(SyncTransfer.this._delegateUpload.cache().get(reference, c, f));
            }
            return new AttributedList<Path>((Collection<Path>)children);
        }

        @Override
        public Path lookup(PathReference reference) {
            Path path = SyncTransfer.this._delegateUpload.cache().lookup(reference);
            if (null == path) {
                path = SyncTransfer.this._delegateDownload.cache().lookup(reference);
            }
            if (null == path) {
                log.warn((Object)("Lookup failed for " + reference + " in cache"));
            }
            return path;
        }
    };
    public static final Comparison COMPARISON_REMOTE_NEWER = new Comparison(){

        public String toString() {
            return "COMPARISON_REMOTE_NEWER";
        }
    };
    public static final Comparison COMPARISON_LOCAL_NEWER = new Comparison(){

        public String toString() {
            return "COMPARISON_LOCAL_NEWER";
        }
    };
    public static final Comparison COMPARISON_EQUAL = new Comparison(){

        public String toString() {
            return "COMPARISON_EQUAL";
        }
    };
    private static final Comparison COMPARISON_UNEQUAL = new Comparison(){

        public String toString() {
            return "COMPARISON_UNEQUAL";
        }
    };

    public SyncTransfer(Path root) {
        super(root);
    }

    public <T> SyncTransfer(T dict, Session s) {
        super(dict, s);
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = super.getSerializer();
        dict.setStringForKey(String.valueOf(2), "Kind");
        return dict.getSerialized();
    }

    @Override
    protected void init() {
        log.debug((Object)"init");
        this._delegateUpload = new UploadTransfer(this.getRoots());
        this._delegateDownload = new DownloadTransfer(this.getRoots());
    }

    @Override
    protected void normalize() {
        log.debug((Object)"normalize");
        this._delegateUpload.normalize();
        this._delegateDownload.normalize();
    }

    @Override
    public void setBandwidth(float bytesPerSecond) {
        this._delegateUpload.setBandwidth(bytesPerSecond);
        this._delegateDownload.setBandwidth(bytesPerSecond);
    }

    @Override
    public float getBandwidth() {
        return -1.0f;
    }

    @Override
    public String getName() {
        return this.getRoot().getName() + " \u2194 " + this.getRoot().getLocal().getName();
    }

    @Override
    public double getSize() {
        double size = this._delegateDownload.getSize() + this._delegateUpload.getSize();
        if (0.0 == size) {
            return super.getSize();
        }
        return size;
    }

    @Override
    public boolean isResumable() {
        return this._delegateDownload.isResumable() && this._delegateUpload.isResumable();
    }

    @Override
    public double getTransferred() {
        double transferred = this._delegateDownload.getTransferred() + this._delegateUpload.getTransferred();
        if (0.0 == transferred) {
            return super.getTransferred();
        }
        return transferred;
    }

    public void setTransferAction(TransferAction action) {
        this.action = action;
    }

    public TransferAction getAction() {
        return this.action;
    }

    @Override
    public Transfer.TransferFilter filter(TransferAction action) {
        log.debug((Object)("filter:" + action));
        if (action.equals(TransferAction.ACTION_OVERWRITE)) {
            return this.ACTION_OVERWRITE;
        }
        if (action.equals(TransferAction.ACTION_CALLBACK)) {
            TransferAction result = this.prompt.prompt();
            return this.filter(result);
        }
        return super.filter(action);
    }

    @Override
    public AttributedList<Path> children(Path parent) {
        log.debug((Object)("children:" + parent));
        HashSet<Path> children = new HashSet<Path>();
        if (parent.exists()) {
            children.addAll(this._delegateDownload.children(parent));
        }
        if (parent.getLocal().exists()) {
            children.addAll(this._delegateUpload.children(parent));
        }
        for (Path child : children) {
            if (!child.getSession().isTimestampSupported() || !(child instanceof FTPPath)) continue;
            child.readTimestamp();
        }
        return new AttributedList<Path>((Collection<Path>)children);
    }

    @Override
    public boolean isSkipped(Path path) {
        boolean skipped = false;
        Comparison comparison = this.compare(path);
        if (COMPARISON_EQUAL.equals(comparison)) {
            skipped = path.attributes().isFile();
        } else if (path.attributes().isFile()) {
            if (comparison.equals(COMPARISON_REMOTE_NEWER)) {
                skipped = this.getAction().equals(ACTION_UPLOAD);
            } else if (comparison.equals(COMPARISON_LOCAL_NEWER)) {
                skipped = this.getAction().equals(ACTION_DOWNLOAD);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isSkipped:" + skipped + "," + path));
        }
        return skipped;
    }

    @Override
    public Cache<Path> cache() {
        return this.cache;
    }

    @Override
    public TransferAction action(boolean resumeRequested, boolean reloadRequested) {
        log.debug((Object)("action:" + resumeRequested + "," + reloadRequested));
        return TransferAction.ACTION_CALLBACK;
    }

    @Override
    protected void transfer(Path file) {
        log.debug((Object)("transfer:" + file));
        Comparison compare = this.compare(file);
        if (compare.equals(COMPARISON_REMOTE_NEWER)) {
            this._delegateDownload.transfer(file);
        } else if (compare.equals(COMPARISON_LOCAL_NEWER)) {
            this._delegateUpload.transfer(file);
        }
    }

    @Override
    protected void fireTransferDidEnd() {
        if (this.isReset() && this.isComplete() && !this.isCanceled()) {
            Growl.instance().notify("Synchronization complete", this.getName());
        }
        super.fireTransferDidEnd();
    }

    @Override
    protected void clear(TransferOptions options) {
        this._delegateDownload.clear(options);
        this._delegateUpload.clear(options);
        super.clear(options);
    }

    @Override
    protected void reset() {
        this._delegateDownload.reset();
        this._delegateUpload.reset();
        super.reset();
    }

    public Comparison compare(Path p) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("compare:" + p));
        }
        if (p.getLocal().exists() && p.exists()) {
            Comparison comparison;
            if (Preferences.instance().getBoolean("queue.sync.compare.hash") && !COMPARISON_UNEQUAL.equals(comparison = this.compareHash(p))) {
                return comparison;
            }
            if (Preferences.instance().getBoolean("queue.sync.compare.size") && !COMPARISON_UNEQUAL.equals(comparison = this.compareSize(p))) {
                return comparison;
            }
            comparison = this.compareTimestamp(p);
            if (!COMPARISON_UNEQUAL.equals(comparison)) {
                return comparison;
            }
        } else {
            if (p.exists()) {
                return COMPARISON_REMOTE_NEWER;
            }
            if (p.getLocal().exists()) {
                return COMPARISON_LOCAL_NEWER;
            }
        }
        return COMPARISON_EQUAL;
    }

    private Comparison compareSize(Path p) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("compareSize:" + p));
        }
        if (p.attributes().isFile()) {
            if (p.attributes().getSize() == -1L) {
                p.readSize();
            }
            if (p.attributes().getSize() == 0L && p.getLocal().attributes().getSize() == 0L) {
                return COMPARISON_EQUAL;
            }
            if (p.attributes().getSize() == 0L) {
                return COMPARISON_LOCAL_NEWER;
            }
            if (p.getLocal().attributes().getSize() == 0L) {
                return COMPARISON_REMOTE_NEWER;
            }
            if (p.attributes().getSize() == p.getLocal().attributes().getSize()) {
                return COMPARISON_EQUAL;
            }
        }
        return COMPARISON_UNEQUAL;
    }

    private Comparison compareHash(Path p) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("compareHash:" + p));
        }
        if (p.attributes().isFile()) {
            if (null == p.attributes().getChecksum() && p.getSession().isChecksumSupported()) {
                p.readChecksum();
            }
            if (null == p.attributes().getChecksum()) {
                log.warn((Object)("No checksum available for comparison:" + p));
                return COMPARISON_UNEQUAL;
            }
            if (p.attributes().getChecksum().equals(p.getLocal().attributes().getChecksum())) {
                return COMPARISON_EQUAL;
            }
        }
        return COMPARISON_UNEQUAL;
    }

    private Comparison compareTimestamp(Path p) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("compareTimestamp:" + p));
        }
        if (-1L == p.attributes().getModificationDate() && p.getSession().isTimestampSupported()) {
            p.readTimestamp();
        }
        if (-1L == p.attributes().getModificationDate()) {
            log.warn((Object)("No modification date available for comparison:" + p));
            return COMPARISON_UNEQUAL;
        }
        Calendar remote = this.asCalendar(p.attributes().getModificationDate(), 13);
        Calendar local = this.asCalendar(p.getLocal().attributes().getModificationDate(), 13);
        if (local.before(remote)) {
            return COMPARISON_REMOTE_NEWER;
        }
        if (local.after(remote)) {
            return COMPARISON_LOCAL_NEWER;
        }
        return COMPARISON_EQUAL;
    }

    private Calendar asCalendar(long timestamp, int precision) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("asCalendar:" + timestamp));
        }
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.setTimeInMillis(timestamp);
        if (precision == 14) {
            return c;
        }
        c.clear(14);
        if (precision == 13) {
            return c;
        }
        c.clear(13);
        if (precision == 12) {
            return c;
        }
        c.clear(12);
        if (precision == 10) {
            return c;
        }
        c.clear(10);
        return c;
    }

    public static class Comparison {
        public boolean equals(Object other) {
            return super.equals(other);
        }
    }
}

