/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Native;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Reachability;
import ch.cyberduck.core.ReachabilityFactory;

public class SystemConfigurationReachability
implements Reachability {
    private static boolean JNI_LOADED = false;

    public static void register() {
        ReachabilityFactory.addFactory(Factory.NATIVE_PLATFORM, new Factory());
    }

    private SystemConfigurationReachability() {
    }

    private static boolean loadNative() {
        if (!JNI_LOADED) {
            JNI_LOADED = Native.load("Diagnostics");
        }
        return JNI_LOADED;
    }

    public boolean isReachable(Host host) {
        if (!Preferences.instance().getBoolean("connection.hostname.check")) {
            return true;
        }
        if (!SystemConfigurationReachability.loadNative()) {
            return false;
        }
        return this.isReachable(this.toURL(host));
    }

    private String toURL(Host host) {
        StringBuilder url = new StringBuilder(host.getProtocol().getScheme());
        url.append("://");
        url.append(host.getHostname(true));
        url.append(":").append(host.getPort());
        return url.toString();
    }

    private native boolean isReachable(String var1);

    public void diagnose(Host host) {
        if (!SystemConfigurationReachability.loadNative()) {
            return;
        }
        this.diagnose(host.toURL());
    }

    private native void diagnose(String var1);

    private static class Factory
    extends ReachabilityFactory {
        private Factory() {
        }

        protected Reachability create() {
            return new SystemConfigurationReachability();
        }
    }
}

