/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Queue;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferListener;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.DeserializerFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.serializer.SerializerFactory;
import ch.cyberduck.ui.growl.Growl;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transfer
implements Serializable {
    private static Logger log = Logger.getLogger(Transfer.class);
    protected List<Path> roots;
    protected double size = 0.0;
    protected double transferred = 0.0;
    private boolean canceled;
    public static final int KIND_DOWNLOAD = 0;
    public static final int KIND_UPLOAD = 1;
    public static final int KIND_SYNC = 2;
    private boolean running;
    private boolean queued;
    private Session session;
    private boolean reset;
    private Date timestamp;
    private Set<TransferListener> listeners = Collections.synchronizedSet(new HashSet());
    protected BandwidthThrottle bandwidth;
    private Path _current = null;
    protected TransferPrompt prompt;

    protected Transfer() {
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public abstract boolean isResumable();

    public Transfer(Path root) {
        this(new Collection<Path>((java.util.Collection<Path>)Collections.singletonList(root)));
    }

    public Transfer(List<Path> items) {
        this.roots = items;
        this.session = this.getRoot().getSession();
        this.init();
    }

    protected abstract void init();

    public <T> Transfer(T dict, Session s) {
        this.session = s;
        this.init(dict);
    }

    @Override
    public <T> void init(T serialized) {
        String currentObj;
        String timestampObj;
        String sizeObj;
        Deserializer dict = DeserializerFactory.createDeserializer(serialized);
        List rootsObj = dict.listForKey("Roots");
        if (rootsObj != null) {
            this.roots = new Collection<Path>();
            for (Object rootDict : rootsObj) {
                this.roots.add(PathFactory.createPath(this.session, rootDict));
            }
        }
        if ((sizeObj = dict.stringForKey("Size")) != null) {
            this.size = Double.parseDouble(sizeObj.toString());
        }
        if ((timestampObj = dict.stringForKey("Timestamp")) != null) {
            this.timestamp = new Date(Long.parseLong(timestampObj.toString()));
        }
        if ((currentObj = dict.stringForKey("Current")) != null) {
            this.transferred = Double.parseDouble(currentObj.toString());
        }
        this.init();
        String bandwidthObj = dict.stringForKey("Bandwidth");
        if (bandwidthObj != null) {
            this.bandwidth.setRate(Float.parseFloat(bandwidthObj.toString()));
        }
    }

    @Override
    public abstract <T> T getAsDictionary();

    public Serializer getSerializer() {
        Serializer dict = SerializerFactory.createSerializer();
        dict.setObjectForKey(this.getSession().getHost(), "Host");
        dict.setListForKey(this.roots, "Roots");
        dict.setStringForKey(String.valueOf(this.getSize()), "Size");
        dict.setStringForKey(String.valueOf(this.getTransferred()), "Current");
        if (this.timestamp != null) {
            dict.setStringForKey(String.valueOf(this.timestamp.getTime()), "Timestamp");
        }
        if (this.bandwidth != null) {
            dict.setStringForKey(String.valueOf(this.bandwidth.getRate()), "Bandwidth");
        }
        return dict;
    }

    public void addListener(TransferListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TransferListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireTransferWillStart() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fireTransferWillStart:" + this));
        }
        this.canceled = false;
        this.running = true;
        this.queued = false;
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.transferWillStart();
        }
    }

    public void fireTransferQueued() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fireTransferQueued:" + this));
        }
        Session session = this.getSession();
        Growl.instance().notify("Transfer queued", session.getHost().getHostname());
        session.message(Locale.localizedString("Maximum allowed connections exceeded. Waiting", "Status"));
        this.queued = true;
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.transferQueued();
        }
    }

    public void fireTransferResumed() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fireTransferResumed:" + this));
        }
        this.queued = false;
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.transferResumed();
        }
    }

    protected void fireTransferDidEnd() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fireTransferDidEnd:" + this));
        }
        this.running = false;
        this.queued = false;
        this.timestamp = new Date();
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.transferDidEnd();
        }
        Queue.instance().remove(this);
    }

    protected void fireWillTransferPath(Path path) {
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.willTransferPath(path);
        }
    }

    protected void fireDidTransferPath(Path path) {
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.didTransferPath(path);
        }
    }

    public void setBandwidth(float bytesPerSecond) {
        log.debug((Object)("setBandwidth:" + bytesPerSecond));
        this.bandwidth.setRate(bytesPerSecond);
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.bandwidthChanged(this.bandwidth);
        }
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public float getBandwidth() {
        return this.bandwidth.getRate();
    }

    public Path getRoot() {
        return this.roots.get(0);
    }

    public List<Path> getRoots() {
        return this.roots;
    }

    public void setRoots(List<Path> roots) {
        this.roots = roots;
    }

    protected abstract void normalize();

    public Session getSession() {
        return this.session;
    }

    public String getName() {
        String name = "";
        for (Path next : this.roots) {
            name = name + next.getLocal().getName() + " ";
        }
        return name;
    }

    public TransferFilter filter(TransferAction action) {
        if (action.equals(TransferAction.ACTION_CANCEL)) {
            return null;
        }
        throw new IllegalArgumentException("Unknown transfer action:" + action);
    }

    public abstract TransferAction action(boolean var1, boolean var2);

    public Path lookup(PathReference r) {
        for (Path root : this.roots) {
            if (!r.equals(root.getReference())) continue;
            return root;
        }
        return this.cache().lookup(r);
    }

    public abstract AttributedList<Path> children(Path var1);

    public boolean isIncluded(Path item) {
        return item.status().isSelected() && !this.isSkipped(item);
    }

    public boolean isSkipped(Path item) {
        return false;
    }

    public void setSelected(Path item, boolean selected) {
        item.status().setSelected(selected);
        if (item.attributes().isDirectory() && item.isCached()) {
            for (Path child : this.children(item)) {
                this.setSelected(child, selected);
            }
        }
    }

    private void transfer(Path p, TransferFilter filter) {
        if (!this.isIncluded(p)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Not included in transfer:" + p));
            }
            p.status().setComplete(true);
            return;
        }
        if (!this.check()) {
            return;
        }
        if (filter.accept(p)) {
            this.fireWillTransferPath(p);
            this._current = p;
            p.status().reset();
            this.transfer(p);
            filter.complete(p);
            this._current = null;
            this.fireDidTransferPath(p);
        }
        if (!this.check()) {
            return;
        }
        if (p.attributes().isDirectory()) {
            p.status().reset();
            boolean failure = false;
            AttributedList<Path> children = this.children(p);
            if (!children.attributes().isReadable()) {
                failure = true;
            }
            for (Path child : children) {
                this.transfer(child, filter);
                if (child.status().isComplete()) continue;
                failure = true;
            }
            if (!failure) {
                p.status().setComplete(true);
            }
            this.cache().remove(p.getReference());
        }
    }

    protected abstract void transfer(Path var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(TransferOptions options) {
        Session session = this.getSession();
        try {
            try {
                log.debug((Object)"Checking connnection");
                session.check();
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage());
                this.clear(options);
                if (options.closeSession) {
                    session.close();
                }
                return;
            }
            if (!this.check()) {
                return;
            }
            TransferAction action = this.action(options.resumeRequested, options.reloadRequested);
            if (action.equals(TransferAction.ACTION_CANCEL)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Transfer canceled by user:" + this));
                }
                this.cancel();
                return;
            }
            this.clear(options);
            this.normalize();
            if (!this.check()) {
                return;
            }
            TransferFilter filter = this.filter(action);
            if (null == filter) {
                this.cancel();
                return;
            }
            this.reset();
            for (Path next : this.roots) {
                this.prepare(next, filter);
            }
            for (Path next : this.roots) {
                this.transfer(next, filter);
            }
        }
        finally {
            this.clear(options);
            if (options.closeSession) {
                session.close();
            }
        }
    }

    private void prepare(Path p, TransferFilter filter) {
        log.debug((Object)("prepare:" + p));
        if (!this.check()) {
            return;
        }
        if (!this.isIncluded(p)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Not included in transfer:" + p));
            }
            return;
        }
        if (filter.accept(p)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Accepted in transfer:" + p));
            }
            this.getSession().message(MessageFormat.format(Locale.localizedString("Prepare {0}", "Status"), p.getName()));
            filter.prepare(p);
        }
        if (p.attributes().isDirectory()) {
            for (Path child : this.children(p)) {
                this.prepare(child, filter);
            }
        }
    }

    protected boolean check() {
        boolean connected;
        if (log.isDebugEnabled()) {
            log.debug((Object)("check:" + this));
        }
        if (!(connected = this.getSession().isConnected())) {
            log.warn((Object)("Disconnected transfer in progress:" + this));
            return false;
        }
        boolean canceled = this.isCanceled();
        if (canceled) {
            log.warn((Object)("Canceled transfer in progress:" + this));
        }
        return !canceled;
    }

    protected void clear(TransferOptions options) {
        log.debug((Object)("clear:" + options));
        if (options.closeSession) {
            this.cache().clear();
        }
    }

    public Cache<Path> cache() {
        return this.getSession().cache();
    }

    public void start(TransferPrompt prompt) {
        this.start(prompt, TransferOptions.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(TransferPrompt prompt, TransferOptions options) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start:" + prompt));
        }
        this.prompt = prompt;
        try {
            this.fireTransferWillStart();
            this.queue();
            if (this.isCanceled()) {
                return;
            }
            this.transfer(options);
        }
        finally {
            this.prompt = null;
            this.fireTransferDidEnd();
        }
    }

    private synchronized void queue() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("queue:" + this));
        }
        Queue.instance().add(this);
    }

    public void interrupt() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("interrupt:" + this));
        }
        this.getSession().interrupt();
    }

    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cancel:" + this));
        }
        if (this._current != null) {
            this._current.status().setCanceled();
        }
        if (this.isCanceled()) {
            this.interrupt();
        }
        this.canceled = true;
        Queue.instance().remove(this);
    }

    protected void reset() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("reset:" + this));
        }
        this.transferred = 0.0;
        this.size = 0.0;
        this.reset = true;
    }

    public boolean isReset() {
        return this.reset;
    }

    public int numberOfRoots() {
        return this.roots.size();
    }

    public boolean isComplete() {
        for (Path root : this.roots) {
            if (root.status().isComplete()) continue;
            return false;
        }
        return true;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public double getTransferred() {
        return this.transferred;
    }

    public void setTransferred(double transferred) {
        this.transferred = transferred;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class TransferFilter
    implements PathFilter<Path> {
        protected TransferFilter() {
        }

        public abstract void prepare(Path var1);

        public abstract void complete(Path var1);
    }
}

