/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.i18n.Locale;
import java.util.HashMap;
import java.util.Map;

public abstract class TransferAction {
    protected static Map<String, TransferAction> actions = new HashMap<String, TransferAction>();
    public static final TransferAction ACTION_OVERWRITE = new TransferAction(){

        public String toString() {
            return "overwrite";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Overwrite");
        }
    };
    public static final TransferAction ACTION_RESUME = new TransferAction(){

        public String toString() {
            return "resume";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Resume");
        }
    };
    public static final TransferAction ACTION_RENAME = new TransferAction(){

        public String toString() {
            return "similar";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Rename");
        }
    };
    public static final TransferAction ACTION_RENAME_EXISTING = new TransferAction(){

        public String toString() {
            return "rename";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Rename existing");
        }
    };
    public static final TransferAction ACTION_SKIP = new TransferAction(){

        public String toString() {
            return "skip";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Skip");
        }
    };
    public static final TransferAction ACTION_CALLBACK = new TransferAction(){

        public String toString() {
            return "ask";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Prompt");
        }
    };
    public static final TransferAction ACTION_CANCEL = new TransferAction(){

        public String toString() {
            return "cancel";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Cancel");
        }
    };

    public TransferAction() {
        actions.put(this.toString(), this);
    }

    public abstract String toString();

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public abstract String getLocalizableString();

    public static TransferAction forName(String name) {
        return actions.get(name);
    }
}

