/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AbstractStreamListener;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.ui.DateFormatterFactory;
import ch.cyberduck.ui.growl.Growl;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadTransfer
extends Transfer {
    private static Logger log = Logger.getLogger(UploadTransfer.class);
    private final PathFilter<Local> exclusionRegexFilter = new PathFilter<Local>(){

        @Override
        public boolean accept(Local child) {
            try {
                if (Preferences.instance().getBoolean("queue.upload.skip.enable") && Pattern.compile(Preferences.instance().getProperty("queue.upload.skip.regex")).matcher(child.getName()).matches()) {
                    return false;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn((Object)e.getMessage());
            }
            return true;
        }
    };
    private final Cache<Path> cache = new Cache<Path>(){

        @Override
        public void clear() {
            super.clear();
            UploadTransfer.this.getSession().cache().clear();
        }
    };
    private final Transfer.TransferFilter OVERWRITE_FILTER = new UploadTransferFilter(){

        public boolean accept(Path file) {
            if (file.attributes().isDirectory() && file.exists()) {
                return false;
            }
            return super.accept(file);
        }

        public void prepare(Path file) {
            if (file.attributes().isFile()) {
                file.status().setResume(false);
            }
            super.prepare(file);
        }
    };
    private final Transfer.TransferFilter RESUME_FILTER = new UploadTransferFilter(){

        public boolean accept(Path file) {
            if (file.attributes().isDirectory() && file.exists()) {
                return false;
            }
            if (file.status().isComplete() || file.getLocal().attributes().getSize() == file.attributes().getSize()) {
                file.status().setComplete(true);
                return false;
            }
            return super.accept(file);
        }

        public void prepare(Path file) {
            if (file.exists() && file.attributes().getSize() == -1L) {
                file.readSize();
            }
            if (file.attributes().isFile()) {
                boolean resume = file.isUploadResumable();
                file.status().setResume(resume);
                if (resume) {
                    file.status().setCurrent(file.attributes().getSize());
                }
            }
            super.prepare(file);
        }
    };
    private final Transfer.TransferFilter RENAME_FILTER = new UploadTransferFilter(){

        public boolean accept(Path p) {
            return super.accept(p);
        }

        public void prepare(Path file) {
            if (file.exists()) {
                String parent = file.getParent().getAbsolute();
                String filename = file.getName();
                int no = 0;
                while (file.exists()) {
                    String proposal = FilenameUtils.getBaseName((String)filename) + "-" + ++no;
                    if (StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)filename))) {
                        proposal = proposal + "." + FilenameUtils.getExtension((String)filename);
                    }
                    file.setPath(parent, proposal);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Changed local name to:" + file.getName()));
                }
            }
            if (file.attributes().isFile()) {
                file.status().setResume(false);
            }
            super.prepare(file);
        }
    };
    private final Transfer.TransferFilter RENAME_EXISTING_FILTER = new UploadTransferFilter(){

        public boolean accept(Path p) {
            if (p.getSession().isRenameSupported(p)) {
                return super.accept(p);
            }
            return false;
        }

        public void prepare(Path file) {
            Path renamed = file;
            while (renamed.exists()) {
                String proposal = MessageFormat.format(Preferences.instance().getProperty("queue.upload.file.rename.format"), FilenameUtils.getBaseName((String)file.getName()), DateFormatterFactory.instance().getLongFormat(System.currentTimeMillis(), false).replace('/', ':'), StringUtils.isNotEmpty((String)file.getExtension()) ? "." + file.getExtension() : "");
                renamed = PathFactory.createPath(file.getSession(), renamed.getParent().getAbsolute(), proposal, file.attributes().getType());
            }
            if (!renamed.equals(file)) {
                file.rename(renamed);
            }
            if (file.attributes().isFile()) {
                file.status().setResume(false);
            }
            super.prepare(file);
        }
    };
    private final Transfer.TransferFilter SKIP_FILTER = new UploadTransferFilter(){

        public boolean accept(Path file) {
            if (file.exists()) {
                file.status().setComplete(true);
                return false;
            }
            return super.accept(file);
        }
    };

    public UploadTransfer(Path root) {
        super(root);
    }

    public UploadTransfer(List<Path> roots) {
        super(roots);
    }

    public <T> UploadTransfer(T dict, Session s) {
        super(dict, s);
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = super.getSerializer();
        dict.setStringForKey(String.valueOf(1), "Kind");
        return dict.getSerialized();
    }

    @Override
    protected void init() {
        log.debug((Object)"init");
        this.bandwidth = new BandwidthThrottle(Preferences.instance().getFloat("queue.upload.bandwidth.bytes"));
    }

    @Override
    protected void normalize() {
        log.debug((Object)"normalize");
        Collection<Path> normalized = new Collection<Path>();
        for (Path upload : this.getRoots()) {
            if (!this.check()) {
                return;
            }
            this.getSession().message(MessageFormat.format(Locale.localizedString("Prepare {0}", "Status"), upload.getName()));
            boolean duplicate = false;
            Iterator iter = normalized.iterator();
            while (iter.hasNext()) {
                Path n = (Path)iter.next();
                if (upload.getLocal().isChild(n.getLocal())) {
                    duplicate = true;
                    break;
                }
                if (n.getLocal().isChild(upload.getLocal())) {
                    iter.remove();
                }
                if (!upload.equals(n)) continue;
                String parent = upload.getParent().getAbsolute();
                String filename = upload.getName();
                int no = 0;
                int index = filename.lastIndexOf(".");
                String proposal = index != -1 && index != 0 ? filename.substring(0, index) + "-" + no + filename.substring(index) : filename + "-" + ++no;
                upload.setPath(parent, proposal);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Changed name to:" + upload.getName()));
            }
            if (duplicate) continue;
            normalized.add(upload);
        }
        this.setRoots(normalized);
    }

    @Override
    public Cache<Path> cache() {
        return this.cache;
    }

    @Override
    public AttributedList<Path> children(Path parent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("children:" + parent));
        }
        if (parent.getLocal().attributes().isSymbolicLink() && this.isSymlinkSupported(parent)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Do not list children for symbolic link:" + parent));
            }
            this.cache().put(parent.getReference(), AttributedList.emptyList());
        } else if (!this.cache().containsKey(parent.getReference())) {
            if (!parent.getLocal().exists()) {
                this.cache().put(parent.getReference(), AttributedList.emptyList());
            } else {
                AttributedList<Path> children = new AttributedList<Path>();
                for (Local child : parent.getLocal().children(this.exclusionRegexFilter)) {
                    Local local = LocalFactory.createLocal(((AbstractPath)child).getAbsolute());
                    Path upload = PathFactory.createPath(this.getSession(), parent.getAbsolute(), local);
                    if (upload.exists()) {
                        upload = this.getSession().cache().lookup(upload.getReference());
                        upload.setLocal(local);
                    }
                    children.add(upload);
                }
                this.cache().put(parent.getReference(), children);
            }
        }
        return this.cache().get(parent.getReference());
    }

    @Override
    public boolean isResumable() {
        return this.getSession().isUploadResumable();
    }

    @Override
    public Transfer.TransferFilter filter(TransferAction action) {
        log.debug((Object)("filter:" + action));
        if (action.equals(TransferAction.ACTION_OVERWRITE)) {
            return this.OVERWRITE_FILTER;
        }
        if (action.equals(TransferAction.ACTION_RESUME)) {
            return this.RESUME_FILTER;
        }
        if (action.equals(TransferAction.ACTION_RENAME)) {
            return this.RENAME_FILTER;
        }
        if (action.equals(TransferAction.ACTION_RENAME_EXISTING)) {
            return this.RENAME_EXISTING_FILTER;
        }
        if (action.equals(TransferAction.ACTION_SKIP)) {
            return this.SKIP_FILTER;
        }
        if (action.equals(TransferAction.ACTION_CALLBACK)) {
            for (Path upload : this.getRoots()) {
                if (!this.check()) {
                    return null;
                }
                if (!upload.exists() || upload.getLocal().attributes().isDirectory() && 0 == this.children(upload).size()) continue;
                TransferAction result = this.prompt.prompt();
                return this.filter(result);
            }
            return this.filter(TransferAction.ACTION_OVERWRITE);
        }
        return super.filter(action);
    }

    @Override
    public TransferAction action(boolean resumeRequested, boolean reloadRequested) {
        log.debug((Object)("action:" + resumeRequested + "," + reloadRequested));
        if (resumeRequested) {
            return TransferAction.ACTION_RESUME;
        }
        if (reloadRequested) {
            return TransferAction.forName(Preferences.instance().getProperty("queue.upload.reload.fileExists"));
        }
        return TransferAction.forName(Preferences.instance().getProperty("queue.upload.fileExists"));
    }

    private boolean isSymlinkSupported(Path file) {
        if (Preferences.instance().getBoolean("local.symboliclink.resolve")) {
            return false;
        }
        if (this.getSession().isCreateSymlinkSupported()) {
            AbstractPath target = file.getLocal().getSymlinkTarget();
            for (Path root : this.roots) {
                if (!target.isChild(root.getLocal())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void transfer(Path file) {
        log.debug((Object)("transfer:" + file));
        Permission perm = Permission.EMPTY;
        if (file.getLocal().attributes().isSymbolicLink() && this.isSymlinkSupported(file)) {
            String target = StringUtils.substringAfter((String)file.getLocal().getSymlinkTarget().getAbsolute(), (String)(file.getLocal().getParent().getAbsolute() + '/'));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Symlink " + file + ":" + target));
            }
            file.symlink(target);
            file.status().setComplete(true);
        } else if (file.attributes().isFile()) {
            if (this.getSession().isUnixPermissionsSupported() && Preferences.instance().getBoolean("queue.upload.changePermissions") && file.exists()) {
                if (file.attributes().getPermission().equals(Permission.EMPTY)) {
                    file.readUnixPermission();
                }
                perm = file.attributes().getPermission();
            }
            String original = file.getName();
            if (Preferences.instance().getBoolean("queue.upload.file.temporary") && file.getSession().isRenameSupported(file)) {
                String temporary = MessageFormat.format(Preferences.instance().getProperty("queue.upload.file.temporary.format"), file.getName(), UUID.randomUUID().toString());
                file.setPath(file.getParent(), temporary);
            }
            file.upload(this.bandwidth, new AbstractStreamListener(){

                public void bytesSent(long bytes) {
                    UploadTransfer.this.transferred += (double)bytes;
                }
            });
            if (file.status().isComplete() && Preferences.instance().getBoolean("queue.upload.file.temporary") && file.getSession().isRenameSupported(file)) {
                file.rename(PathFactory.createPath(file.getSession(), file.getParent().getAbsolute(), original, file.attributes().getType()));
                file.setPath(file.getParent(), original);
            }
        } else if (file.attributes().isDirectory() && file.getSession().isCreateFolderSupported(file)) {
            file.mkdir();
        }
        if (!file.status().isCanceled()) {
            if (this.getSession().isAclSupported()) {
                // empty if block
            }
            if (this.getSession().isUnixPermissionsSupported() && Preferences.instance().getBoolean("queue.upload.changePermissions")) {
                if (perm.equals(Permission.EMPTY)) {
                    if (Preferences.instance().getBoolean("queue.upload.permissions.useDefault")) {
                        if (file.attributes().isFile()) {
                            perm = new Permission(Preferences.instance().getInteger("queue.upload.permissions.file.default"));
                        } else if (file.attributes().isDirectory()) {
                            perm = new Permission(Preferences.instance().getInteger("queue.upload.permissions.folder.default"));
                        }
                    } else if (file.getLocal().exists()) {
                        perm = file.getLocal().attributes().getPermission();
                    }
                }
                if (perm.equals(Permission.EMPTY)) {
                    log.debug((Object)("Skip writing empty permissions for:" + this.toString()));
                } else {
                    file.writeUnixPermission(perm, false);
                }
            }
            if (file.attributes().isFile() && file.getSession().isTimestampSupported() && Preferences.instance().getBoolean("queue.upload.preserveDate")) {
                file.writeTimestamp(file.getLocal().attributes().getCreationDate(), file.getLocal().attributes().getModificationDate(), file.getLocal().attributes().getAccessedDate());
            }
        }
    }

    @Override
    protected void fireDidTransferPath(Path file) {
        if (file.attributes().isDirectory() && file.getSession().isTimestampSupported() && Preferences.instance().getBoolean("queue.upload.preserveDate")) {
            file.writeTimestamp(file.getLocal().attributes().getCreationDate(), file.getLocal().attributes().getModificationDate(), file.getLocal().attributes().getAccessedDate());
        }
        super.fireDidTransferPath(file);
    }

    @Override
    protected void fireTransferDidEnd() {
        if (this.isReset() && this.isComplete() && !this.isCanceled() && this.getTransferred() != 0.0) {
            Growl.instance().notify("Upload complete", this.getName());
        }
        super.fireTransferDidEnd();
    }

    private abstract class UploadTransferFilter
    extends Transfer.TransferFilter {
        private UploadTransferFilter() {
        }

        public boolean accept(Path file) {
            if (!file.getLocal().exists()) {
                return false;
            }
            if (file.getLocal().attributes().isSymbolicLink() && !UploadTransfer.this.isSymlinkSupported(file)) {
                AbstractPath target = file.getLocal().getSymlinkTarget();
                for (Path root : UploadTransfer.this.roots) {
                    if (!target.isChild(root.getLocal())) continue;
                    return false;
                }
            }
            return true;
        }

        public void prepare(Path file) {
            if (file.attributes().isFile()) {
                if (file.getLocal().attributes().isSymbolicLink()) {
                    if (!UploadTransfer.this.isSymlinkSupported(file)) {
                        AbstractPath target = file.getLocal().getSymlinkTarget();
                        UploadTransfer.this.size += (double)target.attributes().getSize();
                    }
                } else {
                    UploadTransfer.this.size += (double)file.getLocal().attributes().getSize();
                    if (file.status().isResume()) {
                        UploadTransfer.this.transferred += (double)file.attributes().getSize();
                    }
                }
            }
            if (file.attributes().isDirectory() && !file.exists()) {
                file.cache().put(file.getReference(), new AttributedList());
            }
        }

        public void complete(Path p) {
        }
    }
}

