/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.cloud.CloudPath;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.ui.DateFormatterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.log4j.Logger;
import org.soyatec.windows.azure.blob.DateTime;
import org.soyatec.windows.azure.blob.IBlobContainer;
import org.soyatec.windows.azure.blob.IBlobProperties;
import org.soyatec.windows.azure.blob.IContainerAccessControl;
import org.soyatec.windows.azure.blob.IContainerProperties;
import org.soyatec.windows.azure.blob.ISharedAccessUrl;
import org.soyatec.windows.azure.blob.ResourceType;
import org.soyatec.windows.azure.blob.SharedAccessPermissions;
import org.soyatec.windows.azure.blob.internal.BlobContents;
import org.soyatec.windows.azure.blob.internal.BlobProperties;
import org.soyatec.windows.azure.blob.internal.ContainerAccessControl;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.internal.SignedIdentifier;
import org.soyatec.windows.azure.util.NameValueCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AzurePath
extends CloudPath {
    private static Logger log = Logger.getLogger(AzurePath.class);
    private final AzureSession session;
    public static final Acl.UserAndRole PUBLIC_ACL = new Acl.UserAndRole(new Acl.CanonicalUser("anonymous", Locale.localizedString("Anonymous", "Azure"), false){

        public String getPlaceholder() {
            return this.getDisplayName();
        }
    }, new Acl.Role("public"));
    public static final Acl.UserAndRole PRIVATE_ACL = new Acl.UserAndRole(new Acl.CanonicalUser("anonymous", Locale.localizedString("Anonymous", "Azure"), false){

        public String getPlaceholder() {
            return this.getDisplayName();
        }
    }, new Acl.Role("private"));

    public static PathFactory factory() {
        return new Factory();
    }

    protected AzurePath(AzureSession s, String parent, String name, int type) {
        super(parent, name, type);
        this.session = s;
    }

    protected AzurePath(AzureSession s, String path, int type) {
        super(path, type);
        this.session = s;
    }

    protected AzurePath(AzureSession s, String parent, Local file) {
        super(parent, file);
        this.session = s;
    }

    protected <T> AzurePath(AzureSession s, T dict) {
        super(dict);
        this.session = s;
    }

    @Override
    public AzureSession getSession() {
        return this.session;
    }

    @Override
    public void readMetadata() {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Reading metadata of {0}", "Status"), this.getName()));
            AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
            if (this.isContainer()) {
                IContainerProperties properties = container.getContainerProperties();
                if (null == properties.getMetadata()) {
                    log.warn((Object)("No container properties for " + this.getAbsolute()));
                    return;
                }
                HashMap<String, String> metadata = new HashMap<String, String>();
                for (Object key : properties.getMetadata().keySet()) {
                    metadata.put(key.toString(), properties.getMetadata().getSingleValue(key.toString()));
                }
                this.attributes().setMetadata(metadata);
            } else if (this.attributes().isFile()) {
                HashMap<String, String> metadata = new HashMap<String, String>();
                IBlobProperties properties = container.getBlobProperties(this.getKey());
                if (null == properties.getMetadata()) {
                    log.warn((Object)("No blob metadata for " + this.getAbsolute()));
                } else {
                    for (Object key : properties.getMetadata().keySet()) {
                        metadata.put(key.toString(), properties.getMetadata().getSingleValue(key.toString()));
                    }
                }
                this.attributes().setMetadata(metadata);
            }
        }
        catch (StorageException e) {
            this.error("Cannot read file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMetadata(Map<String, String> meta) {
        block7: {
            try {
                block6: {
                    try {
                        this.getSession().check();
                        this.getSession().message(MessageFormat.format(Locale.localizedString("Writing metadata of {0}", "Status"), this.getName()));
                        NameValueCollection collection = new NameValueCollection();
                        collection.putAll(meta);
                        AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
                        if (this.isContainer()) {
                            container.setContainerMetadata(collection);
                            break block6;
                        }
                        if (!this.attributes().isFile()) break block6;
                        BlobProperties properties = new BlobProperties(this.getKey());
                        properties.setMetadata(collection);
                        container.updateBlobMetadata(properties);
                    }
                    catch (StorageException e) {
                        this.error("Cannot write file attributes", e);
                        Object var6_8 = null;
                        this.attributes().clear(false, false, false, true);
                        break block7;
                    }
                    catch (IOException e) {
                        this.error("Cannot write file attributes", e);
                        Object var6_9 = null;
                        this.attributes().clear(false, false, false, true);
                    }
                }
                Object var6_7 = null;
                this.attributes().clear(false, false, false, true);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.attributes().clear(false, false, false, true);
                throw throwable;
            }
        }
    }

    @Override
    public void readAcl() {
        if (this.isContainer()) {
            try {
                AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
                ContainerAccessControl acl = container.getContainerAccessControl();
                this.attributes().setAcl(this.convert(acl));
            }
            catch (StorageException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    protected Acl convert(ContainerAccessControl list) {
        Acl acl = new Acl();
        acl.addAll(list.isPublic() ? PUBLIC_ACL : PRIVATE_ACL);
        return acl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAcl(Acl acl, boolean recursive) {
        block7: {
            if (this.isContainer()) {
                try {
                    try {
                        AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
                        ContainerAccessControl list = acl.asList().contains(PUBLIC_ACL) ? new ContainerAccessControl(true) : new ContainerAccessControl(false);
                        for (Acl.UserAndRole userAndRole : acl.asList()) {
                            if (!userAndRole.isValid()) continue;
                            list.addSignedIdentifier(new SignedIdentifier(userAndRole.getUser().getIdentifier(), SharedAccessPermissions.valueOf(userAndRole.getRole().getName()), null, null));
                        }
                        container.setContainerAccessControl(list);
                    }
                    catch (StorageException e) {
                        this.error("Cannot change permissions", e);
                        Object var8_10 = null;
                        this.attributes().clear(false, false, true, false);
                        break block7;
                    }
                    catch (IOException e) {
                        this.error("Cannot change permissions", e);
                        Object var8_11 = null;
                        this.attributes().clear(false, false, true, false);
                    }
                    Object var8_9 = null;
                    this.attributes().clear(false, false, true, false);
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    this.attributes().clear(false, false, true, false);
                    throw throwable;
                }
            }
        }
    }

    @Override
    public boolean exists() {
        if (this.isRoot()) {
            return true;
        }
        try {
            IBlobContainer container = this.getSession().getClient().getBlobContainer(this.getContainerName());
            if (this.isContainer()) {
                return container.isContainerExist();
            }
            return container.isBlobExist(this.getKey());
        }
        catch (IOException e) {
            return false;
        }
        catch (StorageException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage());
            return false;
        }
    }

    @Override
    public AttributedList<Path> list(AttributedList<Path> children) {
        block10: {
            if (this.attributes().isDirectory()) {
                try {
                    this.getSession().check();
                    this.getSession().message(MessageFormat.format(Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
                    if (this.isRoot()) {
                        for (AzureSession.AzureContainer container : this.getSession().getContainers(true)) {
                            Path p = PathFactory.createPath(this.getSession(), this.getAbsolute(), container.getContainerName(), 10);
                            p.attributes().setOwner(container.getAccountName());
                            p.attributes().setModificationDate(container.getLastModifiedTime().getTime());
                            children.add(p);
                        }
                    } else {
                        AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
                        Iterator<IBlobProperties> blobs = container.listBlobs(this.getKey(), true);
                        while (blobs.hasNext()) {
                            IBlobProperties object = blobs.next();
                            Path file = PathFactory.createPath(this.getSession(), this.getContainerName(), object.getName(), "application/directory".equals(object.getContentType()) ? 2 : 1);
                            if (!file.getParent().equals(this)) continue;
                            file.setParent(this);
                            file.attributes().setSize(object.getContentLength());
                            file.attributes().setChecksum(object.getETag());
                            file.attributes().setModificationDate(object.getLastModifiedTime().getTime());
                            file.attributes().setOwner(this.attributes().getOwner());
                            if (file.attributes().isDirectory()) {
                                file.attributes().setPlaceholder(true);
                            }
                            children.add(file);
                        }
                    }
                    this.getSession().setWorkdir(this);
                }
                catch (StorageException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (this.cache().isEmpty()) {
                        this.error(e.getMessage(), e);
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (!this.cache().isEmpty()) break block10;
                    this.error(e.getMessage(), e);
                }
            }
        }
        return children;
    }

    @Override
    public void readSize() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
                AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
                this.attributes().setSize(container.getBlobProperties(this.getKey()).getContentLength());
            }
            catch (StorageException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    @Override
    public void readTimestamp() {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
            AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
            if (this.isContainer()) {
                this.attributes().setModificationDate(container.getLastModifiedTime().getTime());
            } else if (this.attributes().isFile()) {
                this.attributes().setModificationDate(container.getBlobProperties(this.getKey()).getLastModifiedTime().getTime());
            }
        }
        catch (StorageException e) {
            this.error("Cannot read file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void readChecksum() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Compute MD5 hash of {0}", "Status"), this.getName()));
                AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
                this.attributes().setChecksum(container.getBlobProperties(this.getKey()).getETag());
            }
            catch (StorageException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        if (!this.attributes().isFile()) return;
        OutputStream out = null;
        InputStream in = null;
        try {
            try {
                AzureSession.AzureContainer container;
                if (check) {
                    this.getSession().check();
                }
                if (null == (in = (container = this.getSession().getContainer(this.getContainerName())).getBlob(this.getKey()))) {
                    throw new IOException("Unable opening data stream");
                }
                Status status = this.status();
                status.setResume(false);
                out = this.getLocal().getOutputStream(status.isResume());
                this.download(in, out, throttle, listener);
            }
            catch (StorageException e) {
                this.error("Download failed", e);
                Object var9_11 = null;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                return;
            }
            catch (IOException e) {
                this.error("Download failed", e);
                Object var9_12 = null;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                return;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void upload(final BandwidthThrottle throttle, final StreamListener listener, boolean check) {
        if (this.attributes().isFile()) {
            try {
                if (check) {
                    this.getSession().check();
                }
                final Status status = this.status();
                status.setResume(false);
                final InputStream in = this.getLocal().getInputStream();
                try {
                    AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
                    BlobProperties properties = new BlobProperties(this.getKey());
                    properties.setContentType(this.getLocal().getMimeType());
                    NameValueCollection metadata = new NameValueCollection();
                    for (String m : Preferences.instance().getList("azure.metadata.default")) {
                        if (StringUtils.isBlank((String)m)) {
                            log.warn((Object)("Invalid header " + m));
                            continue;
                        }
                        if (!m.contains("=")) {
                            log.warn((Object)("Invalid header " + m));
                            continue;
                        }
                        int split = m.indexOf(61);
                        String name = m.substring(0, split);
                        if (StringUtils.isBlank((String)name)) {
                            log.warn((Object)("Missing key in " + m));
                            continue;
                        }
                        String value = m.substring(split + 1);
                        if (StringUtils.isEmpty((String)value)) {
                            log.warn((Object)("Missing value in " + m));
                            continue;
                        }
                        metadata.put(name, value);
                    }
                    properties.setMetadata(metadata);
                    boolean blob = container.createBlob(properties, (HttpEntity)new AbstractHttpEntity(){
                        private boolean consumed = false;

                        public boolean isRepeatable() {
                            return false;
                        }

                        public Header getContentType() {
                            return new BasicHeader("Content-Type", AzurePath.this.getLocal().getMimeType());
                        }

                        public long getContentLength() {
                            return AzurePath.this.getLocal().attributes().getSize() - status.getCurrent();
                        }

                        public InputStream getContent() throws IOException, IllegalStateException {
                            return AzurePath.this.getLocal().getInputStream();
                        }

                        public void writeTo(OutputStream out) throws IOException {
                            AzurePath.this.upload(out, in, throttle, listener);
                            this.consumed = true;
                        }

                        public boolean isStreaming() {
                            return !this.consumed;
                        }

                        public void consumeContent() throws IOException {
                            this.consumed = true;
                            AzurePath.this.getLocal().getInputStream().close();
                        }
                    });
                    if (!blob) {
                        this.status().setComplete(false);
                    }
                    Object var15_17 = null;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    IOUtils.closeQuietly((InputStream)in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                {
                }
            }
            catch (StorageException e) {
                this.error("Upload failed", e);
            }
            catch (IOException e) {
                this.error("Upload failed", e);
            }
        }
    }

    @Override
    public void mkdir() {
        if (this.attributes().isDirectory()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Making directory {0}", "Status"), this.getName()));
                if (this.isContainer()) {
                    this.getSession().getClient().createContainer(this.getContainerName(), new NameValueCollection(), IContainerAccessControl.Private);
                    this.getSession().getContainers(true);
                } else {
                    BlobProperties properties = new BlobProperties(this.getKey());
                    properties.setContentType("application/directory");
                    this.getSession().getContainer(this.getContainerName()).createBlob(properties, new BlobContents(new byte[0]), true);
                }
                this.cache().put(this.getReference(), AttributedList.emptyList());
                this.getParent().invalidate();
            }
            catch (StorageException e) {
                this.error("Cannot create folder {0}", e);
            }
            catch (IOException e) {
                this.error("Cannot create folder {0}", e);
            }
        }
    }

    @Override
    public void delete() {
        try {
            this.getSession().check();
            if (!this.isContainer()) {
                this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
                container.deleteBlob(this.getKey());
            } else if (this.attributes().isDirectory()) {
                for (AbstractPath i : this.children()) {
                    if (!this.getSession().isConnected()) break;
                    i.delete();
                }
                if (this.isContainer()) {
                    this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                    this.getSession().getClient().deleteContainer(this.getContainerName());
                }
            }
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot delete {0}", e);
        }
    }

    @Override
    public void readUnixPermission() {
        try {
            if (this.isContainer()) {
                AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
                ContainerAccessControl acl = container.getContainerAccessControl();
                Permission permission = new Permission();
                permission.getOtherPermissions()[0] = acl.isPublic();
                this.attributes().setPermission(permission);
            }
        }
        catch (StorageException e) {
            this.error("Cannot change permissions", e);
        }
        catch (IOException e) {
            this.error("Cannot change permissions", e);
        }
    }

    @Override
    public void writeUnixPermission(Permission perm, boolean recursive) {
        try {
            if (this.isContainer()) {
                AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
                ContainerAccessControl acl = perm.getOtherPermissions()[0] ? new ContainerAccessControl(true) : new ContainerAccessControl(false);
                container.setContainerAccessControl(acl);
            }
        }
        catch (StorageException e) {
            this.error("Cannot change permissions", e);
        }
        catch (IOException e) {
            this.error("Cannot change permissions", e);
        }
    }

    @Override
    public void writeTimestamp(long created, long modified, long accessed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(AbstractPath renamed) {
        this.copy(renamed);
        renamed.getParent().invalidate();
        this.delete();
        this.getParent().invalidate();
    }

    @Override
    public void copy(AbstractPath copy) {
        if (((Path)copy).getSession().equals(this.getSession())) {
            if (this.attributes().isFile()) {
                NameValueCollection metadata = new NameValueCollection();
                if (this.attributes().getMetadata().isEmpty()) {
                    this.readMetadata();
                }
                metadata.putAll(this.attributes().getMetadata());
                try {
                    this.getSession().getContainer(this.getContainerName()).copyBlob(((AzurePath)copy).getContainerName(), ((AzurePath)copy).getKey(), this.getKey(), metadata, null);
                }
                catch (IOException e) {
                    this.error("Cannot copy {0}");
                }
            } else if (this.attributes().isDirectory()) {
                for (AbstractPath i : this.children()) {
                    if (!this.getSession().isConnected()) break;
                    i.copy(PathFactory.createPath(this.getSession(), copy.getAbsolute(), i.getName(), i.attributes().getType()));
                }
            }
            copy.getParent().invalidate();
        } else {
            super.copy(copy);
        }
    }

    @Override
    public String toURL() {
        try {
            AzureSession.AzureContainer container = this.getSession().getContainer(this.getContainerName());
            if (this.isContainer()) {
                return container.getContainerUri().toString();
            }
            StringBuilder url = new StringBuilder();
            url.append(this.getSession().getHost().getProtocol().getScheme()).append("://");
            url.append(this.getSession().getHostnameForContainer(this.getContainerName()));
            url.append(this.getAbsolute());
        }
        catch (IOException e) {
            log.warn((Object)e.getMessage());
        }
        return super.toURL();
    }

    public AbstractPath.DescriptiveUrl toSignedUrl() {
        ResourceType type = this.isContainer() ? ResourceType.Container : ResourceType.Blob;
        Date now = new Date();
        Calendar expiry = Calendar.getInstance();
        expiry.setTime(now);
        expiry.add(10, 1);
        try {
            String signedidentifier = null;
            ISharedAccessUrl shared = this.getSession().getClient().createSharedAccessUrl(this.getContainerName(), this.getKey(), type, 9, null, new DateTime(expiry.getTime()), signedidentifier);
            return new AbstractPath.DescriptiveUrl(shared.getRestUrl(), MessageFormat.format(Locale.localizedString("Expires on {0}", "S3"), DateFormatterFactory.instance().getLongFormat(expiry.getTimeInMillis())));
        }
        catch (ConnectionCanceledException e) {
            log.warn((Object)e.getMessage());
            return new AbstractPath.DescriptiveUrl(null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<AzureSession> {
        private Factory() {
        }

        @Override
        protected Path create(AzureSession session, String path, int type) {
            return new AzurePath(session, path, type);
        }

        @Override
        protected Path create(AzureSession session, String parent, String name, int type) {
            return new AzurePath(session, parent, name, type);
        }

        @Override
        protected Path create(AzureSession session, String parent, Local file) {
            return new AzurePath(session, parent, file);
        }

        @Override
        protected <T> Path create(AzureSession session, T dict) {
            return new AzurePath(session, dict);
        }
    }
}

