/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.azure.AzurePath;
import ch.cyberduck.core.cloud.CloudHTTP4Session;
import ch.cyberduck.core.i18n.Locale;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.soyatec.windows.azure.authenticate.SharedKeyCredentials;
import org.soyatec.windows.azure.blob.DateTime;
import org.soyatec.windows.azure.blob.IBlobContainer;
import org.soyatec.windows.azure.blob.IBlobProperties;
import org.soyatec.windows.azure.blob.IContainerAccessControl;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.blob.SharedAccessPermissions;
import org.soyatec.windows.azure.blob.internal.BlobContainerRest;
import org.soyatec.windows.azure.blob.internal.BlobProperties;
import org.soyatec.windows.azure.blob.internal.BlobStorageRest;
import org.soyatec.windows.azure.blob.internal.ContainerAccessControl;
import org.soyatec.windows.azure.blob.internal.RetryPolicies;
import org.soyatec.windows.azure.error.StorageErrorCode;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.error.StorageServerException;
import org.soyatec.windows.azure.internal.AccessPolicy;
import org.soyatec.windows.azure.internal.OutParameter;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.internal.SignedIdentifier;
import org.soyatec.windows.azure.internal.constants.HttpWebResponse;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.Logger;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.TimeSpan;
import org.soyatec.windows.azure.util.xml.XPathQueryHelper;
import org.soyatec.windows.azure.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AzureSession
extends CloudHTTP4Session {
    private static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(AzureSession.class);
    private BlobStorageRest client;
    private Map<String, AzureContainer> containers = new HashMap<String, AzureContainer>();

    public static SessionFactory factory() {
        return new Factory();
    }

    protected AzureSession(Host h) {
        super(h);
    }

    @Override
    public List<String> getSupportedStorageClasses() {
        return Collections.emptyList();
    }

    protected BlobStorageRest getClient() throws ConnectionCanceledException {
        if (null == this.client) {
            throw new ConnectionCanceledException();
        }
        return this.client;
    }

    @Override
    protected void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        this.login();
        this.fireConnectionDidOpenEvent();
    }

    @Override
    protected void login(LoginController controller, Credentials credentials) throws IOException {
        try {
            this.client = new BlobStorageRest(new URI(this.host.getProtocol().getScheme() + "://" + this.host.getHostname()), false, credentials.getUsername(), credentials.getPassword());
        }
        catch (URISyntaxException e) {
            log.error((Object)("Failure parsing URI:" + e.getMessage()));
            IOException failure = new IOException(e.getMessage());
            failure.initCause(e);
            throw failure;
        }
        this.client.setTimeout(TimeSpan.fromMilliseconds(this.timeout()));
        try {
            this.getContainers(true);
        }
        catch (StorageServerException e) {
            if (this.isLoginFailure(e)) {
                this.message(Locale.localizedString("Login failed", "Credentials"));
                controller.fail(this.host.getProtocol(), credentials);
                this.login();
            }
            IOException failure = new IOException(e.getCause().getMessage());
            failure.initCause(e);
            throw failure;
        }
    }

    protected boolean isLoginFailure(StorageServerException e) {
        Throwable cause = e.getCause();
        return cause instanceof StorageServerException && 403 == ((StorageServerException)cause).getStatusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
                super.close();
            }
            Object var2_1 = null;
            this.client = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.client = null;
            this.fireConnectionDidCloseEvent();
            throw throwable;
        }
        this.fireConnectionDidCloseEvent();
    }

    protected List<AzureContainer> getContainers(boolean reload) throws IOException, StorageServerException {
        if (this.containers.isEmpty() || reload) {
            this.containers.clear();
            for (IBlobContainer container : this.getClient().listBlobContainers()) {
                this.containers.put(container.getContainerName(), new AzureContainer(container.getContainerName(), container.getLastModifiedTime()));
            }
        }
        return new ArrayList<AzureContainer>(this.containers.values());
    }

    protected AzureContainer getContainer(String bucketname) throws IOException {
        try {
            for (AzureContainer container : this.getContainers(false)) {
                if (!container.getContainerName().equals(bucketname)) continue;
                return container;
            }
        }
        catch (StorageServerException e) {
            this.error("Cannot read file attributes", e);
        }
        log.warn((Object)("Bucket not found with name:" + bucketname));
        return new AzureContainer("$root", null);
    }

    @Override
    public boolean isAclSupported() {
        return false;
    }

    @Override
    public List<Acl.User> getAvailableAclUsers() {
        return Arrays.asList(AzurePath.PUBLIC_ACL.getUser());
    }

    @Override
    public Acl getPrivateAcl(String container) {
        return new Acl();
    }

    @Override
    public Acl getPublicAcl(String container, boolean readable, boolean writable) {
        Acl acl = new Acl();
        if (readable) {
            acl.addAll(AzurePath.PUBLIC_ACL.getUser(), AzurePath.PUBLIC_ACL.getRole());
        }
        return acl;
    }

    @Override
    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Arrays.asList(AzurePath.PUBLIC_ACL.getRole(), AzurePath.PRIVATE_ACL.getRole());
    }

    @Override
    public boolean isDownloadResumable() {
        return false;
    }

    @Override
    public boolean isUploadResumable() {
        return false;
    }

    @Override
    public boolean isCreateFileSupported(Path workdir) {
        return !workdir.isRoot();
    }

    @Override
    public boolean isCDNSupported() {
        return false;
    }

    @Override
    public boolean isChecksumSupported() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AzureContainer
    extends BlobContainerRest {
        public AzureContainer(String containerName, Timestamp lastModified) throws ConnectionCanceledException {
            super(AzureSession.this.getClient().getBaseUri(), AzureSession.this.getClient().isUsePathStyleUris(), AzureSession.this.getClient().getAccountName(), containerName, AzureSession.this.getClient().getBase64Key(), lastModified, AzureSession.this.getClient().getTimeout(), AzureSession.this.getClient().getRetryPolicy());
        }

        public boolean createBlob(BlobProperties blobProperties, HttpEntity entity) throws StorageException {
            try {
                return this.putBlobImpl(blobProperties, entity);
            }
            catch (Exception e) {
                throw HttpUtilities.translateWebException(e);
            }
        }

        private boolean putBlobImpl(final BlobProperties blobProperties, final HttpEntity entity) throws Exception {
            IRetryPolicy policy = RetryPolicies.noRetry();
            boolean retval = (Boolean)policy.execute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AzureContainer.this.uploadData(blobProperties, entity);
                }
            });
            return retval;
        }

        private boolean uploadData(BlobProperties blobProperties, HttpEntity data) throws Exception {
            boolean retval;
            ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), this.getContainerName(), blobProperties.getName());
            URI blobUri = HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), this.getContainerName(), blobProperties.getName(), this.getTimeout(), new NameValueCollection(), uriComponents);
            HttpRequest request = this.createHttpRequestForPutBlob(blobUri, "PUT", blobProperties);
            SharedKeyCredentials credentials = AzureSession.this.getClient().getCredentials();
            credentials.signRequest(request, uriComponents);
            ((HttpEntityEnclosingRequest)request).setEntity(data);
            HttpResponse execute = AzureSession.this.http().execute((HttpUriRequest)request);
            HttpWebResponse response = new HttpWebResponse(execute);
            if (response.getStatusCode() == 201) {
                retval = true;
            } else {
                retval = false;
                HttpUtilities.processUnexpectedStatusCode(response);
            }
            HttpEntity entity = execute.getEntity();
            if (null != entity) {
                EntityUtils.consume((HttpEntity)entity);
            }
            blobProperties.setLastModifiedTime(response.getLastModified());
            blobProperties.setETag(response.getHeader("ETag"));
            return retval;
        }

        private HttpRequest createHttpRequestForPutBlob(URI blobUri, String httpMethod, IBlobProperties blobProperties) {
            HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(blobUri, httpMethod, this.getTimeout());
            if (blobProperties.getContentEncoding() != null) {
                request.addHeader("Content-Encoding", blobProperties.getContentEncoding());
            }
            if (blobProperties.getContentLanguage() != null) {
                request.addHeader("Content-Language", blobProperties.getContentLanguage());
            }
            if (blobProperties.getContentType() != null) {
                request.addHeader("Content-Type", blobProperties.getContentType());
            }
            if (blobProperties.getMetadata() != null && blobProperties.getMetadata().size() > 0) {
                HttpUtilities.addMetadataHeaders(request, blobProperties.getMetadata());
            }
            return request;
        }

        public InputStream getBlob(String blobName) throws StorageException {
            try {
                HttpWebResponse response = this.getBlobImpl("GET", blobName, new OutParameter<Boolean>(false));
                return response.getStream();
            }
            catch (Exception e) {
                throw HttpUtilities.translateWebException(e);
            }
        }

        private HttpWebResponse getBlobImpl(final String httpMethod, final String blobName, OutParameter<Boolean> modified) {
            final HttpWebResponse[] httpWebResponses = new HttpWebResponse[1];
            final OutParameter<Boolean> localModified = new OutParameter<Boolean>(true);
            this.stopFetchProgress(Boolean.FALSE);
            modified.setValue(localModified.getValue());
            IRetryPolicy rp = RetryPolicies.noRetry();
            long originalPosition = 0L;
            rp.execute(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    HttpWebResponse response;
                    httpWebResponses[0] = response = AzureContainer.this.downloadData(httpMethod, blobName, 0L, 0L, new NameValueCollection(), localModified);
                    return response;
                }
            });
            modified.setValue(localModified.getValue());
            return httpWebResponses[0];
        }

        private HttpWebResponse downloadData(String httpMethod, String blobName, long offset, long length, NameValueCollection nvc, OutParameter<Boolean> localModified) throws StorageException, ConnectionCanceledException {
            ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), this.getContainerName(), blobName);
            URI blobUri = HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), this.getContainerName(), blobName, this.getTimeout(), nvc, uriComponents);
            HttpRequest request = this.createHttpRequestForGetBlob(blobUri, httpMethod);
            if (offset != 0L || length != 0L) {
                String rangeHeaderValue = MessageFormat.format("bytes={0,number,#}-{1,number,#}", offset, offset + length - 1L);
                request.addHeader("x-ms-range", rangeHeaderValue);
            }
            SharedKeyCredentials credentials = AzureSession.this.getClient().getCredentials();
            credentials.signRequest(request, uriComponents);
            try {
                HttpWebResponse response = new HttpWebResponse(AzureSession.this.http().execute((HttpUriRequest)request));
                if (response.getStatusCode() == 200 || response.getStatusCode() == 206) {
                    return response;
                }
                HttpUtilities.processUnexpectedStatusCode(response);
                return null;
            }
            catch (Exception we) {
                throw HttpUtilities.translateWebException(we);
            }
        }

        private HttpRequest createHttpRequestForGetBlob(URI blobUri, String httpMethod) {
            return HttpUtilities.createHttpRequestWithCommonHeaders(blobUri, httpMethod, this.getTimeout());
        }

        @Override
        public ContainerAccessControl getContainerAccessControl() throws StorageException {
            ContainerAccessControl accessControl;
            try {
                accessControl = (ContainerAccessControl)this.getRetryPolicy().execute(new Callable<ContainerAccessControl>(){

                    @Override
                    public ContainerAccessControl call() throws Exception {
                        NameValueCollection queryParams = new NameValueCollection();
                        queryParams.put("comp", "acl");
                        queryParams.put("restype", "container");
                        ResourceUriComponents uriComponents = new ResourceUriComponents(AzureContainer.this.getAccountName(), AzureContainer.this.getContainerName(), null);
                        URI uri = HttpUtilities.createRequestUri(AzureContainer.this.getBaseUri(), AzureContainer.this.isUsePathStyleUris(), AzureContainer.this.getAccountName(), AzureContainer.this.getContainerName(), null, AzureContainer.this.getTimeout(), queryParams, uriComponents);
                        HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "GET", AzureContainer.this.getTimeout());
                        request.addHeader("x-ms-version", "2009-07-17");
                        AzureSession.this.getClient().getCredentials().signRequest(request, uriComponents);
                        HttpWebResponse response = new HttpWebResponse(AzureSession.this.http().execute((HttpUriRequest)request));
                        if (response.getStatusCode() == 200) {
                            String acl = response.getHeader("x-ms-prop-publicaccess");
                            boolean publicAcl = false;
                            if (acl != null) {
                                ContainerAccessControl aclEntity;
                                publicAcl = Boolean.parseBoolean(acl);
                                List identifiers = AzureContainer.this.getSignedIdentifiersFromResponse(response);
                                if (identifiers != null && identifiers.size() > 0) {
                                    aclEntity = new ContainerAccessControl(publicAcl);
                                    aclEntity.setSigendIdentifiers(identifiers);
                                } else {
                                    aclEntity = publicAcl ? IContainerAccessControl.Public : IContainerAccessControl.Private;
                                }
                                return aclEntity;
                            }
                            throw new StorageServerException(StorageErrorCode.ServiceBadResponse, "The server did not respond with expected container access control header", response.getStatusCode(), null);
                        }
                        HttpUtilities.processUnexpectedStatusCode(response);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw HttpUtilities.translateWebException(e);
            }
            return accessControl;
        }

        private List<SignedIdentifier> getSignedIdentifiersFromResponse(HttpWebResponse response) {
            InputStream stream = response.getStream();
            if (stream == null) {
                return Collections.EMPTY_LIST;
            }
            try {
                Document doc = XmlUtil.load(stream, "Container access control parsed error.");
                List selectNodes = doc.selectNodes(XPathQueryHelper.SignedIdentifierListQuery);
                ArrayList<SignedIdentifier> result = new ArrayList<SignedIdentifier>();
                if (selectNodes.size() > 0) {
                    for (Object selectNode : selectNodes) {
                        Element element = (Element)selectNode;
                        SignedIdentifier identifier = new SignedIdentifier();
                        identifier.setId(XPathQueryHelper.loadSingleChildStringValue(element, "Id", true));
                        AccessPolicy policy = new AccessPolicy();
                        Element accesPlocy = (Element)element.selectSingleNode("AccessPolicy");
                        if (accesPlocy != null && accesPlocy.hasContent()) {
                            String end;
                            String start = XPathQueryHelper.loadSingleChildStringValue(accesPlocy, "Start", true);
                            if (StringUtils.isNotEmpty((String)start)) {
                                policy.setStart(new DateTime(start));
                            }
                            if (StringUtils.isNotEmpty((String)(end = XPathQueryHelper.loadSingleChildStringValue(accesPlocy, "Expiry", true)))) {
                                policy.setExpiry(new DateTime(end));
                            }
                            policy.setPermission(SharedAccessPermissions.valueOf(XPathQueryHelper.loadSingleChildStringValue(accesPlocy, "Permission", true)));
                            identifier.setPolicy(policy);
                        }
                        result.add(identifier);
                    }
                }
                return result;
            }
            catch (Exception e) {
                Logger.error("Parse container accesss control error", e);
                return Collections.EMPTY_LIST;
            }
        }
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new AzureSession(h);
        }
    }
}

