/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cdn;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.i18n.Locale;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Distribution {
    private static Logger log = Logger.getLogger(Distribution.class);
    private String id;
    private boolean deployed;
    private String origin;
    private boolean enabled;
    private boolean logging;
    private String url;
    private String status;
    private String[] cnames;
    private Method method;
    private String defaultRootObject;
    private String errorDocument;
    private String invalidationStatus;
    public static final Method WEBSITE = new Method(){

        public String toString() {
            return Locale.localizedString("Website Configuration (HTTP)", "S3");
        }

        public String getProtocol() {
            return "http://";
        }

        public int getDefaultPort() {
            return 80;
        }

        public String getContext() {
            return "";
        }
    };
    public static final Method WEBSITE_CDN = new Method(){

        public String toString() {
            return Locale.localizedString("Website Configuration (HTTP) CDN", "S3");
        }

        public String getProtocol() {
            return "http://";
        }

        public int getDefaultPort() {
            return 80;
        }

        public String getContext() {
            return "";
        }
    };
    public static final Method DOWNLOAD = new Method(){

        public String toString() {
            return Locale.localizedString("Download (HTTP) CDN", "S3");
        }

        public String getProtocol() {
            return "http://";
        }

        public int getDefaultPort() {
            return 80;
        }

        public String getContext() {
            return "";
        }
    };
    public static final Method CUSTOM = new Method(){

        public String toString() {
            return Locale.localizedString("Custom Origin Server (HTTP/HTTPS) CDN", "S3");
        }

        public String getProtocol() {
            return "http://";
        }

        public int getDefaultPort() {
            return 80;
        }

        public String getContext() {
            return "";
        }
    };
    public static final Method STREAMING = new Method(){

        public String toString() {
            return Locale.localizedString("Streaming (RTMP) CDN", "S3");
        }

        public String getProtocol() {
            return "rtmp://";
        }

        public int getDefaultPort() {
            return 1935;
        }

        public String getContext() {
            return "/cfx/st";
        }
    };

    public Distribution(String origin, Method method) {
        this(null, origin, method, false, false, null, null, new String[0], false);
    }

    public Distribution(String id, String origin, Method method, boolean enabled, String url, String status) {
        this(id, origin, method, enabled, url, status, new String[0]);
    }

    public Distribution(String id, String origin, Method method, boolean enabled, String url, String status, boolean logging) {
        this(id, origin, method, enabled, enabled, url, status, new String[0], logging);
    }

    public Distribution(String id, String origin, Method method, boolean enabled, String url, String status, String[] cnames) {
        this(id, origin, method, enabled, enabled, url, status, cnames);
    }

    public Distribution(String id, String origin, Method method, boolean enabled, boolean deployed, String url, String status, String[] cnames) {
        this(id, origin, method, enabled, deployed, url, status, cnames, false);
    }

    public Distribution(String id, String origin, Method method, boolean enabled, boolean deployed, String url, String status, String[] cnames, boolean logging) {
        this(id, origin, method, enabled, deployed, url, status, cnames, logging, null);
    }

    public Distribution(String id, String origin, Method method, boolean enabled, boolean deployed, String url, String status, String[] cnames, boolean logging, String defaultRootObject) {
        this.id = id;
        this.origin = origin;
        this.enabled = enabled;
        this.deployed = deployed;
        this.url = url;
        this.status = status;
        this.cnames = cnames;
        this.logging = logging;
        this.method = method;
        this.defaultRootObject = defaultRootObject;
    }

    public String getId() {
        return this.id;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getOrigin(Path file) {
        StringBuilder url = new StringBuilder().append(this.getMethod().getProtocol()).append(this.getOrigin());
        if (!file.isContainer()) {
            url.append('/').append(Path.encode(file.getKey()));
        }
        try {
            return new URI(url.toString()).normalize().toString();
        }
        catch (URISyntaxException e) {
            log.error((Object)("Failure parsing URI:" + e.getMessage()));
            return url.toString();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public String getURL() {
        return this.url;
    }

    public String getURL(Path file) {
        if (StringUtils.isEmpty((String)this.getURL())) {
            return null;
        }
        StringBuilder b = new StringBuilder(this.getURL());
        if (StringUtils.isNotEmpty((String)file.getKey())) {
            b.append(Path.encode(file.getKey()));
        }
        try {
            return new URI(b.toString()).normalize().toString();
        }
        catch (URISyntaxException e) {
            log.error((Object)("Failure parsing URI:" + e.getMessage()));
            return b.toString();
        }
    }

    public List<AbstractPath.DescriptiveUrl> getURLs(Path file) {
        List<AbstractPath.DescriptiveUrl> urls = this.getCnameURL(file);
        urls.add(new AbstractPath.DescriptiveUrl(this.getURL(file), MessageFormat.format(Locale.localizedString("{0} CDN URL"), Locale.localizedString(this.method.toString(), "S3"))));
        return urls;
    }

    public List<AbstractPath.DescriptiveUrl> getCnameURL(Path file) {
        ArrayList<AbstractPath.DescriptiveUrl> urls = new ArrayList<AbstractPath.DescriptiveUrl>();
        for (String cname : this.cnames) {
            urls.add(new AbstractPath.DescriptiveUrl(this.getCnameURL(cname, file), MessageFormat.format(Locale.localizedString("{0} CDN URL"), Locale.localizedString(this.method.toString(), "S3"))));
        }
        return urls;
    }

    private String getCnameURL(String cname, Path file) {
        StringBuilder b = new StringBuilder();
        b.append(this.getMethod().getProtocol()).append(cname).append(this.getMethod().getContext());
        if (StringUtils.isNotEmpty((String)file.getKey())) {
            b.append(Path.encode(file.getKey()));
        }
        try {
            return new URI(b.toString()).normalize().toString();
        }
        catch (URISyntaxException e) {
            log.error((Object)("Failure parsing URI:" + e.getMessage()));
            return b.toString();
        }
    }

    public String getStatus() {
        if (null == this.status) {
            return Locale.localizedString("Unknown");
        }
        return this.status;
    }

    public String getInvalidationStatus() {
        if (null == this.invalidationStatus) {
            return Locale.localizedString("None");
        }
        return this.invalidationStatus;
    }

    public void setInvalidationStatus(String invalidationStatus) {
        this.invalidationStatus = invalidationStatus;
    }

    public String[] getCNAMEs() {
        if (null == this.cnames) {
            return new String[0];
        }
        return this.cnames;
    }

    public String getDefaultRootObject() {
        return this.defaultRootObject;
    }

    public void setDefaultRootObject(String defaultRootObject) {
        this.defaultRootObject = defaultRootObject;
    }

    public String getErrorDocument() {
        return this.errorDocument;
    }

    public void setErrorDocument(String errorDocument) {
        this.errorDocument = errorDocument;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String toString() {
        return this.getId();
    }

    public static abstract class Method {
        public abstract String toString();

        public abstract String getProtocol();

        public abstract int getDefaultPort();

        public abstract String getContext();

        public static Method forName(String name) {
            if (DOWNLOAD.toString().equals(name)) {
                return DOWNLOAD;
            }
            if (STREAMING.toString().equals(name)) {
                return STREAMING;
            }
            if (CUSTOM.toString().equals(name)) {
                return CUSTOM;
            }
            if (WEBSITE.toString().equals(name)) {
                return WEBSITE;
            }
            if (WEBSITE_CDN.toString().equals(name)) {
                return WEBSITE_CDN;
            }
            throw new RuntimeException();
        }
    }
}

