/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cf;

import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cloud.CloudHTTP4Session;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import com.rackspacecloud.client.cloudfiles.FilesCDNContainer;
import com.rackspacecloud.client.cloudfiles.FilesClient;
import com.rackspacecloud.client.cloudfiles.FilesException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpException;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFSession
extends CloudHTTP4Session {
    private static Logger log = Logger.getLogger(CFSession.class);
    private FilesClient CF;
    private DistributionConfiguration cdn;
    private boolean cdnRequest;

    public static SessionFactory factory() {
        return new Factory();
    }

    public CFSession(Host h) {
        super(h);
    }

    protected FilesClient getClient() throws ConnectionCanceledException {
        if (null == this.CF) {
            throw new ConnectionCanceledException();
        }
        return this.CF;
    }

    @Override
    protected void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.CF = new FilesClient((HttpClient)this.http(), null, null, null, null, this.timeout());
        this.fireConnectionWillOpenEvent();
        this.configure();
        this.login();
        this.fireConnectionDidOpenEvent();
    }

    protected void configure() throws IOException {
        FilesClient client = this.getClient();
        client.setConnectionTimeOut(this.timeout());
        client.setUserAgent(this.getUserAgent());
        client.setUseETag(false);
        client.setAuthenticationURL(this.getAuthenticationUrl());
    }

    private String getAuthenticationUrl() {
        StringBuilder authentication = new StringBuilder(this.host.getProtocol().getScheme()).append("://");
        if (this.host.getHostname().equals(Protocol.CLOUDFILES.getDefaultHostname())) {
            authentication.append(Preferences.instance().getProperty("cf.authentication.host"));
        } else {
            authentication.append(this.host.getHostname()).append(":").append(this.host.getPort());
        }
        authentication.append(Preferences.instance().getProperty("cf.authentication.context"));
        if (log.isInfoEnabled()) {
            log.info((Object)("Using authentication URL " + authentication.toString()));
        }
        return authentication.toString();
    }

    @Override
    public AbstractX509TrustManager getTrustManager(String hostname) {
        if (!this.trust.containsKey(hostname)) {
            this.trust.put(hostname, new KeychainX509TrustManager(){

                public String getHostname() {
                    try {
                        if (CFSession.this.isConnected()) {
                            FilesClient client = CFSession.this.getClient();
                            if (!client.isLoggedin()) {
                                URI url = new URI(client.getAuthenticationURL());
                                return url.getHost();
                            }
                            if (CFSession.this.cdnRequest) {
                                URI url = new URI(client.getCdnManagementURL());
                                return url.getHost();
                            }
                            URI url = new URI(client.getStorageURL());
                            return url.getHost();
                        }
                        URI url = new URI(CFSession.this.getAuthenticationUrl());
                        return url.getHost();
                    }
                    catch (URISyntaxException e) {
                        log.error((Object)("Failure parsing URI:" + e.getMessage()));
                    }
                    catch (ConnectionCanceledException e) {
                        log.warn((Object)e.getMessage());
                    }
                    return null;
                }
            });
        }
        return (AbstractX509TrustManager)this.trust.get(hostname);
    }

    @Override
    protected void login(LoginController controller, Credentials credentials) throws IOException {
        FilesClient client = this.getClient();
        client.setUserName(credentials.getUsername());
        client.setPassword(credentials.getPassword());
        try {
            if (!client.login()) {
                this.message(Locale.localizedString("Login failed", "Credentials"));
                controller.fail(this.host.getProtocol(), credentials);
                this.login();
            }
        }
        catch (HttpException e) {
            IOException failure = new IOException(e.getMessage());
            failure.initCause(e);
            throw failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
            }
            Object var2_1 = null;
            this.CF = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.CF = null;
            this.fireConnectionDidCloseEvent();
            throw throwable;
        }
        this.fireConnectionDidCloseEvent();
    }

    @Override
    public boolean isDownloadResumable() {
        return false;
    }

    @Override
    public boolean isUploadResumable() {
        return false;
    }

    @Override
    public boolean isRenameSupported(Path file) {
        return false;
    }

    @Override
    public boolean isCreateFileSupported(Path workdir) {
        return !workdir.isRoot();
    }

    @Override
    public boolean isChecksumSupported() {
        return true;
    }

    @Override
    public boolean isCDNSupported() {
        return this.host.getHostname().equals(Protocol.CLOUDFILES.getDefaultHostname());
    }

    @Override
    public DistributionConfiguration cdn() {
        if (this.host.getHostname().equals(Protocol.CLOUDFILES.getDefaultHostname())) {
            if (null == this.cdn) {
                this.cdn = new DistributionConfiguration(){
                    private Map<String, Distribution> distributionStatus = new HashMap<String, Distribution>();

                    @Override
                    public boolean isConfigured(Distribution.Method method) {
                        return !this.distributionStatus.isEmpty();
                    }

                    @Override
                    public String getOrigin(Distribution.Method method, String container) {
                        return container;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void write(boolean enabled, String origin, Distribution.Method method, String[] cnames, boolean logging, String defaultRootObject) {
                        try {
                            try {
                                CFSession.this.check();
                                if (enabled) {
                                    CFSession.this.message(MessageFormat.format(Locale.localizedString("Enable {0} Distribution", "Status"), Locale.localizedString("Rackspace Cloud Files", "Mosso")));
                                } else {
                                    CFSession.this.message(MessageFormat.format(Locale.localizedString("Disable {0} Distribution", "Status"), Locale.localizedString("Rackspace Cloud Files", "Mosso")));
                                }
                                CFSession.this.cdnRequest = true;
                                URI url = new URI(CFSession.this.getClient().getCdnManagementURL());
                                if (enabled) {
                                    try {
                                        FilesCDNContainer info = CFSession.this.getClient().getCDNContainerInfo(origin);
                                    }
                                    catch (FilesException e) {
                                        log.warn((Object)e.getMessage());
                                        CFSession.this.getClient().cdnEnableContainer(origin);
                                    }
                                }
                                CFSession.this.getClient().cdnUpdateContainer(origin, -1, enabled, logging);
                            }
                            catch (IOException e) {
                                CFSession.this.error("Cannot write CDN configuration", e);
                                Object var10_14 = null;
                                this.distributionStatus.clear();
                                CFSession.this.cdnRequest = false;
                                return;
                            }
                            catch (URISyntaxException e) {
                                CFSession.this.error("Cannot write CDN configuration", e);
                                Object var10_15 = null;
                                this.distributionStatus.clear();
                                CFSession.this.cdnRequest = false;
                                return;
                            }
                            catch (HttpException e) {
                                CFSession.this.error("Cannot write CDN configuration", e);
                                Object var10_16 = null;
                                this.distributionStatus.clear();
                                CFSession.this.cdnRequest = false;
                                return;
                            }
                            Object var10_13 = null;
                            this.distributionStatus.clear();
                        }
                        catch (Throwable throwable) {
                            Object var10_17 = null;
                            this.distributionStatus.clear();
                            CFSession.this.cdnRequest = false;
                            throw throwable;
                        }
                        CFSession.this.cdnRequest = false;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public Distribution read(String origin, Distribution.Method method) {
                        block8: {
                            if (!this.distributionStatus.containsKey(origin) || !this.distributionStatus.get(origin).isDeployed()) {
                                try {
                                    try {
                                        CFSession.this.check();
                                        CFSession.this.message(MessageFormat.format(Locale.localizedString("Reading CDN configuration of {0}", "Status"), origin));
                                        CFSession.this.cdnRequest = true;
                                        FilesCDNContainer info = CFSession.this.getClient().getCDNContainerInfo(origin);
                                        Distribution distribution = new Distribution(info.getName(), new URI(CFSession.this.getClient().getStorageURL()).getHost(), method, info.isEnabled(), info.getCdnURL(), info.isEnabled() ? Locale.localizedString("CDN Enabled", "Mosso") : Locale.localizedString("CDN Disabled", "Mosso"), info.getRetainLogs());
                                        this.distributionStatus.put(origin, distribution);
                                    }
                                    catch (HttpException e) {
                                        log.warn((Object)e.getMessage());
                                        this.distributionStatus.put(origin, new Distribution(null, origin, method, false, null, Locale.localizedString("CDN Disabled", "Mosso")));
                                        Object var6_9 = null;
                                        CFSession.this.cdnRequest = false;
                                        break block8;
                                    }
                                    catch (IOException e) {
                                        CFSession.this.error("Cannot read CDN configuration", e);
                                        Object var6_10 = null;
                                        CFSession.this.cdnRequest = false;
                                        break block8;
                                    }
                                    catch (URISyntaxException e) {
                                        CFSession.this.error("Cannot read CDN configuration", e);
                                        Object var6_11 = null;
                                        CFSession.this.cdnRequest = false;
                                        break block8;
                                    }
                                    Object var6_8 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var6_12 = null;
                                    CFSession.this.cdnRequest = false;
                                    throw throwable;
                                }
                                CFSession.this.cdnRequest = false;
                            }
                        }
                        if (this.distributionStatus.containsKey(origin)) {
                            return this.distributionStatus.get(origin);
                        }
                        return new Distribution(origin, method);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void invalidate(String origin, Distribution.Method method, List<Path> files, boolean recursive) {
                        try {
                            try {
                                CFSession.this.check();
                                CFSession.this.message(MessageFormat.format(Locale.localizedString("Writing CDN configuration of {0}", "Status"), origin));
                                CFSession.this.cdnRequest = true;
                                URI url = new URI(CFSession.this.getClient().getCdnManagementURL());
                                for (Path file : files) {
                                    if (file.isContainer()) {
                                        CFSession.this.getClient().purgeCDNContainer(origin, null);
                                        continue;
                                    }
                                    CFSession.this.getClient().purgeCDNObject(origin, file.getKey(), null);
                                }
                                Object var9_11 = null;
                                this.distributionStatus.clear();
                            }
                            catch (IOException e) {
                                CFSession.this.error("Cannot write CDN configuration", e);
                                Object var9_12 = null;
                                this.distributionStatus.clear();
                                CFSession.this.cdnRequest = false;
                                return;
                            }
                            catch (URISyntaxException e) {
                                CFSession.this.error("Cannot write CDN configuration", e);
                                Object var9_13 = null;
                                this.distributionStatus.clear();
                                CFSession.this.cdnRequest = false;
                                return;
                            }
                            catch (HttpException e) {
                                CFSession.this.error("Cannot write CDN configuration", e);
                                Object var9_14 = null;
                                this.distributionStatus.clear();
                                CFSession.this.cdnRequest = false;
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_15 = null;
                            this.distributionStatus.clear();
                            CFSession.this.cdnRequest = false;
                            throw throwable;
                        }
                        CFSession.this.cdnRequest = false;
                    }

                    @Override
                    public boolean isInvalidationSupported(Distribution.Method method) {
                        return true;
                    }

                    @Override
                    public boolean isDefaultRootSupported(Distribution.Method method) {
                        return false;
                    }

                    @Override
                    public boolean isLoggingSupported(Distribution.Method method) {
                        return method.equals(Distribution.DOWNLOAD);
                    }

                    @Override
                    public boolean isCnameSupported(Distribution.Method method) {
                        return false;
                    }

                    @Override
                    public List<Distribution.Method> getMethods() {
                        return Arrays.asList(Distribution.DOWNLOAD);
                    }

                    @Override
                    public String toString() {
                        return Locale.localizedString("Akamai", "Mosso");
                    }

                    @Override
                    public String toString(Distribution.Method method) {
                        return this.toString();
                    }

                    @Override
                    public void clear() {
                        this.distributionStatus.clear();
                    }
                };
            }
        } else {
            this.cdn = super.cdn();
        }
        return this.cdn;
    }

    @Override
    public List<String> getSupportedStorageClasses() {
        return Collections.emptyList();
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new CFSession(h);
        }
    }
}

