/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.IOResumeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.WebdavResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAVPath
extends Path {
    private static Logger log = Logger.getLogger(DAVPath.class);
    private final DAVSession session;

    public static PathFactory factory() {
        return new Factory();
    }

    protected DAVPath(DAVSession s, String parent, String name, int type) {
        super(parent, name, type);
        this.session = s;
    }

    protected DAVPath(DAVSession s, String path, int type) {
        super(path, type);
        this.session = s;
    }

    protected DAVPath(DAVSession s, String parent, Local file) {
        super(parent, file);
        this.session = s;
    }

    protected <T> DAVPath(DAVSession s, T dict) {
        super(dict);
        this.session = s;
    }

    @Override
    public DAVSession getSession() {
        return this.session;
    }

    @Override
    public void readSize() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
                this.getSession().getClient().setPath(this.attributes().isDirectory() ? this.getAbsolute() + String.valueOf('/') : this.getAbsolute());
                this.getSession().getClient().setProperties(3, 1);
                this.attributes().setSize(this.getSession().getClient().getGetContentLength());
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    @Override
    public void readTimestamp() {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
            this.getSession().getClient().setPath(this.attributes().isDirectory() ? this.getAbsolute() + String.valueOf('/') : this.getAbsolute());
            this.getSession().getClient().setProperties(3, 1);
            this.attributes().setModificationDate(this.getSession().getClient().getGetLastModified());
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void delete() {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
            if (!this.getSession().getClient().deleteMethod(this.getAbsolute())) {
                throw new IOException(this.getSession().getClient().getStatusMessage());
            }
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot delete {0}", e);
        }
    }

    @Override
    public AttributedList<Path> list(AttributedList<Path> children) {
        block9: {
            if (this.attributes().isDirectory()) {
                try {
                    WebdavResource[] resources;
                    this.getSession().check();
                    this.getSession().message(MessageFormat.format(Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
                    this.getSession().setWorkdir(this);
                    this.getSession().getClient().setContentType("text/xml");
                    for (WebdavResource resource : resources = this.getSession().getClient().listWebdavResources()) {
                        if (null == resource.getResourceType()) {
                            log.warn((Object)("Skipping unknown resource type:" + resource));
                            continue;
                        }
                        try {
                            URI uri = new URI(new String(resource.getHttpURL().getRawURI()));
                            Path p = PathFactory.createPath((Session)this.getSession(), uri.getPath(), resource.getResourceType().isCollection() ? 2 : 1);
                            p.setParent(this);
                            p.attributes().setOwner(resource.getOwner());
                            if (resource.getGetLastModified() > 0L) {
                                p.attributes().setModificationDate(resource.getGetLastModified());
                            }
                            if (resource.getCreationDate() > 0L) {
                                p.attributes().setCreationDate(resource.getCreationDate());
                            }
                            p.attributes().setSize(resource.getGetContentLength());
                            children.add(p);
                        }
                        catch (URISyntaxException e) {
                            log.error((Object)("Failure parsing URI:" + e.getMessage()));
                        }
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (!this.cache().isEmpty()) break block9;
                    this.error(e.getMessage(), e);
                }
            }
        }
        return children;
    }

    @Override
    public void mkdir() {
        if (this.attributes().isDirectory()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Making directory {0}", "Status"), this.getName()));
                this.getSession().getClient().setContentType("text/xml");
                if (!this.getSession().getClient().mkcolMethod(this.getAbsolute())) {
                    throw new IOException(this.getSession().getClient().getStatusMessage());
                }
                this.cache().put(this.getReference(), AttributedList.emptyList());
                this.getParent().invalidate();
            }
            catch (IOException e) {
                this.error("Cannot create folder {0}", e);
            }
        }
    }

    @Override
    public void readUnixPermission() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUnixPermission(Permission perm, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTimestamp(long created, long modified, long accessed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(AbstractPath renamed) {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Renaming {0} to {1}", "Status"), this.getName(), renamed.getName()));
            if (!this.getSession().getClient().moveMethod(this.getAbsolute(), renamed.getAbsolute())) {
                throw new IOException(this.getSession().getClient().getStatusMessage());
            }
            renamed.getParent().invalidate();
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot rename {0}", e);
        }
    }

    @Override
    public void copy(AbstractPath copy) {
        if (((Path)copy).getSession().equals(this.getSession())) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Copying {0} to {1}", "Status"), this.getName(), copy));
                if (this.attributes().isFile()) {
                    if (!this.getSession().getClient().copyMethod(this.getAbsolute(), copy.getAbsolute())) {
                        throw new IOException(this.getSession().getClient().getStatusMessage());
                    }
                } else if (this.attributes().isDirectory()) {
                    copy.mkdir();
                    for (AbstractPath i : this.children()) {
                        if (!this.getSession().isConnected()) break;
                        i.copy(PathFactory.createPath(this.getSession(), copy.getAbsolute(), i.getName(), i.attributes().getType()));
                    }
                }
                copy.getParent().invalidate();
            }
            catch (IOException e) {
                this.error("Cannot copy {0}");
            }
        } else {
            super.copy(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        if (!this.attributes().isFile()) return;
        OutputStream out = null;
        InputStream in = null;
        try {
            try {
                if (check) {
                    this.getSession().check();
                }
                if (this.status().isResume()) {
                    this.getSession().getClient().addRequestHeader("Range", "bytes=" + this.status().getCurrent() + "-");
                }
                this.getSession().getClient().addRequestHeader("Accept-Encoding", "gzip");
                in = this.getSession().getClient().getMethodData(this.getAbsolute());
                if (!this.getSession().getClient().isResume()) {
                    this.status().setResume(false);
                }
                out = this.getLocal().getOutputStream(this.status().isResume());
                this.download(in, out, throttle, listener);
            }
            catch (IOException e) {
                this.error("Download failed", e);
                Object var8_7 = null;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void upload(final BandwidthThrottle throttle, final StreamListener listener, boolean check) {
        if (this.attributes().isFile()) {
            try {
                if (check) {
                    this.getSession().check();
                }
                final InputStream in = this.getLocal().getInputStream();
                try {
                    Status status = this.status();
                    if (status.isResume()) {
                        this.getSession().getClient().addRequestHeader("Content-Range", "bytes " + status.getCurrent() + "-" + (this.getLocal().attributes().getSize() - 1L) + "/" + this.getLocal().attributes().getSize());
                        long skipped = in.skip(status.getCurrent());
                        log.info((Object)("Skipping " + skipped + " bytes"));
                        if (skipped < status.getCurrent()) {
                            throw new IOResumeException("Skipped " + skipped + " bytes instead of " + status.getCurrent());
                        }
                    }
                    if (!this.getSession().getClient().putMethod(this.getAbsolute(), (RequestEntity)new InputStreamRequestEntity(in, this.getLocal().attributes().getSize() - status.getCurrent(), this.getLocal().getMimeType()){

                        public void writeRequest(OutputStream out) throws IOException {
                            DAVPath.this.upload(out, in, throttle, listener);
                        }
                    })) {
                        throw new IOException(this.getSession().getClient().getStatusMessage());
                    }
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    IOUtils.closeQuietly((InputStream)in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                {
                }
            }
            catch (IOException e) {
                this.error("Upload failed", e);
            }
        }
    }

    @Override
    public String toHttpURL() {
        return this.toURL();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<DAVSession> {
        private Factory() {
        }

        @Override
        protected Path create(DAVSession session, String path, int type) {
            return new DAVPath(session, path, type);
        }

        @Override
        protected Path create(DAVSession session, String parent, String name, int type) {
            return new DAVPath(session, parent, name, type);
        }

        @Override
        protected Path create(DAVSession session, String parent, Local file) {
            return new DAVPath(session, parent, file);
        }

        @Override
        protected <T> Path create(DAVSession session, T dict) {
            return new DAVPath(session, dict);
        }
    }
}

