/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.dropbox.client.Account;
import ch.cyberduck.core.dropbox.client.DropboxClient;
import ch.cyberduck.core.http.HTTP4Session;
import ch.cyberduck.core.i18n.Locale;
import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class DropboxSession
extends HTTP4Session {
    private static Logger log = Logger.getLogger(DropboxSession.class);
    private DropboxClient client;

    public static SessionFactory factory() {
        return new Factory();
    }

    protected DropboxSession(Host h) {
        super(h);
    }

    protected DropboxClient getClient() throws ConnectionCanceledException {
        if (null == this.client) {
            throw new ConnectionCanceledException();
        }
        return this.client;
    }

    protected void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        this.client = new DropboxClient((HttpClient)this.http(), this.getHost().getProtocol().getScheme(), this.getHost().getPort());
        this.login();
        if (log.isInfoEnabled()) {
            Account account = this.getClient().account();
            log.info((Object)("Logged in as " + account.getDisplayName() + "(" + account.getUid() + ")"));
        }
        this.fireConnectionDidOpenEvent();
    }

    protected void login(LoginController controller, Credentials credentials) throws IOException {
        Credentials application = new Credentials(Preferences.instance().getProperty("dropbox.key"), Preferences.instance().getProperty("dropbox.secret"), false){

            public String getUsernamePlaceholder() {
                return Locale.localizedString("Dropbox API Key");
            }

            public String getPasswordPlaceholder() {
                return Locale.localizedString("Dropbox API Secret");
            }
        };
        if (!application.validate(this.getHost().getProtocol())) {
            controller.prompt(this.host.getProtocol(), application, Locale.localizedString("Dropbox App Keys"), Locale.localizedString("Provide additional login credentials", "Credentials") + ".", false, false, false);
            Preferences.instance().setProperty("dropbox.key", application.getUsername());
            Preferences.instance().setProperty("dropbox.secret", application.getPassword());
        }
        try {
            this.client.authenticate(Preferences.instance().getProperty("dropbox.key"), Preferences.instance().getProperty("dropbox.secret"), credentials.getUsername(), credentials.getPassword());
        }
        catch (IOException e) {
            controller.fail(this.getHost().getProtocol(), credentials, e.getMessage());
            Preferences.instance().deleteProperty("dropbox.secret");
            this.login();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
                super.close();
            }
            Object var2_1 = null;
            this.client = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.client = null;
            this.fireConnectionDidCloseEvent();
            throw throwable;
        }
        this.fireConnectionDidCloseEvent();
    }

    public boolean isAclSupported() {
        return false;
    }

    public boolean isUnixPermissionsSupported() {
        return false;
    }

    public boolean isDownloadResumable() {
        return false;
    }

    public boolean isUploadResumable() {
        return false;
    }

    public boolean isCDNSupported() {
        return false;
    }

    public boolean isChecksumSupported() {
        return true;
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new DropboxSession(h);
        }
    }
}

