/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox.client;

import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.dropbox.client.Authenticator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class AbstractHttpDropboxClient {
    private static Logger log = Logger.getLogger(AbstractHttpDropboxClient.class);
    protected Authenticator auth;
    protected static final String ROOT = "dropbox";
    protected static final int BUFFER_SIZE = 2048;
    protected static final int API_VERSION = 0;
    private String api_host;
    private String content_host;
    private String protocol;
    private int port;
    protected HttpClient client;

    protected AbstractHttpDropboxClient(HttpClient client, String api_host, String content_host, String protocol, int port) {
        this.api_host = api_host;
        this.content_host = content_host;
        this.protocol = protocol;
        this.port = port;
        this.client = client;
        HttpParams params = this.client.getParams();
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
    }

    protected HttpClient getClient() {
        return this.client;
    }

    public void authenticate(String key, String secret, String username, String password) throws IOException {
        String[] params = new String[]{"email", username, "password", password};
        CommonsHttpOAuthConsumer consumer = new CommonsHttpOAuthConsumer(key, secret);
        HttpGet request = new HttpGet(this.getUrl("/token", params, false));
        try {
            consumer.sign((Object)request);
        }
        catch (OAuthException e) {
            IOException failure = new IOException(e.getMessage());
            failure.initCause(e);
            throw failure;
        }
        JSONObject credentials = this.parse(this.execute((HttpUriRequest)request));
        String token_key = credentials.get((Object)"token").toString();
        String token_secret = credentials.get((Object)"secret").toString();
        log.info((Object)("Obtained Token Key:" + token_key));
        log.info((Object)("Obtained Token Secret:" + token_secret));
        this.auth = new Authenticator(key, secret, this.getRequestPath("/oauth/request_token"), this.getRequestPath("/oauth/access_token"), this.getRequestPath("/oauth/authorize"), token_key, token_secret);
    }

    protected HttpResponse request(HttpUriRequest req) throws IOException {
        if (null == this.auth) {
            throw new ConnectionCanceledException();
        }
        try {
            this.auth.sign((HttpRequest)req);
        }
        catch (OAuthException e) {
            IOException failure = new IOException(e.getMessage());
            failure.initCause(e);
            throw failure;
        }
        return this.execute(req);
    }

    protected String urlencode(String[] params) {
        String result = "";
        try {
            boolean firstTime = true;
            for (int i = 0; i < params.length; i += 2) {
                if (params[i + 1] == null) continue;
                if (firstTime) {
                    firstTime = false;
                } else {
                    result = result + "&";
                }
                result = result + URLEncoder.encode("" + params[i], "UTF-8") + "=" + URLEncoder.encode("" + params[i + 1], "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private String readResponse(HttpResponse response) throws IOException {
        String inputLine;
        HttpEntity ent = response.getEntity();
        BufferedReader in = new BufferedReader(new InputStreamReader(ent.getContent()), 2048);
        String result = "";
        while ((inputLine = in.readLine()) != null) {
            result = result + inputLine;
        }
        return result;
    }

    protected void finish(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (null != entity) {
            EntityUtils.consume((HttpEntity)entity);
        }
        this.verify(response);
    }

    protected void verify(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException(response.getStatusLine().getReasonPhrase());
        }
    }

    protected JSONObject parse(HttpResponse response) throws IOException {
        try {
            this.verify(response);
            String body = this.readResponse(response);
            JSONObject jSONObject = (JSONObject)new JSONParser().parse(body);
            return jSONObject;
        }
        catch (ParseException e) {
            throw new IOException("Invalid JSON response from server");
        }
        finally {
            this.finish(response);
        }
    }

    protected HttpResponse execute(HttpUriRequest req) throws IOException {
        return this.client.execute(req);
    }

    protected HttpUriRequest buildRequest(String method, String path) {
        return this.buildRequest(method, path, new String[0]);
    }

    protected HttpUriRequest buildRequest(String method, String path, String[] params) {
        return this.buildRequest(method, path, params, false);
    }

    protected HttpUriRequest buildRequest(String method, String path, boolean content) {
        return this.buildRequest(method, path, new String[0], content);
    }

    protected HttpUriRequest buildRequest(String method, String path, String[] params, boolean content) {
        if (method.equals("GET")) {
            return new HttpGet(this.getUrl(path, params, content));
        }
        if (method.equals("POST")) {
            HttpPost post = new HttpPost(this.getUrl(path, params, content));
            if (params != null && params.length > 2) {
                ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
                for (int i = 0; i < params.length; i += 2) {
                    if (params[i + 1] == null) continue;
                    form.add(new BasicNameValuePair("" + params[i], "" + params[i + 1]));
                }
                try {
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(form, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return post;
        }
        throw new IllegalArgumentException(method);
    }

    protected String getUrl(String path) {
        return this.getUrl(path, new String[0], false);
    }

    protected String getUrl(String path, String[] params, boolean content) {
        if (content) {
            return this.protocol + "://" + this.content_host + ":" + this.port + this.getRequestPath(path, params);
        }
        return this.protocol + "://" + this.api_host + ":" + this.port + this.getRequestPath(path, params);
    }

    protected String getRequestPath(String target) {
        return this.getRequestPath(target, new String[0]);
    }

    protected String getRequestPath(String target, String[] params) {
        try {
            target = URLEncoder.encode("/0" + target, "UTF-8");
            target = target.replace("%2F", "/").replace("+", "%20");
            if (params != null && params.length > 0) {
                target = target + "?" + this.urlencode(params);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return target;
    }

    protected HttpResponse getFile(String from_path) throws IOException {
        return this.getFile(from_path, null);
    }

    protected HttpResponse getFile(String path, String etag) throws IOException {
        HttpUriRequest req = this.buildRequest("GET", "/files/dropbox" + path, true);
        if (StringUtils.isNotBlank((String)etag)) {
            req.addHeader("If-None-Match", etag);
        }
        return this.request(req);
    }
}

