/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox.client;

import ch.cyberduck.core.dropbox.client.AbstractHttpDropboxClient;
import ch.cyberduck.core.dropbox.client.Account;
import ch.cyberduck.core.dropbox.client.ListEntryResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import oauth.signpost.exception.OAuthException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;

public class DropboxClient
extends AbstractHttpDropboxClient {
    private static Logger log = Logger.getLogger(DropboxClient.class);

    public DropboxClient(HttpClient client, String protocol, int port) {
        super(client, "api.getdropbox.com", "api-content.getdropbox.com", protocol, port);
    }

    public void copy(String from_path, String to_path) throws IOException {
        String[] params = new String[]{"root", "dropbox", "from_path", from_path, "to_path", to_path};
        HttpResponse response = this.request(this.buildRequest("POST", "/fileops/copy", params));
        this.finish(response);
    }

    public void create(String path) throws IOException {
        String[] params = new String[]{"root", "dropbox", "path", path};
        HttpResponse response = this.request(this.buildRequest("POST", "/fileops/create_folder", params));
        this.finish(response);
    }

    public void delete(String path) throws IOException {
        String[] params = new String[]{"root", "dropbox", "path", path};
        HttpResponse response = this.request(this.buildRequest("POST", "/fileops/delete", params));
        this.finish(response);
    }

    public void move(String from_path, String to_path) throws IOException {
        String[] params = new String[]{"root", "dropbox", "from_path", from_path, "to_path", to_path};
        HttpResponse response = this.request(this.buildRequest("POST", "/fileops/move", params));
        this.finish(response);
    }

    public String links(String path) throws IOException {
        return this.getUrl("/links/dropbox" + path);
    }

    public ListEntryResponse metadata(String path, int file_limit, String hash, boolean list, boolean status_in_response, String callback) throws IOException {
        String[] params = new String[]{"file_limit", "" + file_limit, "hash", hash, "list", "" + list, "status_in_response", "" + status_in_response, "callback", callback};
        HttpResponse response = this.request(this.buildRequest("GET", "/files/dropbox" + path, params));
        return new ListEntryResponse(this.parse(response));
    }

    public void put(String to, ContentBody content) throws IOException {
        HttpClient client = this.getClient();
        HttpPost req = (HttpPost)this.buildRequest("POST", "/files/dropbox" + to, true);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("file", content.getFilename()));
        req.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        try {
            this.auth.sign((HttpRequest)req);
        }
        catch (OAuthException e) {
            IOException failure = new IOException(e.getMessage());
            failure.initCause(e);
            throw failure;
        }
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        entity.addPart("file", content);
        req.setEntity((HttpEntity)entity);
        this.finish(client.execute((HttpUriRequest)req));
    }

    public ListEntryResponse list(String path) throws IOException {
        String[] params = new String[]{"list", String.valueOf(true)};
        HttpResponse response = this.request(this.buildRequest("GET", "/metadata/dropbox" + path, params));
        return new ListEntryResponse(this.parse(response));
    }

    public ListEntryResponse metadata(String path) throws IOException {
        String[] params = new String[]{"list", String.valueOf(false)};
        HttpResponse response = this.request(this.buildRequest("GET", "/metadata/dropbox" + path, params));
        return new ListEntryResponse(this.parse(response));
    }

    public Account account() throws IOException {
        HttpResponse response = this.request(this.buildRequest("GET", "/account/info"));
        return new Account(this.parse(response));
    }

    public InputStream get(String dbPath, String etag) throws IOException {
        HttpResponse response = this.getFile(dbPath, etag);
        this.verify(response);
        return response.getEntity().getContent();
    }
}

