/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import java.io.File;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public abstract class AbstractEditor {
    private static Logger log = Logger.getLogger(AbstractEditor.class);
    private boolean deferredDelete;
    protected Path edited;
    private String lastchecksum;

    public AbstractEditor(Path path) {
        this.edited = PathFactory.createPath(path.getSession(), path.getAsDictionary());
        Local folder = LocalFactory.createLocal(new File(Preferences.instance().getProperty("editor.tmp.directory"), this.edited.getHost().getUuid() + String.valueOf('/') + this.edited.getParent().getAbsolute()));
        Local local = LocalFactory.createLocal(folder, this.edited.getName());
        this.edited.setLocal(local);
    }

    protected void setDeferredDelete(boolean deferredDelete) {
        this.deferredDelete = deferredDelete;
    }

    public boolean isDeferredDelete() {
        return this.deferredDelete;
    }

    protected void delete() {
        log.debug((Object)"delete");
        this.edited.getLocal().delete(Preferences.instance().getBoolean("editor.file.trash"));
    }

    protected TransferAction getAction() {
        return TransferAction.ACTION_OVERWRITE;
    }

    protected abstract void edit();

    public void open() {
        AbstractBackgroundAction background = new AbstractBackgroundAction(){

            public void run() {
                AbstractEditor.this.edited.getLocal().delete(Preferences.instance().getBoolean("editor.file.trash"));
                TransferOptions options = new TransferOptions();
                options.closeSession = false;
                DownloadTransfer download = new DownloadTransfer(AbstractEditor.this.edited){

                    public TransferAction action(boolean resumeRequested, boolean reloadRequested) {
                        return AbstractEditor.this.getAction();
                    }

                    protected boolean shouldOpenWhenComplete() {
                        return false;
                    }
                };
                download.start(new TransferPrompt(){

                    public TransferAction prompt() {
                        return TransferAction.ACTION_OVERWRITE;
                    }
                }, options);
                if (AbstractEditor.this.edited.status().isComplete()) {
                    AbstractEditor.this.edited.getSession().message(MessageFormat.format(Locale.localizedString("Compute MD5 hash of {0}", "Status"), AbstractEditor.this.edited.getName()));
                    AbstractEditor.this.lastchecksum = AbstractEditor.this.edited.getLocal().attributes().getChecksum();
                }
            }

            public void cleanup() {
                if (AbstractEditor.this.edited.status().isComplete()) {
                    Permission permissions = AbstractEditor.this.edited.getLocal().attributes().getPermission();
                    permissions.getOwnerPermissions()[0] = true;
                    permissions.getOwnerPermissions()[1] = true;
                    AbstractEditor.this.edited.getLocal().writeUnixPermission(permissions, false);
                    AbstractEditor.this.edit();
                }
            }
        };
        this.open(background);
    }

    protected abstract void open(BackgroundAction var1);

    public void save() {
        AbstractBackgroundAction background = new AbstractBackgroundAction(){

            public void run() {
                AbstractEditor.this.edited.getSession().message(MessageFormat.format(Locale.localizedString("Compute MD5 hash of {0}", "Status"), AbstractEditor.this.edited.getName()));
                if (AbstractEditor.this.lastchecksum.equals(AbstractEditor.this.edited.getLocal().attributes().getChecksum())) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("File not modified:" + AbstractEditor.this.edited.getLocal()));
                    }
                    return;
                }
                AbstractEditor.this.lastchecksum = AbstractEditor.this.edited.getLocal().attributes().getChecksum();
                AbstractEditor.this.edited.status().reset();
                TransferOptions options = new TransferOptions();
                options.closeSession = false;
                UploadTransfer upload = new UploadTransfer(AbstractEditor.this.edited){

                    public TransferAction action(boolean resumeRequested, boolean reloadRequested) {
                        return TransferAction.ACTION_OVERWRITE;
                    }
                };
                upload.start(new TransferPrompt(){

                    public TransferAction prompt() {
                        return TransferAction.ACTION_OVERWRITE;
                    }
                }, options);
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString("Uploading {0}", "Status"), AbstractEditor.this.edited.getName());
            }

            public void cleanup() {
                if (AbstractEditor.this.edited.status().isComplete()) {
                    if (AbstractEditor.this.isDeferredDelete()) {
                        AbstractEditor.this.delete();
                    }
                    AbstractEditor.this.setDeferredDelete(false);
                }
            }
        };
        this.save(background);
    }

    protected abstract void save(BackgroundAction var1);
}

