/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.ui.DateFormatterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPPath
extends Path {
    private static Logger log = Logger.getLogger(FTPPath.class);
    private final FTPSession session;
    private SimpleDateFormat tsFormatSeconds = new SimpleDateFormat("yyyyMMddHHmmss");
    private SimpleDateFormat tsFormatMilliseconds;
    private boolean chmodSupported;

    public static PathFactory factory() {
        return new Factory();
    }

    protected FTPPath(FTPSession s, String parent, String name, int type) {
        super(parent, name, type);
        this.tsFormatSeconds.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.tsFormatMilliseconds = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        this.tsFormatMilliseconds.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.chmodSupported = true;
        this.session = s;
    }

    protected FTPPath(FTPSession s, String path, int type) {
        super(path, type);
        this.tsFormatSeconds.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.tsFormatMilliseconds = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        this.tsFormatMilliseconds.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.chmodSupported = true;
        this.session = s;
    }

    protected FTPPath(FTPSession s, String parent, Local file) {
        super(parent, file);
        this.tsFormatSeconds.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.tsFormatMilliseconds = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        this.tsFormatMilliseconds.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.chmodSupported = true;
        this.session = s;
    }

    protected <T> FTPPath(FTPSession s, T dict) {
        super(dict);
        this.tsFormatSeconds.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.tsFormatMilliseconds = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        this.tsFormatMilliseconds.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.chmodSupported = true;
        this.session = s;
    }

    @Override
    public FTPSession getSession() {
        return this.session;
    }

    private boolean data(DataConnectionAction action) throws IOException {
        block8: {
            try {
                return action.run();
            }
            catch (FTPException failure) {
                log.warn((Object)("Error requesting data socket:" + failure.getMessage()));
                if (Preferences.instance().getBoolean("ftp.connectmode.fallback")) {
                    try {
                        return this.fallback(action);
                    }
                    catch (IOException e) {
                        this.getSession().interrupt();
                        log.warn((Object)("Connect mode fallback failed:" + e.getMessage()));
                        throw failure;
                    }
                }
            }
            catch (SocketTimeoutException failure) {
                log.warn((Object)("Timeout opening data socket:" + failure.getMessage()));
                if (!Preferences.instance().getBoolean("ftp.connectmode.fallback")) break block8;
                this.getSession().interrupt();
                this.getSession().check();
                try {
                    return this.fallback(action);
                }
                catch (IOException e) {
                    this.getSession().interrupt();
                    log.warn((Object)("Connect mode fallback failed:" + e.getMessage()));
                    throw failure;
                }
            }
        }
        return false;
    }

    private boolean fallback(DataConnectionAction action) throws IOException {
        if (this.getSession().getClient().getDataConnectionMode() == 2) {
            log.warn((Object)"Fallback to active data connection");
            this.getSession().getClient().enterLocalActiveMode();
        } else if (this.getSession().getClient().getDataConnectionMode() == 0) {
            log.warn((Object)"Fallback to passive data connection");
            this.getSession().getClient().enterLocalPassiveMode();
        }
        return action.run();
    }

    @Override
    public AttributedList<Path> list(final AttributedList<Path> children) {
        block18: {
            if (this.attributes().isDirectory()) {
                try {
                    this.getSession().check();
                    this.getSession().message(MessageFormat.format(Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
                    final FTPFileEntryParser parser = this.getSession().getFileParser();
                    boolean success = false;
                    try {
                        if (this.getSession().isStatListSupportedEnabled() && this.getSession().getClient().isFeatureSupported(30)) {
                            int response = this.getSession().getClient().stat(this.getAbsolute());
                            if (FTPReply.isPositiveCompletion((int)response)) {
                                String[] reply = this.getSession().getClient().getReplyStrings();
                                ArrayList<String> result = new ArrayList<String>(reply.length);
                                for (String line : reply) {
                                    if (line.startsWith(String.valueOf(response))) {
                                        try {
                                            result.add(line.substring(line.indexOf(response) + line.length() + 1).trim());
                                        }
                                        catch (IndexOutOfBoundsException e) {
                                            log.error((Object)("Failed parsing line '" + line + "':" + e.getMessage()));
                                        }
                                        continue;
                                    }
                                    result.add(StringUtils.stripStart((String)line, null));
                                }
                                success = this.parseListResponse(children, parser, result);
                            } else {
                                this.getSession().setStatListSupportedEnabled(false);
                            }
                        }
                    }
                    catch (IOException e) {
                        log.warn((Object)("Command STAT failed with I/O error:" + e.getMessage()));
                        this.getSession().interrupt();
                        this.getSession().check();
                    }
                    if (!success || children.isEmpty()) {
                        success = this.data(new DataConnectionAction(){

                            public boolean run() throws IOException {
                                if (!FTPPath.this.getSession().getClient().changeWorkingDirectory(FTPPath.this.getAbsolute())) {
                                    throw new FTPException(FTPPath.this.getSession().getClient().getReplyString());
                                }
                                if (!FTPPath.this.getSession().getClient().setFileType(0)) {
                                    throw new FTPException(FTPPath.this.getSession().getClient().getReplyString());
                                }
                                boolean success = false;
                                if (FTPPath.this.getSession().isMlsdListSupportedEnabled() && FTPPath.this.getSession().getClient().isFeatureSupported(50) && !(success = FTPPath.this.parseMlsdResponse(children, FTPPath.this.getSession().getClient().list(51)))) {
                                    FTPPath.this.getSession().setMlsdListSupportedEnabled(false);
                                }
                                if (!success) {
                                    if (FTPPath.this.getSession().isExtendedListEnabled()) {
                                        success = FTPPath.this.parseListResponse(children, parser, FTPPath.this.getSession().getClient().list(26, "-a"));
                                    }
                                    if (!success) {
                                        FTPPath.this.getSession().setExtendedListEnabled(false);
                                        success = FTPPath.this.parseListResponse(children, parser, FTPPath.this.getSession().getClient().list(26));
                                    }
                                }
                                return success;
                            }
                        });
                    }
                    for (Path child : children) {
                        if (!child.attributes().isSymbolicLink()) continue;
                        if (this.getSession().getClient().changeWorkingDirectory(child.getAbsolute())) {
                            child.attributes().setType(6);
                            continue;
                        }
                        if (this.getSession().getClient().changeWorkingDirectory(child.getSymlinkTarget().getAbsolute())) {
                            child.attributes().setType(6);
                            continue;
                        }
                        child.attributes().setType(5);
                    }
                    if (success) {
                        this.getSession().setWorkdir(this);
                    } else {
                        log.error((Object)"No compatible file listing method found");
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (!this.cache().isEmpty()) break block18;
                    this.error(e.getMessage(), e);
                }
            }
        }
        return children;
    }

    protected Map<String, Map<String, String>> parseFacts(String[] response) {
        HashMap<String, Map<String, String>> files = new HashMap<String, Map<String, String>>();
        for (String line : response) {
            files.putAll(this.parseFacts(line));
        }
        return files;
    }

    protected Map<String, Map<String, String>> parseFacts(String line) {
        Pattern p = Pattern.compile("\\s?(\\S+\\=\\S+;)*\\s(.*)");
        Matcher result = p.matcher(line);
        HashMap<String, Map<String, String>> file = new HashMap<String, Map<String, String>>();
        if (result.matches()) {
            String filename = result.group(2);
            HashMap<String, String> facts = new HashMap<String, String>();
            for (String fact : result.group(1).split(";")) {
                String value;
                String key = StringUtils.substringBefore((String)fact, (String)"=");
                if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)(value = StringUtils.substringAfter((String)fact, (String)"=")))) continue;
                facts.put(key.toLowerCase(), value);
            }
            file.put(filename, facts);
            return file;
        }
        log.warn((Object)("No match for " + line));
        return null;
    }

    protected boolean parseMlsdResponse(AttributedList<Path> children, List<String> replies) throws IOException {
        if (null == replies) {
            return false;
        }
        boolean success = false;
        for (String line : replies) {
            Map<String, Map<String, String>> file = this.parseFacts(line);
            if (null == file) {
                log.error((Object)("Error parsing line:" + line));
                continue;
            }
            block3: for (String name : file.keySet()) {
                Path parsed = PathFactory.createPath(this.getSession(), this.getAbsolute(), StringUtils.removeStart((String)name, (String)(this.getAbsolute() + '/')), 1);
                parsed.setParent(this);
                for (Map<String, String> facts : file.values()) {
                    if (!facts.containsKey("type")) {
                        log.error((Object)("No type fact:" + line));
                        continue;
                    }
                    if ("dir".equals(facts.get("type").toLowerCase())) {
                        parsed.attributes().setType(2);
                    } else if ("file".equals(facts.get("type").toLowerCase())) {
                        parsed.attributes().setType(1);
                    } else {
                        log.warn((Object)("Ignored type: " + line));
                        continue block3;
                    }
                    if (name.contains(String.valueOf('/')) && !name.startsWith(this.getAbsolute() + '/')) {
                        log.warn((Object)("Skip listing entry with delimiter:" + name));
                        continue;
                    }
                    if (!success) {
                        if ("dir".equals(facts.get("type").toLowerCase()) && this.getName().equals(name)) {
                            log.warn((Object)("Possibly bogus response:" + line));
                        } else {
                            success = true;
                        }
                    }
                    if (facts.containsKey("sizd")) {
                        parsed.attributes().setSize(Long.parseLong(facts.get("sizd")));
                    }
                    if (facts.containsKey("size")) {
                        parsed.attributes().setSize(Long.parseLong(facts.get("size")));
                    }
                    if (facts.containsKey("unix.uid")) {
                        parsed.attributes().setOwner(facts.get("unix.uid"));
                    }
                    if (facts.containsKey("unix.owner")) {
                        parsed.attributes().setOwner(facts.get("unix.owner"));
                    }
                    if (facts.containsKey("unix.gid")) {
                        parsed.attributes().setGroup(facts.get("unix.gid"));
                    }
                    if (facts.containsKey("unix.group")) {
                        parsed.attributes().setGroup(facts.get("unix.group"));
                    }
                    if (facts.containsKey("unix.mode")) {
                        try {
                            parsed.attributes().setPermission(new Permission(Integer.parseInt(facts.get("unix.mode"))));
                        }
                        catch (NumberFormatException e) {
                            log.error((Object)("Failed to parse fact:" + facts.get("unix.mode")));
                        }
                    }
                    if (facts.containsKey("modify")) {
                        parsed.attributes().setModificationDate(this.parseTimestamp(facts.get("modify")));
                    }
                    if (facts.containsKey("create")) {
                        parsed.attributes().setCreationDate(this.parseTimestamp(facts.get("create")));
                    }
                    if (facts.containsKey("charset") && !facts.get("charset").toLowerCase().equals(this.getSession().getEncoding().toLowerCase())) {
                        log.error((Object)("Incompatible charset " + facts.get("charset") + " but session is configured with " + this.getSession().getEncoding()));
                    }
                    children.add(parsed);
                }
            }
        }
        return success;
    }

    protected boolean parseListResponse(AttributedList<Path> children, FTPFileEntryParser parser, List<String> replies) throws IOException {
        if (null == replies) {
            return false;
        }
        boolean success = false;
        for (String line : replies) {
            Calendar timestamp;
            FTPFile f = parser.parseFTPEntry(line);
            if (null == f) continue;
            String name = f.getName();
            if (!success) {
                if (this.getAbsolute().equals(name)) continue;
                if (name.contains(String.valueOf('/')) && !name.startsWith(this.getAbsolute() + '/')) {
                    log.warn((Object)("Skip listing entry with delimiter:" + name));
                    continue;
                }
            }
            success = true;
            if (name.equals(".") || name.equals("..")) continue;
            Path parsed = PathFactory.createPath(this.getSession(), this.getAbsolute(), StringUtils.removeStart((String)name, (String)(this.getAbsolute() + '/')), f.getType() == 1 ? 2 : 1);
            parsed.setParent(this);
            switch (f.getType()) {
                case 2: {
                    parsed.setSymlinkTarget(f.getLink());
                    parsed.attributes().setType(5);
                }
            }
            parsed.attributes().setSize(f.getSize());
            parsed.attributes().setOwner(f.getUser());
            parsed.attributes().setGroup(f.getGroup());
            if (this.getSession().isPermissionSupported(parser)) {
                parsed.attributes().setPermission(new Permission(new boolean[][]{{f.hasPermission(0, 0), f.hasPermission(0, 1), f.hasPermission(0, 2)}, {f.hasPermission(1, 0), f.hasPermission(1, 1), f.hasPermission(1, 2)}, {f.hasPermission(2, 0), f.hasPermission(2, 1), f.hasPermission(2, 2)}}));
            }
            if ((timestamp = f.getTimestamp()) != null) {
                parsed.attributes().setModificationDate(timestamp.getTimeInMillis());
            }
            children.add(parsed);
        }
        return success;
    }

    @Override
    public void mkdir() {
        if (this.attributes().isDirectory()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Making directory {0}", "Status"), this.getName()));
                if (this.getSession().getClient().makeDirectory(this.getAbsolute())) {
                    if (Preferences.instance().getBoolean("queue.upload.changePermissions") && Preferences.instance().getBoolean("queue.upload.permissions.useDefault")) {
                        this.writeUnixPermissionImpl(new Permission(Preferences.instance().getInteger("queue.upload.permissions.folder.default")), false);
                    }
                } else {
                    throw new FTPException(this.getSession().getClient().getReplyString());
                }
                this.cache().put(this.getReference(), AttributedList.emptyList());
                this.getParent().invalidate();
            }
            catch (IOException e) {
                this.error("Cannot create folder {0}", e);
            }
        }
    }

    @Override
    public void rename(AbstractPath renamed) {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Renaming {0} to {1}", "Status"), this.getName(), renamed));
            if (!this.getSession().getClient().rename(this.getAbsolute(), renamed.getAbsolute())) {
                throw new FTPException(this.getSession().getClient().getReplyString());
            }
            renamed.getParent().invalidate();
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot rename {0}", e);
        }
    }

    @Override
    public void readSize() {
        if (this.attributes().isFile()) {
            try {
                AttributedList l;
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
                if (this.getSession().getClient().isFeatureSupported(52)) {
                    if (!this.getSession().getClient().setFileType(2)) {
                        throw new FTPException(this.getSession().getClient().getReplyString());
                    }
                    this.attributes().setSize(this.getSession().getClient().getSize(this.getAbsolute()));
                }
                if (-1L == this.attributes().getSize() && (l = this.getParent().children()).contains(this.getReference())) {
                    this.attributes().setSize(((AbstractPath)l.get(this.getReference())).attributes().getSize());
                }
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    public long parseTimestamp(String timestamp) {
        if (null == timestamp) {
            return -1L;
        }
        try {
            Date parsed = this.tsFormatSeconds.parse(timestamp);
            return parsed.getTime();
        }
        catch (ParseException e) {
            log.warn((Object)("Failed to parse timestamp:" + e.getMessage()));
            try {
                Date parsed = this.tsFormatMilliseconds.parse(timestamp);
                return parsed.getTime();
            }
            catch (ParseException f) {
                log.warn((Object)("Failed to parse timestamp:" + f.getMessage()));
                log.error((Object)("Failed to parse timestamp:" + timestamp));
                return -1L;
            }
        }
    }

    @Override
    public void readTimestamp() {
        if (this.attributes().isFile()) {
            try {
                AttributedList l;
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
                if (this.getSession().getClient().isFeatureSupported(33)) {
                    this.attributes().setModificationDate(this.parseTimestamp(this.getSession().getClient().getModificationTime(this.getAbsolute())));
                }
                if (-1L == this.attributes().getModificationDate() && (l = this.getParent().children()).contains(this.getReference())) {
                    this.attributes().setModificationDate(((AbstractPath)l.get(this.getReference())).attributes().getModificationDate());
                }
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    @Override
    public void readUnixPermission() {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Getting permission of {0}", "Status"), this.getName()));
            AttributedList l = this.getParent().children();
            if (l.contains(this.getReference())) {
                this.attributes().setPermission(((AbstractPath)l.get(this.getReference())).attributes().getPermission());
            }
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void delete() {
        try {
            this.getSession().check();
            if (this.attributes().isFile() || this.attributes().isSymbolicLink()) {
                this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                if (!this.getSession().getClient().deleteFile(this.getAbsolute())) {
                    throw new FTPException(this.getSession().getClient().getReplyString());
                }
            } else if (this.attributes().isDirectory()) {
                for (AbstractPath file : this.children()) {
                    if (!this.getSession().isConnected()) break;
                    if (file.attributes().isFile() || file.attributes().isSymbolicLink()) {
                        this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), file.getName()));
                        if (this.getSession().getClient().deleteFile(file.getAbsolute())) continue;
                        throw new FTPException(this.getSession().getClient().getReplyString());
                    }
                    if (!file.attributes().isDirectory()) continue;
                    file.delete();
                }
                this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                if (!this.getSession().getClient().removeDirectory(this.getAbsolute())) {
                    throw new FTPException(this.getSession().getClient().getReplyString());
                }
            }
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot delete {0}", e);
        }
    }

    @Override
    public void writeOwner(String owner, boolean recursive) {
        block7: {
            String command = "chown";
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Changing owner of {0} to {1}", "Status"), this.getName(), owner));
                if (this.attributes().isFile() && !this.attributes().isSymbolicLink()) {
                    if (!this.getSession().getClient().sendSiteCommand(command + " " + owner + " " + this.getAbsolute())) {
                        throw new FTPException(this.getSession().getClient().getReplyString());
                    }
                    break block7;
                }
                if (!this.attributes().isDirectory()) break block7;
                if (!this.getSession().getClient().sendSiteCommand(command + " " + owner + " " + this.getAbsolute())) {
                    throw new FTPException(this.getSession().getClient().getReplyString());
                }
                if (!recursive) break block7;
                for (AbstractPath child : this.children()) {
                    if (this.getSession().isConnected()) {
                        ((Path)child).writeOwner(owner, recursive);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.error("Cannot change owner", e);
            }
        }
    }

    @Override
    public void writeGroup(String group, boolean recursive) {
        block7: {
            String command = "chgrp";
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Changing group of {0} to {1}", "Status"), this.getName(), group));
                if (this.attributes().isFile() && !this.attributes().isSymbolicLink()) {
                    if (!this.getSession().getClient().sendSiteCommand(command + " " + group + " " + this.getAbsolute())) {
                        throw new FTPException(this.getSession().getClient().getReplyString());
                    }
                    break block7;
                }
                if (!this.attributes().isDirectory()) break block7;
                if (!this.getSession().getClient().sendSiteCommand(command + " " + group + " " + this.getAbsolute())) {
                    throw new FTPException(this.getSession().getClient().getReplyString());
                }
                if (!recursive) break block7;
                for (AbstractPath child : this.children()) {
                    if (this.getSession().isConnected()) {
                        ((Path)child).writeGroup(group, recursive);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.error("Cannot change group", e);
            }
        }
    }

    @Override
    public void writeUnixPermission(Permission perm, boolean recursive) {
        try {
            this.getSession().check();
            this.writeUnixPermissionImpl(perm, recursive);
        }
        catch (IOException e) {
            this.error("Cannot change permissions", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnixPermissionImpl(Permission perm, boolean recursive) throws IOException {
        if (this.chmodSupported) {
            this.getSession().message(MessageFormat.format(Locale.localizedString("Changing permission of {0} to {1}", "Status"), this.getName(), perm.getOctalString()));
            try {
                if (this.attributes().isFile() && !this.attributes().isSymbolicLink()) {
                    if (this.getSession().getClient().sendSiteCommand("CHMOD " + perm.getOctalString() + " " + this.getAbsolute())) {
                        this.attributes().setPermission(perm);
                    } else {
                        this.chmodSupported = false;
                    }
                } else if (this.attributes().isDirectory()) {
                    if (this.getSession().getClient().sendSiteCommand("CHMOD " + perm.getOctalString() + " " + this.getAbsolute())) {
                        this.attributes().setPermission(perm);
                    } else {
                        this.chmodSupported = false;
                    }
                    if (recursive) {
                        for (AbstractPath child : this.children()) {
                            if (!this.getSession().isConnected()) break;
                            ((FTPPath)child).writeUnixPermissionImpl(perm, recursive);
                        }
                    }
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
    }

    @Override
    public void writeTimestamp(long created, long modified, long accessed) {
        try {
            this.writeModificationDateImpl(created, modified);
        }
        catch (IOException e) {
            this.error("Cannot change timestamp", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeModificationDateImpl(long created, long modified) throws IOException {
        this.getSession().message(MessageFormat.format(Locale.localizedString("Changing timestamp of {0} to {1}", "Status"), this.getName(), DateFormatterFactory.instance().getShortFormat(modified)));
        try {
            if (this.getSession().getClient().isFeatureSupported(35)) {
                if (this.getSession().getClient().setModificationTime(this.getAbsolute(), this.tsFormatSeconds.format(modified))) {
                    this.attributes().setModificationDate(modified);
                }
            } else if (this.getSession().isUtimeSupported()) {
                if (this.getSession().getClient().sendSiteCommand("UTIME " + this.getAbsolute() + " " + this.tsFormatSeconds.format(new Date(modified)) + " " + this.tsFormatSeconds.format(new Date(modified)) + " " + this.tsFormatSeconds.format(new Date(created)) + " UTC")) {
                    this.attributes().setModificationDate(modified);
                    this.attributes().setCreationDate(created);
                } else {
                    this.getSession().setUtimeSupported(false);
                    log.warn((Object)"UTIME not supported");
                }
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            throw throwable;
        }
    }

    @Override
    protected void download(final BandwidthThrottle throttle, final StreamListener listener, boolean check) {
        if (this.attributes().isFile()) {
            try {
                if (check) {
                    this.getSession().check();
                }
                this.data(new DataConnectionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean run() throws IOException {
                        InputStream in = null;
                        OutputStream out = null;
                        try {
                            if (!FTPPath.this.getSession().getClient().setFileType(2)) {
                                throw new FTPException(FTPPath.this.getSession().getClient().getReplyString());
                            }
                            if (FTPPath.this.status().isResume()) {
                                if (!FTPPath.this.getSession().getClient().isFeatureSupported("REST STREAM")) {
                                    FTPPath.this.status().setResume(false);
                                } else {
                                    FTPPath.this.getSession().getClient().setRestartOffset(FTPPath.this.status().isResume() ? FTPPath.this.getLocal().attributes().getSize() : 0L);
                                }
                            }
                            in = FTPPath.this.getSession().getClient().retrieveFileStream(FTPPath.this.getAbsolute());
                            out = FTPPath.this.getLocal().getOutputStream(FTPPath.this.status().isResume());
                            try {
                                FTPPath.this.download(in, out, throttle, listener);
                            }
                            catch (ConnectionCanceledException e) {
                                IOUtils.closeQuietly((InputStream)in);
                                IOUtils.closeQuietly((OutputStream)out);
                                if (!FTPPath.this.getSession().getClient().abort()) {
                                    log.error((Object)("Interrupting file transfer failed:" + FTPPath.this.getSession().getClient().getReplyString()));
                                }
                                FTPPath.this.status().setComplete(false);
                                throw e;
                            }
                            if (FTPPath.this.status().isComplete()) {
                                IOUtils.closeQuietly((InputStream)in);
                                IOUtils.closeQuietly((OutputStream)out);
                                if (!FTPPath.this.getSession().getClient().completePendingCommand()) {
                                    FTPPath.this.status().setComplete(false);
                                    throw new FTPException(FTPPath.this.getSession().getClient().getReplyString());
                                }
                            }
                            Object var5_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            IOUtils.closeQuietly(in);
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly((OutputStream)out);
                        return true;
                    }
                });
            }
            catch (IOException e) {
                this.error("Download failed", e);
            }
        }
    }

    @Override
    protected void upload(final BandwidthThrottle throttle, final StreamListener listener, boolean check) {
        if (this.attributes().isFile()) {
            try {
                if (check) {
                    this.getSession().check();
                }
                this.data(new DataConnectionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean run() throws IOException {
                        InputStream in = null;
                        OutputStream out = null;
                        try {
                            if (!FTPPath.this.getSession().getClient().setFileType(2)) {
                                throw new FTPException(FTPPath.this.getSession().getClient().getReplyString());
                            }
                            in = FTPPath.this.getLocal().getInputStream();
                            out = FTPPath.this.status().isResume() ? FTPPath.this.getSession().getClient().appendFileStream(FTPPath.this.getAbsolute()) : FTPPath.this.getSession().getClient().storeFileStream(FTPPath.this.getAbsolute());
                            try {
                                FTPPath.this.upload(out, in, throttle, listener);
                            }
                            catch (ConnectionCanceledException e) {
                                IOUtils.closeQuietly((InputStream)in);
                                IOUtils.closeQuietly((OutputStream)out);
                                if (!FTPPath.this.getSession().getClient().abort()) {
                                    log.error((Object)("Interrupting file transfer failed:" + FTPPath.this.getSession().getClient().getReplyString()));
                                }
                                FTPPath.this.status().setComplete(false);
                                throw e;
                            }
                            if (FTPPath.this.status().isComplete()) {
                                IOUtils.closeQuietly((InputStream)in);
                                IOUtils.closeQuietly((OutputStream)out);
                                if (!FTPPath.this.getSession().getClient().completePendingCommand()) {
                                    FTPPath.this.status().setComplete(false);
                                    throw new FTPException(FTPPath.this.getSession().getClient().getReplyString());
                                }
                            }
                            Object var5_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            IOUtils.closeQuietly(in);
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly((OutputStream)out);
                        return true;
                    }
                });
            }
            catch (IOException e) {
                this.error("Upload failed", e);
            }
        }
    }

    private static abstract class DataConnectionAction {
        private DataConnectionAction() {
        }

        public abstract boolean run() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<FTPSession> {
        private Factory() {
        }

        @Override
        protected Path create(FTPSession session, String path, int type) {
            return new FTPPath(session, path, type);
        }

        @Override
        protected Path create(FTPSession session, String parent, String name, int type) {
            return new FTPPath(session, parent, name, type);
        }

        @Override
        protected Path create(FTPSession session, String parent, Local file) {
            return new FTPPath(session, parent, file);
        }

        @Override
        protected <T> Path create(FTPSession session, T dict) {
            return new FTPPath(session, dict);
        }
    }
}

