/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp.parser;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;
import org.apache.commons.net.ftp.parser.FTPTimestampParserImpl;
import org.apache.log4j.Logger;

public abstract class CommonUnixFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    private static Logger log = Logger.getLogger(CommonUnixFTPEntryParser.class);

    public CommonUnixFTPEntryParser(String regex) {
        super(regex);
    }

    public Calendar parseTimestamp(String timestampStr) throws ParseException {
        try {
            return super.parseTimestamp(timestampStr);
        }
        catch (ParseException e) {
            return new FTPTimestampParserImpl(){

                public Calendar parseTimestamp(String timestampStr) throws ParseException {
                    Calendar working = Calendar.getInstance();
                    working.setTimeZone(this.getServerTimeZone());
                    int year = Calendar.getInstance().get(1);
                    String timeStampStrPlusYear = timestampStr + " " + year;
                    SimpleDateFormat hackFormatter = new SimpleDateFormat(this.getRecentDateFormat().toPattern() + " yyyy", this.getRecentDateFormat().getDateFormatSymbols());
                    hackFormatter.setLenient(false);
                    hackFormatter.setTimeZone(this.getRecentDateFormat().getTimeZone());
                    ParsePosition pp = new ParsePosition(0);
                    Date parsed = hackFormatter.parse(timeStampStrPlusYear, pp);
                    if (parsed == null || pp.getIndex() != timestampStr.length() + 5) {
                        throw new ParseException("Timestamp could not be parsed:" + timestampStr, pp.getIndex());
                    }
                    working.setTime(parsed);
                    return working;
                }
            }.parseTimestamp(timestampStr);
        }
    }

    protected FTPClientConfig getDefaultConfiguration() {
        FTPClientConfig config = new FTPClientConfig("UNIX", "MMM d yyyy", "MMM d HH:mm", null, null, null);
        config.setLenientFutureDates(true);
        return config;
    }

    protected FTPFile parseFTPEntry(String typeStr, String usr, String grp, String filesize, String datestr, String name, String endtoken) {
        try {
            return this.parseFTPEntry(typeStr, usr, grp, Long.parseLong(filesize), datestr, name, endtoken);
        }
        catch (NumberFormatException e) {
            return this.parseFTPEntry(typeStr, usr, grp, -1L, datestr, name, endtoken);
        }
    }

    protected FTPFile parseFTPEntry(String typeStr, String usr, String grp, long filesize, String datestr, String name, String endtoken) {
        int type;
        FTPFile file = new FTPFile();
        try {
            file.setTimestamp(this.parseTimestamp(datestr));
        }
        catch (ParseException e) {
            log.warn((Object)e.getMessage());
        }
        switch (typeStr.charAt(0)) {
            case 'd': {
                type = 1;
                break;
            }
            case 'l': {
                type = 2;
                break;
            }
            case '-': 
            case 'b': 
            case 'c': 
            case 'f': {
                type = 0;
                break;
            }
            default: {
                type = 3;
            }
        }
        file.setType(type);
        file.setUser(usr);
        file.setGroup(grp);
        int g = 4;
        int access = 0;
        while (access < 3) {
            file.setPermission(access, 0, !this.group(g).equals("-"));
            file.setPermission(access, 1, !this.group(g + 1).equals("-"));
            String execPerm = this.group(g + 2);
            if (!execPerm.equals("-") && !Character.isUpperCase(execPerm.charAt(0))) {
                file.setPermission(access, 2, true);
            } else {
                file.setPermission(access, 2, false);
            }
            ++access;
            g += 4;
        }
        file.setSize(filesize);
        if (null == endtoken) {
            file.setName(name);
        } else {
            name = name + endtoken;
            if (type == 2) {
                int end = name.indexOf(" -> ");
                if (end == -1) {
                    file.setName(name);
                } else {
                    file.setName(name.substring(0, end));
                    file.setLink(name.substring(end + 4));
                }
            } else {
                file.setName(name);
            }
        }
        return file;
    }
}

