/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.gdocs;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.gdocs.GDSession;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.threading.ThreadPool;
import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.DocumentQuery;
import com.google.gdata.client.GoogleAuthTokenFactory;
import com.google.gdata.client.Query;
import com.google.gdata.client.Service;
import com.google.gdata.client.http.HttpGDataRequest;
import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.Content;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.Link;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.OutOfLineContent;
import com.google.gdata.data.Person;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.acl.AclEntry;
import com.google.gdata.data.acl.AclFeed;
import com.google.gdata.data.acl.AclRole;
import com.google.gdata.data.acl.AclScope;
import com.google.gdata.data.docs.DocumentEntry;
import com.google.gdata.data.docs.DocumentListEntry;
import com.google.gdata.data.docs.DocumentListFeed;
import com.google.gdata.data.docs.FolderEntry;
import com.google.gdata.data.docs.RevisionEntry;
import com.google.gdata.data.docs.RevisionFeed;
import com.google.gdata.data.media.IMediaContent;
import com.google.gdata.data.media.MediaMultipart;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.media.MediaStreamSource;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ErrorContent;
import com.google.gdata.util.NotImplementedException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.mail.MessagingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDPath
extends Path {
    private static Logger log = Logger.getLogger(GDPath.class);
    private final GDSession session;
    private static final String DOCUMENT_FILE_TYPE = "file";
    private String documentType;
    private String exportUri;
    private String resourceId;
    private String documentUri;

    public static PathFactory factory() {
        return new Factory();
    }

    @Override
    protected void init(Deserializer dict) {
        String documentTypeObj;
        String exportUriObj;
        String resourceIdObj = dict.stringForKey("ResourceId");
        if (resourceIdObj != null) {
            this.setResourceId(resourceIdObj);
        }
        if ((exportUriObj = dict.stringForKey("ExportUri")) != null) {
            this.setExportUri(exportUriObj);
        }
        if ((documentTypeObj = dict.stringForKey("DocumentType")) != null) {
            this.setDocumentType(documentTypeObj);
        }
        super.init(dict);
    }

    @Override
    protected <S> S getAsDictionary(Serializer dict) {
        if (this.resourceId != null) {
            dict.setStringForKey(this.resourceId, "ResourceId");
        }
        if (this.exportUri != null) {
            dict.setStringForKey(this.exportUri, "ExportUri");
        }
        if (this.documentType != null) {
            dict.setStringForKey(this.documentType, "DocumentType");
        }
        return super.getAsDictionary(dict);
    }

    protected GDPath(GDSession s, String parent, String name, int type) {
        super(parent, name, type);
        this.session = s;
    }

    protected GDPath(GDSession s, String path, int type) {
        super(path, type);
        this.session = s;
    }

    protected GDPath(GDSession s, String parent, Local file) {
        super(parent, file);
        this.session = s;
    }

    protected <T> GDPath(GDSession s, T dict) {
        super(dict);
        this.session = s;
    }

    public String getDocumentType() {
        if (null == this.documentType) {
            if (this.attributes().isDirectory()) {
                return "folder";
            }
            return DOCUMENT_FILE_TYPE;
        }
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getExportUri() {
        if (StringUtils.isBlank((String)this.exportUri)) {
            log.warn((Object)("Refetching Export URI for " + this.toString()));
            AttributedList l = this.getParent().children();
            if (l.contains(this.getReference())) {
                this.exportUri = ((GDPath)l.get(this.getReference())).getExportUri();
            } else {
                log.error((Object)("Missing Export URI for " + this.toString()));
            }
        }
        return this.exportUri;
    }

    public void setExportUri(String exportUri) {
        this.exportUri = exportUri;
    }

    public String getResourceId() {
        if (StringUtils.isBlank((String)this.resourceId)) {
            log.warn((Object)("Refetching Resource ID for " + this.toString()));
            AttributedList l = this.getParent().children();
            if (l.contains(this.getReference())) {
                this.resourceId = ((GDPath)l.get(this.getReference())).getResourceId();
            } else {
                log.error((Object)("Missing Resource ID for " + this.toString()));
            }
        }
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getDocumentUri() {
        return this.documentUri;
    }

    public void setDocumentUri(String documentUri) {
        this.documentUri = documentUri;
    }

    private String getDocumentId() {
        return StringUtils.removeStart((String)this.getResourceId(), (String)(this.getDocumentType() + ":"));
    }

    protected StringBuilder getPrivateFeed() {
        StringBuilder feed = this.getHostUrl();
        feed.append("/feeds/default/private/full/");
        return feed;
    }

    private StringBuilder getHostUrl() {
        StringBuilder feed = new StringBuilder(this.getSession().getHost().getProtocol().getScheme()).append("://");
        feed.append(this.getSession().getHost().getHostname());
        return feed;
    }

    protected String getResourceFeed() throws MalformedURLException {
        return this.getPrivateFeed().append(this.getResourceId()).toString();
    }

    protected String getMediaFeed() throws MalformedURLException {
        return this.getHostUrl().append("/feeds/default/media/document%3A").append(this.getDocumentId()).toString();
    }

    protected String getFolderFeed() throws MalformedURLException {
        StringBuilder feed = this.getPrivateFeed();
        if (this.isRoot()) {
            return feed.append("folder%3Aroot/contents").toString();
        }
        return feed.append("folder%3A").append(this.getDocumentId()).append("/contents").toString();
    }

    protected String getAclFeed() throws MalformedURLException {
        StringBuilder feed = new StringBuilder(this.getResourceFeed());
        return feed.append("/acl").toString();
    }

    public String getRevisionsFeed() throws MalformedURLException {
        StringBuilder feed = new StringBuilder(this.getResourceFeed());
        return feed.append("/revisions").toString();
    }

    @Override
    public void readSize() {
    }

    @Override
    public void readTimestamp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readAcl() {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Getting permission of {0}", "Status"), this.getName()));
            Acl acl = new Acl();
            AclFeed feed = (AclFeed)this.getSession().getClient().getFeed(new URL(this.getAclFeed()), AclFeed.class);
            for (AclEntry entry : feed.getEntries()) {
                AclScope scope = entry.getScope();
                AclScope.Type type = scope.getType();
                AclRole role = entry.getRole();
                if (type.equals((Object)AclScope.Type.USER)) {
                    boolean editable = !role.getValue().equals(AclRole.OWNER.getValue());
                    acl.addAll(new Acl.EmailUser(scope.getValue(), editable), new Acl.Role(role.getValue(), editable));
                    continue;
                }
                if (type.equals((Object)AclScope.Type.DOMAIN)) {
                    acl.addAll(new Acl.DomainUser(scope.getValue()), new Acl.Role(role.getValue()));
                    continue;
                }
                if (type.equals((Object)AclScope.Type.GROUP)) {
                    acl.addAll(new Acl.GroupUser(scope.getValue(), true), new Acl.Role(role.getValue()));
                    continue;
                }
                if (type.equals((Object)AclScope.Type.DEFAULT)) {
                    acl.addAll(new Acl.CanonicalUser(AclScope.Type.DEFAULT.name(), Locale.localizedString("Public"), false), new Acl.Role(role.getValue()));
                    continue;
                }
                log.warn((Object)("Unsupported scope:" + type));
            }
            this.attributes().setAcl(acl);
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
        catch (ServiceException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAcl(Acl acl, boolean recursive) {
        try {
            try {
                AclFeed feed = (AclFeed)this.getSession().getClient().getFeed(new URL(this.getAclFeed()), AclFeed.class);
                for (AclEntry entry : feed.getEntries()) {
                    if (entry.getRole().toString().equals(AclRole.OWNER.toString())) continue;
                    entry.delete();
                }
                for (Acl.User user : acl.keySet()) {
                    if (!user.isValid() || !user.isEditable()) continue;
                    AclScope scope = null;
                    if (user instanceof Acl.EmailUser) {
                        scope = new AclScope(AclScope.Type.USER, user.getIdentifier());
                    } else if (user instanceof Acl.GroupUser) {
                        scope = new AclScope(AclScope.Type.GROUP, user.getIdentifier());
                    } else if (user instanceof Acl.DomainUser) {
                        scope = new AclScope(AclScope.Type.DOMAIN, user.getIdentifier());
                    } else if (user instanceof Acl.CanonicalUser && user.getIdentifier().equals(AclScope.Type.DEFAULT.name())) {
                        scope = new AclScope(AclScope.Type.DEFAULT, null);
                    }
                    if (null == scope) {
                        log.warn((Object)("Unsupported scope:" + user));
                        continue;
                    }
                    for (Acl.Role role : (Set)acl.get(user)) {
                        if (!role.isValid()) continue;
                        AclEntry entry = new AclEntry();
                        entry.setScope(scope);
                        entry.setRole(new AclRole(role.getName()));
                        this.getSession().getClient().insert(new URL(this.getAclFeed()), (IEntry)entry);
                    }
                }
                Object var11_12 = null;
                this.attributes().clear(false, false, true, false);
            }
            catch (IOException e) {
                this.error("Cannot change permissions", e);
                Object var11_13 = null;
                this.attributes().clear(false, false, true, false);
            }
            catch (ServiceException e) {
                this.error("Cannot change permissions", e);
                Object var11_14 = null;
                this.attributes().clear(false, false, true, false);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.attributes().clear(false, false, true, false);
            throw throwable;
        }
        if (!this.attributes().isDirectory() || recursive) {
            // empty if block
        }
    }

    @Override
    public GDSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        if (!this.attributes().isFile()) return;
        OutputStream out = null;
        InputStream in = null;
        try {
            try {
                if (check) {
                    this.getSession().check();
                }
                MediaContent mc = new MediaContent();
                StringBuilder uri = new StringBuilder(this.getExportUri());
                String type = this.getDocumentType();
                GoogleAuthTokenFactory.UserToken token = (GoogleAuthTokenFactory.UserToken)this.getSession().getClient().getAuthTokenFactory().getAuthToken();
                try {
                    if (type.equals("spreadsheet")) {
                        SpreadsheetService spreadsheet = new SpreadsheetService(this.getSession().getUserAgent());
                        Credentials credentials = this.getSession().getHost().getCredentials();
                        spreadsheet.setUserCredentials(credentials.getUsername(), credentials.getPassword());
                        this.getSession().getClient().setUserToken(((GoogleAuthTokenFactory.UserToken)spreadsheet.getAuthTokenFactory().getAuthToken()).getValue());
                    }
                    if (StringUtils.isNotEmpty((String)GDPath.getExportFormat(type))) {
                        uri.append("&exportFormat=").append(GDPath.getExportFormat(type));
                    }
                    mc.setUri(uri.toString());
                    MediaSource ms = this.getSession().getClient().getMedia((IMediaContent)mc);
                    in = ms.getInputStream();
                    if (null == in) {
                        throw new IOException("Unable opening data stream");
                    }
                    out = this.getLocal().getOutputStream(this.status().isResume());
                    this.download(in, out, throttle, listener);
                    Object var13_14 = null;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    this.getSession().getClient().setUserToken(token.getValue());
                    throw throwable;
                }
                this.getSession().getClient().setUserToken(token.getValue());
                Object var15_17 = null;
            }
            catch (IOException e) {
                this.error("Download failed", e);
                Object var15_18 = null;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                return;
            }
            catch (ServiceException e) {
                this.error("Download failed", e);
                Object var15_19 = null;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void upload(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        try {
            if (!this.attributes().isFile()) return;
            if (check) {
                this.getSession().check();
            }
            PipedInputStream in = null;
            OutputStream out = null;
            try {
                block17: {
                    DocumentListEntry document;
                    String mime = this.getLocal().getMimeType();
                    MediaStreamSource source = new MediaStreamSource(this.getLocal().getInputStream(), mime, new DateTime(this.attributes().getModificationDate()), this.getLocal().attributes().getSize());
                    MediaContent content = new MediaContent();
                    content.setMediaSource((MediaSource)source);
                    content.setMimeType(new ContentType(mime));
                    content.setLength(this.getLocal().attributes().getSize());
                    if (this.exists()) {
                        URL url = new URL(this.getResourceFeed());
                        document = (DocumentListEntry)this.getSession().getClient().getEntry(url, DocumentListEntry.class);
                        this.setDocumentType(document.getType());
                    } else {
                        document = new DocumentListEntry();
                        document.setTitle((TextConstruct)new PlainTextConstruct(this.getName()));
                    }
                    document.setContent((Content)content);
                    this.status().setResume(false);
                    String feed = this.exists() ? this.getMediaFeed() : ((GDPath)this.getParent()).getFolderFeed();
                    StringBuilder url = new StringBuilder(feed);
                    url.append("?convert=").append(this.isConversionSupported() && Preferences.instance().getBoolean("google.docs.upload.convert"));
                    if (this.isOcrSupported()) {
                        url.append("&ocr=").append(Preferences.instance().getProperty("google.docs.upload.ocr"));
                    }
                    Service.GDataRequest request = null;
                    try {
                        try {
                            final MediaMultipart multipart = new MediaMultipart((IEntry)document, document.getMediaSource());
                            request = this.getSession().getClient().createRequest(this.exists() ? Service.GDataRequest.RequestType.UPDATE : Service.GDataRequest.RequestType.INSERT, new URL(url.toString()), new ContentType(multipart.getContentType()));
                            if (request instanceof HttpGDataRequest) {
                                ((HttpGDataRequest)request).getConnection().setChunkedStreamingMode(0);
                            }
                            if (this.exists()) {
                                request.setEtag(document.getEtag());
                            }
                            out = request.getRequestStream();
                            final PipedOutputStream pipe = new PipedOutputStream();
                            in = new PipedInputStream(pipe);
                            ThreadPool.instance().execute(new Runnable(){

                                public void run() {
                                    try {
                                        multipart.writeTo((OutputStream)pipe);
                                        pipe.flush();
                                        pipe.close();
                                    }
                                    catch (IOException e) {
                                        log.error((Object)e.getMessage());
                                    }
                                    catch (MessagingException e) {
                                        log.error((Object)e.getMessage());
                                    }
                                }
                            });
                            this.upload(out, in, throttle, listener);
                            try {
                                request.execute();
                            }
                            catch (ServiceException e) {
                                this.status().setComplete(false);
                                throw e;
                            }
                            Object var17_19 = null;
                            if (request == null) break block17;
                        }
                        catch (MessagingException e) {
                            throw new ServiceException((ErrorContent)CoreErrorDomain.ERR.cantWriteMimeMultipart, (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_20 = null;
                        if (request == null) throw throwable;
                        request.end();
                        throw throwable;
                    }
                    request.end();
                }
                Object var19_22 = null;
            }
            catch (Throwable throwable) {
                Object var19_23 = null;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            return;
        }
        catch (ServiceException e) {
            this.error("Upload failed", e);
            return;
        }
        catch (IOException e) {
            this.error("Upload failed", e);
        }
    }

    protected boolean isOcrSupported() {
        return this.getMimeType().equals("application/pdf") || this.getMimeType().equals("image/png") || this.getMimeType().equals("image/jpeg") || this.getMimeType().endsWith("image/gif");
    }

    protected boolean isConversionSupported() {
        return true;
    }

    @Override
    public AttributedList<Path> list(AttributedList<Path> children) {
        block5: {
            if (this.attributes().isDirectory()) {
                try {
                    this.getSession().check();
                    this.getSession().message(MessageFormat.format(Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
                    children.addAll(this.list(new DocumentQuery(new URL(this.getFolderFeed()))));
                    this.getSession().setWorkdir(this);
                }
                catch (ServiceException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (this.cache().isEmpty()) {
                        this.error(e.getMessage(), e);
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (!this.cache().isEmpty()) break block5;
                    this.error(e.getMessage(), e);
                }
            }
        }
        return children;
    }

    private AttributedList<Path> list(DocumentQuery query) throws ServiceException, IOException {
        Link next;
        AttributedList<Path> children = new AttributedList<Path>();
        DocumentListFeed pager = (DocumentListFeed)this.getSession().getClient().getFeed((Query)query, DocumentListFeed.class);
        do {
            for (DocumentListEntry entry : pager.getEntries()) {
                DateTime lastViewed;
                log.debug((Object)("Resource:" + entry.getResourceId()));
                String type = entry.getType();
                GDPath path = new GDPath(this.getSession(), this.getAbsolute(), entry.getTitle().getPlainText(), "folder".equals(type) ? 2 : 1);
                path.setParent(this);
                path.setDocumentType(type);
                path.setExportUri(((OutOfLineContent)entry.getContent()).getUri());
                path.setDocumentUri(entry.getDocumentLink().getHref());
                path.setResourceId(entry.getResourceId());
                path.attributes().setChecksum(entry.getEtag());
                if (null != entry.getMediaSource()) {
                    path.attributes().setSize(entry.getMediaSource().getContentLength());
                }
                if (entry.getQuotaBytesUsed() > 0L) {
                    path.attributes().setSize(entry.getQuotaBytesUsed());
                }
                if ((lastViewed = entry.getLastViewed()) != null) {
                    path.attributes().setAccessedDate(lastViewed.getValue());
                }
                for (Person person : entry.getAuthors()) {
                    path.attributes().setOwner(person.getEmail());
                }
                DateTime updated = entry.getUpdated();
                if (updated != null) {
                    path.attributes().setModificationDate(updated.getValue());
                }
                if (children.contains(path.getReference())) {
                    path.attributes().setDuplicate(true);
                    path.setReference(null);
                }
                children.add(path);
                if (!path.attributes().isFile() || !Preferences.instance().getBoolean("google.docs.revisions.enable")) continue;
                try {
                    List revisions = ((RevisionFeed)this.getSession().getClient().getFeed(new URL(path.getRevisionsFeed()), RevisionFeed.class)).getEntries();
                    Collections.sort(revisions, new Comparator<RevisionEntry>(){

                        @Override
                        public int compare(RevisionEntry o1, RevisionEntry o2) {
                            return o1.getUpdated().compareTo((Object)o2.getUpdated());
                        }
                    });
                    int i = 0;
                    for (RevisionEntry revisionEntry : revisions) {
                        GDPath revision = new GDPath(this.getSession(), revisionEntry.getTitle().getPlainText(), "folder".equals(type) ? 2 : 1);
                        revision.setParent(this);
                        revision.setDocumentType(type);
                        revision.setExportUri(((OutOfLineContent)revisionEntry.getContent()).getUri());
                        long size = ((OutOfLineContent)revisionEntry.getContent()).getLength();
                        if (size > 0L) {
                            revision.attributes().setSize(size);
                        }
                        revision.attributes().setOwner(revisionEntry.getModifyingUser().getName());
                        revision.attributes().setModificationDate(revisionEntry.getUpdated().getValue());
                        revision.attributes().setVersionId(revisionEntry.getVersionId());
                        revision.attributes().setChecksum(revisionEntry.getEtag());
                        revision.attributes().setRevision(++i);
                        revision.attributes().setDuplicate(true);
                        children.add(revision);
                    }
                }
                catch (NotImplementedException e) {
                    log.error((Object)("No revisions available:" + e.getMessage()));
                }
            }
        } while (null != (next = pager.getNextLink()) && (pager = (DocumentListFeed)this.getSession().getClient().getFeed(new URL(next.getHref()), DocumentListFeed.class)).getEntries().size() > 0);
        return children;
    }

    @Override
    public String getMimeType() {
        String exportFormat;
        if (this.attributes().isFile() && StringUtils.isNotEmpty((String)(exportFormat = GDPath.getExportFormat(this.getDocumentType())))) {
            return GDPath.getMimeType(exportFormat);
        }
        return super.getMimeType();
    }

    @Override
    public String getExtension() {
        String exportFormat;
        if (this.attributes().isFile() && StringUtils.isNotEmpty((String)(exportFormat = GDPath.getExportFormat(this.getDocumentType())))) {
            return exportFormat;
        }
        return super.getExtension();
    }

    @Override
    public String getName() {
        String exportFormat;
        if (this.attributes().isFile() && StringUtils.isNotEmpty((String)(exportFormat = GDPath.getExportFormat(this.getDocumentType()))) && !super.getName().endsWith(exportFormat)) {
            return super.getName() + "." + exportFormat;
        }
        return super.getName();
    }

    protected static String getExportFormat(String type) {
        if (type.equals("document")) {
            return Preferences.instance().getProperty("google.docs.export.document");
        }
        if (type.equals("presentation")) {
            return Preferences.instance().getProperty("google.docs.export.presentation");
        }
        if (type.equals("spreadsheet")) {
            return Preferences.instance().getProperty("google.docs.export.spreadsheet");
        }
        if (type.equals(DOCUMENT_FILE_TYPE)) {
            log.debug((Object)("No output format conversion for document type:" + type));
            return null;
        }
        log.warn((Object)("Unknown document type:" + type));
        return null;
    }

    @Override
    public void mkdir() {
        if (this.attributes().isDirectory()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Making directory {0}", "Status"), this.getName()));
                FolderEntry folder = new FolderEntry();
                folder.setTitle((TextConstruct)new PlainTextConstruct(this.getName()));
                try {
                    this.getSession().getClient().insert(new URL(((GDPath)this.getParent()).getFolderFeed()), (IEntry)folder);
                }
                catch (ServiceException e) {
                    IOException failure = new IOException(e.getMessage());
                    failure.initCause(e);
                    throw failure;
                }
                this.cache().put(this.getReference(), AttributedList.emptyList());
                this.getParent().invalidate();
            }
            catch (IOException e) {
                this.error("Cannot create folder {0}", e);
            }
        }
    }

    @Override
    public void readUnixPermission() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUnixPermission(Permission perm, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTimestamp(long created, long modified, long accessed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete() {
        try {
            if (this.attributes().isDuplicate()) {
                log.warn((Object)("Cannot delete revision " + this.attributes().getRevision()));
                return;
            }
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
            try {
                this.getSession().getClient().delete(new URL(this.getResourceFeed()), this.attributes().getChecksum());
            }
            catch (ServiceException e) {
                IOException failure = new IOException(e.getMessage());
                failure.initCause(e);
                throw failure;
            }
            catch (MalformedURLException e) {
                IOException failure = new IOException(e.getMessage());
                failure.initCause(e);
                throw failure;
            }
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot delete {0}", e);
        }
    }

    @Override
    public void rename(AbstractPath renamed) {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Renaming {0} to {1}", "Status"), this.getName(), renamed));
            DocumentListEntry moved = new DocumentListEntry();
            moved.setId("https://docs.google.com/feeds/id/" + this.getResourceId());
            if (this.getParent().equals(renamed.getParent())) {
                moved.setTitle((TextConstruct)new PlainTextConstruct(renamed.getName()));
                try {
                    this.getSession().getClient().update(new URL(this.getResourceFeed()), (IEntry)moved, this.attributes().getChecksum());
                }
                catch (ServiceException e) {
                    IOException failure = new IOException(e.getMessage());
                    failure.initCause(e);
                    throw failure;
                }
                catch (MalformedURLException e) {
                    IOException failure = new IOException(e.getMessage());
                    failure.initCause(e);
                    throw failure;
                }
            }
            try {
                DocumentListEntry update = (DocumentListEntry)this.getSession().getClient().insert(new URL(((GDPath)renamed.getParent()).getFolderFeed()), (IEntry)moved);
                this.getSession().getClient().delete(new URL(((GDPath)this.getParent()).getFolderFeed() + "/" + this.getResourceId()), update.getEtag());
            }
            catch (ServiceException e) {
                IOException failure = new IOException(e.getMessage());
                failure.initCause(e);
                throw failure;
            }
            catch (MalformedURLException e) {
                IOException failure = new IOException(e.getMessage());
                failure.initCause(e);
                throw failure;
            }
            renamed.getParent().invalidate();
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot rename {0}", e);
        }
    }

    @Override
    public void touch() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Uploading {0}", "Status"), this.getName()));
                DocumentEntry file = new DocumentEntry();
                file.setTitle((TextConstruct)new PlainTextConstruct(this.getName()));
                try {
                    this.getSession().getClient().insert(new URL(((GDPath)this.getParent()).getFolderFeed()), (IEntry)file);
                }
                catch (ServiceException e) {
                    IOException failure = new IOException(e.getMessage());
                    failure.initCause(e);
                    throw failure;
                }
                this.getParent().invalidate();
            }
            catch (IOException e) {
                this.error("Cannot create file {0}", e);
            }
        }
    }

    @Override
    public String toHttpURL() {
        return this.getDocumentUri();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<GDSession> {
        private Factory() {
        }

        @Override
        protected Path create(GDSession session, String path, int type) {
            return new GDPath(session, path, type);
        }

        @Override
        protected Path create(GDSession session, String parent, String name, int type) {
            return new GDPath(session, parent, name, type);
        }

        @Override
        protected Path create(GDSession session, String parent, Local file) {
            return new GDPath(session, parent, file);
        }

        @Override
        protected <T> Path create(GDSession session, T dict) {
            return new GDPath(session, dict);
        }
    }
}

