/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.gdocs;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Proxy;
import ch.cyberduck.core.ProxyFactory;
import ch.cyberduck.core.ResolveCanceledException;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.ClientLoginAccountType;
import com.google.gdata.client.GoogleAuthTokenFactory;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.client.docs.DocsService;
import com.google.gdata.client.http.GoogleGDataRequest;
import com.google.gdata.client.http.HttpUrlConnectionSource;
import com.google.gdata.data.acl.AclRole;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.common.base.CharEscapers;
import com.google.gdata.util.common.base.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDSession
extends ch.cyberduck.core.ssl.SSLSession {
    private static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(GDSession.class);
    private DocsService client;
    private final Handler appender = new Handler(){

        public void publish(LogRecord record) {
            GDSession.this.log(false, record.getMessage());
        }

        public void flush() {
        }

        public void close() throws SecurityException {
        }
    };
    private static final Logger http = Logger.getLogger("com.google.gdata.client.http.HttpGDataRequest");

    public static SessionFactory factory() {
        return new Factory();
    }

    public GDSession(Host h) {
        super(h);
    }

    protected DocsService getClient() throws ConnectionCanceledException {
        if (null == this.client) {
            throw new ConnectionCanceledException();
        }
        return this.client;
    }

    @Override
    protected void fireConnectionWillOpenEvent() throws ResolveCanceledException, UnknownHostException {
        http.setLevel(Level.FINER);
        http.addHandler(this.appender);
        super.fireConnectionWillOpenEvent();
    }

    @Override
    protected void fireConnectionWillCloseEvent() {
        Logger logger = Logger.getLogger("com.google.gdata.client.http.HttpGDataRequest");
        logger.removeHandler(this.appender);
        super.fireConnectionWillCloseEvent();
    }

    @Override
    protected void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        GoogleGDataRequest.Factory requestFactory = new GoogleGDataRequest.Factory();
        requestFactory.setConnectionSource(new HttpUrlConnectionSource(){

            public HttpURLConnection openConnection(URL url) throws IOException {
                return GDSession.this.getConnection(url);
            }
        });
        GoogleAuthTokenFactory authFactory = new GoogleAuthTokenFactory("writely", this.getUserAgent(), this.host.getProtocol().getScheme(), "www.google.com", (AuthTokenFactory.TokenListener)this.client){

            public String getAuthToken(String username, String password, String captchaToken, String captchaAnswer, String serviceName, String applicationName, ClientLoginAccountType accountType) throws AuthenticationException {
                String postOutput;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("Email", username);
                params.put("Passwd", password);
                params.put("source", applicationName);
                params.put("service", serviceName);
                params.put("accountType", accountType.getValue());
                if (captchaToken != null) {
                    params.put("logintoken", captchaToken);
                }
                if (captchaAnswer != null) {
                    params.put("logincaptcha", captchaAnswer);
                }
                try {
                    URL url = new URL(GDSession.this.host.getProtocol().getScheme() + "://" + "www.google.com" + "/accounts/ClientLogin");
                    postOutput = this.request(url, params);
                }
                catch (IOException e) {
                    AuthenticationException ae = new AuthenticationException(Locale.localizedString("Connection failed", "Error"));
                    ae.initCause((Throwable)e);
                    throw ae;
                }
                HashMap tokenPairs = StringUtil.string2Map((String)postOutput.trim(), (String)"\n", (String)"=", (boolean)true);
                String token = (String)tokenPairs.get("Auth");
                if (token == null) {
                    throw this.getAuthException(tokenPairs);
                }
                return token;
            }

            private AuthenticationException getAuthException(Map<String, String> pairs) {
                String errorName = pairs.get("Error");
                if ("BadAuthentication".equals(errorName)) {
                    return new GoogleService.InvalidCredentialsException("Invalid credentials");
                }
                if ("AccountDeleted".equals(errorName)) {
                    return new GoogleService.AccountDeletedException("Account deleted");
                }
                if ("AccountDisabled".equals(errorName)) {
                    return new GoogleService.AccountDisabledException("Account disabled");
                }
                if ("NotVerified".equals(errorName)) {
                    return new GoogleService.NotVerifiedException("Not verified");
                }
                if ("TermsNotAgreed".equals(errorName)) {
                    return new GoogleService.TermsNotAgreedException("Terms not agreed");
                }
                if ("ServiceUnavailable".equals(errorName)) {
                    return new GoogleService.ServiceUnavailableException("Service unavailable");
                }
                if ("CaptchaRequired".equals(errorName)) {
                    String captchaPath = pairs.get("CaptchaUrl");
                    StringBuilder captchaUrl = new StringBuilder();
                    captchaUrl.append(GDSession.this.host.getProtocol().getScheme()).append("://").append("www.google.com").append("/accounts").append('/').append(captchaPath);
                    return new GoogleService.CaptchaRequiredException("Captcha required", captchaUrl.toString(), pairs.get("CaptchaToken"));
                }
                return new AuthenticationException("Error authenticating (check service name)");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private String request(URL url, Map<String, String> parameters) throws IOException {
                HttpURLConnection urlConnection;
                block8: {
                    urlConnection = GDSession.this.getConnection(url);
                    urlConnection.setDoInput(true);
                    urlConnection.setDoOutput(true);
                    urlConnection.setUseCaches(false);
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    StringBuilder content = new StringBuilder();
                    boolean first = true;
                    for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                        if (!first) {
                            content.append("&");
                        }
                        content.append(CharEscapers.uriEscaper().escape(parameter.getKey())).append("=");
                        content.append(CharEscapers.uriEscaper().escape(parameter.getValue()));
                        first = false;
                    }
                    OutputStream outputStream = null;
                    try {
                        outputStream = urlConnection.getOutputStream();
                        outputStream.write(content.toString().getBytes("utf-8"));
                        outputStream.flush();
                        Object var9_8 = null;
                        if (outputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (outputStream == null) throw throwable;
                        outputStream.close();
                        throw throwable;
                    }
                    outputStream.close();
                }
                InputStream inputStream = null;
                StringBuilder outputBuilder = new StringBuilder();
                try {
                    int responseCode = urlConnection.getResponseCode();
                    inputStream = responseCode == 200 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
                    if (inputStream != null) {
                        String string;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        while (null != (string = reader.readLine())) {
                            outputBuilder.append(string).append('\n');
                        }
                    }
                    Object var13_15 = null;
                    if (inputStream == null) return outputBuilder.toString();
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return outputBuilder.toString();
            }
        };
        this.client = new DocsService(this.getUserAgent(), (Service.GDataRequestFactory)requestFactory, (AuthTokenFactory)authFactory);
        this.client.setReadTimeout(this.timeout());
        this.client.setConnectTimeout(this.timeout());
        if (this.getHost().getProtocol().isSecure()) {
            this.client.useSsl();
        }
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        this.login();
        this.fireConnectionDidOpenEvent();
    }

    protected HttpURLConnection getConnection(URL url) throws IOException {
        Proxy proxy;
        URLConnection c = null;
        if (Preferences.instance().getBoolean("connection.proxy.enable") && (proxy = ProxyFactory.instance()).isHTTPSProxyEnabled(new Host(Protocol.GDOCS_SSL, url.getHost(), url.getPort()))) {
            c = url.openConnection(new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getHTTPSProxyHost(this.host), proxy.getHTTPSProxyPort(this.host))));
        }
        if (null == c) {
            log.debug((Object)"Direct connection");
            c = url.openConnection();
        }
        c.setConnectTimeout(this.timeout());
        c.setReadTimeout(this.timeout());
        if (c instanceof HttpsURLConnection) {
            ((HttpsURLConnection)c).setSSLSocketFactory(new CustomTrustSSLProtocolSocketFactory(this.getTrustManager(url.getHost())));
            ((HttpsURLConnection)c).setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
        }
        if (c instanceof HttpURLConnection) {
            return (HttpURLConnection)c;
        }
        throw new ConnectionCanceledException("Invalid URL connection:" + c);
    }

    @Override
    public String getUserAgent() {
        return Preferences.instance().getProperty("application.name") + "-" + Preferences.instance().getProperty("application.version");
    }

    @Override
    protected void login(LoginController controller, Credentials credentials) throws IOException {
        try {
            this.getClient().setUserCredentials(credentials.getUsername(), credentials.getPassword());
            this.message(Locale.localizedString("Login successful", "Credentials"));
        }
        catch (AuthenticationException e) {
            this.message(Locale.localizedString("Login failed", "Credentials"));
            controller.fail(this.host.getProtocol(), credentials, e.getMessage());
            this.login();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
            }
            Object var2_1 = null;
            this.client = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.client = null;
            this.fireConnectionDidCloseEvent();
            throw throwable;
        }
        this.fireConnectionDidCloseEvent();
    }

    @Override
    public boolean isDownloadResumable() {
        return false;
    }

    @Override
    public boolean isUploadResumable() {
        return false;
    }

    @Override
    public boolean isUnixPermissionsSupported() {
        return false;
    }

    @Override
    public boolean isAclSupported() {
        return true;
    }

    @Override
    public boolean isTimestampSupported() {
        return false;
    }

    @Override
    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Arrays.asList(new Acl.Role(AclRole.OWNER.getValue(), false), new Acl.Role(AclRole.READER.getValue()), new Acl.Role(AclRole.WRITER.getValue()));
    }

    @Override
    public List<Acl.User> getAvailableAclUsers() {
        return Arrays.asList(new Acl.EmailUser(""){

            public String getPlaceholder() {
                return Locale.localizedString("Google Email Address", "Google");
            }
        }, new Acl.DomainUser(""){

            public String getPlaceholder() {
                return Locale.localizedString("Google Apps Domain", "Google");
            }
        }, new Acl.GroupUser("", true){

            public String getPlaceholder() {
                return Locale.localizedString("Google Group Email Address", "Google");
            }
        }, new Acl.CanonicalUser(Locale.localizedString("Public", "Google"), false){

            public String getPlaceholder() {
                return Locale.localizedString("Public", "Google");
            }
        });
    }

    @Override
    public boolean isCDNSupported() {
        return false;
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new GDSession(h);
        }
    }
}

