/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class FireFtpBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static Logger log = Logger.getLogger(FireFtpBookmarkCollection.class);

    public String getBundleIdentifier() {
        return "org.mozdev.fireftp";
    }

    public String getName() {
        return "FireFTP";
    }

    public Local getFile() {
        return LocalFactory.createLocal(Preferences.instance().getProperty("bookmark.import.fireftp.location"));
    }

    protected void parse(Local folder) {
        for (Local settings : folder.children(new PathFilter<Local>(){

            @Override
            public boolean accept(Local file) {
                return file.attributes().isDirectory();
            }
        })) {
            for (Local child : settings.children(new PathFilter<Local>(){

                @Override
                public boolean accept(Local file) {
                    if (file.attributes().isFile()) {
                        return "fireFTPsites.dat".equals(file.getName());
                    }
                    return false;
                }
            })) {
                this.read(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(Local file) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream()));
            try {
                String l;
                while ((l = in.readLine()) != null) {
                    Matcher array = Pattern.compile("\\[(.*?)\\]").matcher(l);
                    while (array.find()) {
                        Matcher entries = Pattern.compile("\\{(.*?)\\}").matcher(array.group(1));
                        while (entries.find()) {
                            String entry = entries.group(1);
                            Host current = new Host(Preferences.instance().getProperty("connection.hostname.default"));
                            current.getCredentials().setUsername(Preferences.instance().getProperty("connection.login.anon.name"));
                            current.setProtocol(Protocol.FTP);
                            for (String attribute : entry.split(", ")) {
                                Scanner scanner = new Scanner(attribute);
                                scanner.useDelimiter(":");
                                if (!scanner.hasNext()) {
                                    log.warn((Object)("Missing key in line:" + attribute));
                                    continue;
                                }
                                String name = scanner.next().toLowerCase();
                                if (!scanner.hasNext()) {
                                    log.warn((Object)("Missing value in line:" + attribute));
                                    continue;
                                }
                                String value = scanner.next().replaceAll("\"", "");
                                if ("host".equals(name)) {
                                    current.setHostname(value);
                                    continue;
                                }
                                if ("port".equals(name)) {
                                    try {
                                        current.setPort(Integer.parseInt(value));
                                    }
                                    catch (NumberFormatException e) {
                                        log.warn((Object)("Invalid Port:" + e.getMessage()));
                                    }
                                    continue;
                                }
                                if ("remotedir".equals(name)) {
                                    current.setDefaultPath(value);
                                    continue;
                                }
                                if ("webhost".equals(name)) {
                                    current.setWebURL(value);
                                    continue;
                                }
                                if ("encoding".equals(name)) {
                                    current.setEncoding(value);
                                    continue;
                                }
                                if ("notes".equals(name)) {
                                    current.setComment(value);
                                    continue;
                                }
                                if ("account".equals(name)) {
                                    current.setNickname(value);
                                    continue;
                                }
                                if ("privatekey".equals(name)) {
                                    current.getCredentials().setIdentity(LocalFactory.createLocal(value));
                                    continue;
                                }
                                if ("pasvmode".equals(name)) {
                                    if (Boolean.TRUE.toString().equals(value)) {
                                        current.setFTPConnectMode(FTPConnectMode.PASV);
                                    }
                                    if (!Boolean.FALSE.toString().equals(value)) continue;
                                    current.setFTPConnectMode(FTPConnectMode.PORT);
                                    continue;
                                }
                                if ("login".equals(name)) {
                                    current.getCredentials().setUsername(value);
                                    continue;
                                }
                                if ("password".equals(name)) {
                                    current.getCredentials().setPassword(value);
                                    continue;
                                }
                                if ("anonymous".equals(name)) {
                                    if (!Boolean.TRUE.toString().equals(value)) continue;
                                    current.getCredentials().setUsername(Preferences.instance().getProperty("connection.login.anon.name"));
                                    continue;
                                }
                                if (!"security".equals(name)) continue;
                                if ("authtls".equals(value)) {
                                    current.setProtocol(Protocol.FTP_TLS);
                                }
                                if (!"sftp".equals(value)) continue;
                                current.setProtocol(Protocol.SFTP);
                            }
                            this.add(current);
                        }
                    }
                }
                Object var17_17 = null;
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                IOUtils.closeQuietly((Reader)in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
            {
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }
}

