/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class FlashFxpBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static Logger log = Logger.getLogger(FlashFxpBookmarkCollection.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(Local file) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream()));
            try {
                String line;
                Host current = null;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("[")) {
                        current = new Host(Preferences.instance().getProperty("connection.hostname.default"));
                        current.getCredentials().setUsername(Preferences.instance().getProperty("connection.login.anon.name"));
                        current.setProtocol(Protocol.FTP);
                        Pattern pattern = Pattern.compile("\\[(.*)\\]");
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.matches()) continue;
                        current.setNickname(matcher.group(1));
                        continue;
                    }
                    if (StringUtils.isBlank((String)line)) {
                        this.add(current);
                        current = null;
                        continue;
                    }
                    if (null == current) {
                        log.warn((Object)"Failed to detect start of bookmark");
                        continue;
                    }
                    Scanner scanner = new Scanner(line);
                    scanner.useDelimiter("=");
                    if (!scanner.hasNext()) {
                        log.warn((Object)("Missing key in line:" + line));
                        continue;
                    }
                    String name = scanner.next().toLowerCase();
                    if (!scanner.hasNext()) {
                        log.warn((Object)("Missing value in line:" + line));
                        continue;
                    }
                    String value = scanner.next();
                    if ("ip".equals(name)) {
                        current.setHostname(value);
                        continue;
                    }
                    if ("port".equals(name)) {
                        try {
                            current.setPort(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            log.warn((Object)("Invalid Port:" + e.getMessage()));
                        }
                        continue;
                    }
                    if ("path".equals(name)) {
                        current.setDefaultPath(value);
                        continue;
                    }
                    if ("notes".equals(name)) {
                        current.setComment(value);
                        continue;
                    }
                    if (!"user".equals(name)) continue;
                    current.getCredentials().setUsername(value);
                }
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                IOUtils.closeQuietly((Reader)in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
            {
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }
}

