/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.serializer.PlistDeserializer;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FlowBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static Logger log = Logger.getLogger(FlowBookmarkCollection.class);

    public String getBundleIdentifier() {
        return "com.extendmac.Flow";
    }

    public Local getFile() {
        return LocalFactory.createLocal(Preferences.instance().getProperty("bookmark.import.flow.location"));
    }

    protected void parse(Local file) {
        NSDictionary serialized = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == serialized) {
            log.error((Object)("Invalid bookmark file:" + file));
            return;
        }
        this.parse(serialized);
    }

    private void parse(NSDictionary serialized) {
        List items = new PlistDeserializer(serialized).listForKey("BookmarkItems");
        for (NSDictionary item : items) {
            PlistDeserializer bookmark = new PlistDeserializer(item);
            String classname = bookmark.stringForKey("ClassName");
            if (null == classname) continue;
            if ("Bookmark".equals(classname)) {
                String protocol;
                String user;
                String name;
                String path;
                String server = bookmark.stringForKey("Server");
                if (null == server) continue;
                Host host = new Host(server);
                String port = bookmark.stringForKey("Port");
                if (StringUtils.isNotBlank((String)port)) {
                    host.setPort(Integer.parseInt(port));
                }
                if (StringUtils.isNotBlank((String)(path = bookmark.stringForKey("InitialPath")))) {
                    host.setDefaultPath(path);
                }
                if (StringUtils.isNotBlank((String)(name = bookmark.stringForKey("Name")))) {
                    host.setNickname(name);
                }
                if (StringUtils.isNotBlank((String)(user = bookmark.stringForKey("Username")))) {
                    host.getCredentials().setUsername(user);
                } else {
                    host.getCredentials().setUsername(Preferences.instance().getProperty("connection.login.anon.name"));
                }
                String mode = bookmark.stringForKey("PreferredFTPDataConnectionType");
                if (StringUtils.isNotBlank((String)mode)) {
                    if ("Passive".equals(mode)) {
                        host.setFTPConnectMode(FTPConnectMode.PASV);
                    }
                    if ("Active".equals(mode)) {
                        host.setFTPConnectMode(FTPConnectMode.PORT);
                    }
                }
                if (StringUtils.isNotBlank((String)(protocol = bookmark.stringForKey("Protocol")))) {
                    try {
                        switch (Integer.parseInt(protocol)) {
                            case 0: {
                                host.setProtocol(Protocol.FTP);
                                break;
                            }
                            case 1: {
                                host.setProtocol(Protocol.SFTP);
                                break;
                            }
                            case 2: {
                                host.setProtocol(Protocol.IDISK);
                                break;
                            }
                            case 3: {
                                host.setProtocol(Protocol.S3_SSL);
                                break;
                            }
                            case 4: {
                                if (host.getPort() == Protocol.WEBDAV_SSL.getDefaultPort()) {
                                    host.setProtocol(Protocol.WEBDAV_SSL);
                                    break;
                                }
                                host.setProtocol(Protocol.WEBDAV);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Unknown protocol:" + e.getMessage()));
                    }
                }
                this.add(host);
            }
            if (!"BookmarkFolder".equals(classname)) continue;
            this.parse(item);
        }
    }
}

