/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.serializer.PlistDeserializer;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class InterarchyBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static Logger log = Logger.getLogger(InterarchyBookmarkCollection.class);

    public String getBundleIdentifier() {
        return "com.nolobe.interarchy";
    }

    public Local getFile() {
        return LocalFactory.createLocal(Preferences.instance().getProperty("bookmark.import.interarchy.location"));
    }

    protected void parse(Local file) {
        NSDictionary serialized = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == serialized) {
            log.error((Object)("Invalid bookmark file:" + file));
            return;
        }
        List items = new PlistDeserializer(serialized).listForKey("Children");
        if (null == items) {
            log.error((Object)("Invalid bookmark file:" + file));
            return;
        }
        for (NSDictionary item : items) {
            this.parse(item);
        }
    }

    private void parse(NSDictionary item) {
        PlistDeserializer bookmark = new PlistDeserializer(item);
        List children = bookmark.listForKey("Children");
        if (null != children) {
            for (NSDictionary child : children) {
                this.parse(child);
            }
            return;
        }
        String url = bookmark.stringForKey("URL");
        if (StringUtils.isBlank((String)url)) {
            return;
        }
        Host host = Host.parse(url);
        if (StringUtils.isBlank((String)host.getHostname())) {
            return;
        }
        String title = bookmark.stringForKey("Title");
        if (StringUtils.isNotBlank((String)title)) {
            host.setNickname(title);
        }
        this.add(host);
    }
}

